/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.worldview.AbstractWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectUpdateEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldEventWrapper;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.LinkedList;
import java.util.Queue;

@AgentScoped
public class EventDrivenWorldView
extends AbstractWorldView
implements IStartableWorldView {
    private Flag<Boolean> running = new Flag<Boolean>(false);
    protected boolean receiveEventProcessing = false;
    protected Queue<IWorldChangeEvent> notifyEventsList = new LinkedList<IWorldChangeEvent>();
    protected IMediator messageSource = null;

    @Inject
    public EventDrivenWorldView(IMediator messageSource, AgentLogger log) {
        super(log);
        this.messageSource = messageSource;
        messageSource.setMediatorOutput(this);
    }

    @Override
    protected void raiseEvent(IWorldEvent event) {
        try {
            super.raiseEvent(event);
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process("exception happend during raising event " + event, e));
            this.stop();
        }
    }

    protected void innerNotify(IWorldChangeEvent event) {
        if (event instanceof IWorldObjectUpdateEvent) {
            IWorldObjectUpdateEvent updateEvent = (IWorldObjectUpdateEvent)event;
            IWorldObject obj = this.getWorldObject(updateEvent.getId());
            if (obj == null) {
                obj = updateEvent.update(null);
                this.addWorldObject(obj);
                this.raiseEvent(new WorldObjectFirstEncounteredEvent<IWorldObject>(obj));
            } else {
                IWorldObject updatedObject = updateEvent.update(obj);
                if (updatedObject == null) {
                    this.removeWorldObject(obj);
                    this.raiseEvent(new WorldObjectDestroyedEvent<IWorldObject>(obj));
                } else {
                    if (updatedObject != obj) {
                        throw new RuntimeException("Update event (class: " + event.getClass() + ") returned different world object, wrong behavior.");
                    }
                    this.objectUpdated(updatedObject);
                }
            }
        } else if (event instanceof IWorldEventWrapper) {
            this.raiseEvent(((IWorldEventWrapper)event).getWorldEvent());
        } else {
            throw new RuntimeException("Unsupported event type received.");
        }
    }

    protected void objectUpdated(IWorldObject obj) {
        this.raiseEvent(new WorldObjectUpdatedEvent<IWorldObject>(obj));
    }

    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        if (!this.running.getFlag().booleanValue()) {
            this.log.severe(this + ": not running but received message");
            this.stop();
            return;
        }
        if (this.receiveEventProcessing) {
            this.notifyEventsList.add(event);
            return;
        }
        this.receiveEventProcessing = true;
        this.innerNotify(event);
        while (this.notifyEventsList.size() != 0) {
            this.innerNotify(this.notifyEventsList.poll());
        }
        this.receiveEventProcessing = false;
    }

    @Override
    public void start() throws PogamutException {
        if (this.running.getFlag().booleanValue()) {
            return;
        }
        this.messageSource.start();
        this.running.setFlag(true);
    }

    @Override
    public void stop() {
        if (!this.running.getFlag().booleanValue()) {
            return;
        }
        this.running.setFlag(false);
        this.messageSource.stop();
    }

    @Override
    public void kill() {
        this.running.setFlag(false);
        this.messageSource.kill();
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }
}

