/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.worldview;

import cz.cuni.amis.pogamut.base.agent.worldview.EventDrivenWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IViewable;
import java.util.HashSet;
import java.util.Set;

public abstract class BatchAwareWorldView
extends EventDrivenWorldView {
    Set<IWorldObject> lastBatch = new HashSet<IWorldObject>();
    Set<IWorldObject> currentBatch = new HashSet<IWorldObject>();

    public BatchAwareWorldView(IMediator messageSource, AgentLogger agentLogger) {
        super(messageSource, agentLogger);
    }

    protected abstract boolean isBatchEndEvent(IWorldChangeEvent var1);

    protected abstract boolean isMutable(IViewable var1);

    protected abstract void setDisappearedFlag(IWorldObject var1);

    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        if (this.isBatchEndEvent(event)) {
            this.lastBatch.removeAll(this.currentBatch);
            for (IWorldObject obj : this.lastBatch) {
                this.setDisappearedFlag(obj);
                this.raiseEvent(new WorldObjectUpdatedEvent<IWorldObject>(obj));
                this.raiseEvent(new WorldObjectDisappearedEvent<IViewable>((IViewable)obj));
            }
            Set<IWorldObject> swp = this.lastBatch;
            this.lastBatch = this.currentBatch;
            this.currentBatch = swp;
            this.currentBatch.clear();
        }
        super.notify(event);
    }

    @Override
    protected void objectUpdated(IWorldObject obj) {
        if (obj instanceof IViewable) {
            IViewable viewable = (IViewable)obj;
            this.currentBatch.add(obj);
            if (!this.lastBatch.contains(obj)) {
                this.raiseEvent(new WorldObjectAppearedEvent<IViewable>(viewable));
                super.objectUpdated(obj);
                return;
            }
            if (!this.isMutable(viewable)) {
                return;
            }
        }
        super.objectUpdated(obj);
    }
}

