/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.worldview;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectId;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IViewable;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@AgentScoped
public abstract class AbstractWorldView
implements IWorldView {
    private ListenerNotifier notifier = new ListenerNotifier();
    private Map worldObjects = Collections.synchronizedMap(new HashMap());
    private Map immutableWorldObjects = Collections.unmodifiableMap(this.worldObjects);
    private Map<IWorldObjectId, IWorldObject> knownObjects = Collections.synchronizedMap(new HashMap());
    private ListenersMap<Class> eventListeners = new ListenersMap();
    private ListenersMap<Class> appearedListeners = new ListenersMap();
    private ListenersMap<Class> disappearedListeners = new ListenersMap();
    private ListenersMap<Class> updatedListeners = new ListenersMap();
    private boolean raiseEventProcessing = false;
    private Queue<IWorldEvent> raiseEventsList = new ConcurrentLinkedQueue<IWorldEvent>();
    private Map<IWorldObjectId, ListenersMap<Class>> objectListeners = new HashMap<IWorldObjectId, ListenersMap<Class>>();
    private Map<Class, ListenersMap<Class>> objectFeatureListeners = new HashMap<Class, ListenersMap<Class>>();
    protected AgentLogger agentLogger;
    protected LogCategory log;

    public AbstractWorldView(AgentLogger logger) {
        this.agentLogger = logger;
        this.log = this.agentLogger.platform();
    }

    protected synchronized <T> Map<IWorldObjectId, T> addNewObjectCategory(Class<T> cls) {
        Map objects = Collections.synchronizedMap(new HashMap());
        this.worldObjects.put(cls, objects);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorldObject(IWorldObject worldObject) {
        this.knownObjects.put(worldObject.getId(), worldObject);
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            Map objects;
            Map map = this.worldObjects;
            synchronized (map) {
                objects = (Map)this.worldObjects.get(cls);
                if (objects == null) {
                    objects = this.addNewObjectCategory(cls);
                }
            }
            objects.put(worldObject.getId(), worldObject);
        }
    }

    protected IWorldObject getWorldObject(IWorldObjectId objectId) {
        return this.knownObjects.get(objectId);
    }

    protected void removeWorldObject(IWorldObject worldObject) {
        this.knownObjects.remove(worldObject.getId());
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            Map objects = (Map)this.worldObjects.get(cls);
            if (objects == null) continue;
            objects.remove(worldObject.getId());
        }
    }

    @Override
    public Map<Class, Map<IWorldObjectId, IWorldObject>> getAll() {
        return this.immutableWorldObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<IWorldObjectId, T> getAll(Class<T> type) {
        Map map = this.worldObjects;
        synchronized (map) {
            Map objects = (Map)this.immutableWorldObjects.get(type);
            if (objects == null) {
                return Collections.unmodifiableMap(this.addNewObjectCategory(type));
            }
            return Collections.unmodifiableMap(objects);
        }
    }

    @Override
    public void addListener(Class<? extends IWorldEvent> event, WorldEventListener<? extends IWorldEvent> listener) {
        this.eventListeners.add(event, listener);
    }

    @Override
    public void addAppearedListener(Class<? extends IViewable> objectClass, WorldObjectEventListener<? extends IViewable> listener) {
        this.appearedListeners.add(objectClass, listener);
    }

    @Override
    public void addDisappearedListener(Class<? extends IViewable> objectClass, WorldObjectEventListener<? extends IViewable> listener) {
        this.disappearedListeners.add(objectClass, listener);
    }

    @Override
    public void addUpdatedListener(Class<? extends IWorldObject> objectClass, WorldObjectEventListener<? extends IWorldObject> listener) {
        this.updatedListeners.add(objectClass, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening(WorldEventListener listener) {
        if (this.eventListeners.isListening(listener)) {
            return true;
        }
        Map<Object, ListenersMap<Class>> map = this.objectListeners;
        synchronized (map) {
            for (ListenersMap<Class> map2 : this.objectListeners.values()) {
                if (!map2.isListening(listener)) continue;
                return true;
            }
        }
        map = this.objectFeatureListeners;
        synchronized (map) {
            for (ListenersMap<Class> map2 : this.objectFeatureListeners.values()) {
                if (!map2.isListening(listener)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Class<? extends IWorldEvent> event, WorldEventListener<? extends IWorldEvent> listener) {
        this.eventListeners.remove(event, listener);
        Map<Object, ListenersMap<Class>> map = this.objectListeners;
        synchronized (map) {
            for (ListenersMap<Class> map2 : this.objectListeners.values()) {
                map2.remove(listener);
            }
        }
        map = this.objectFeatureListeners;
        synchronized (map) {
            for (ListenersMap<Class> map2 : this.objectFeatureListeners.values()) {
                map2.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IWorldObjectId objectId, Class<? extends IWorldObjectEvent> event, WorldEventListener<? extends IWorldObjectEvent> listener) {
        ListenersMap<Class<Object>> listenersMap;
        Map<IWorldObjectId, ListenersMap<Class>> map = this.objectListeners;
        synchronized (map) {
            listenersMap = this.objectListeners.get(objectId);
            if (listenersMap == null) {
                listenersMap = new ListenersMap();
                this.objectListeners.put(objectId, listenersMap);
            }
        }
        listenersMap.add(event, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Class objectFeature, Class<? extends IWorldObjectEvent> event, WorldEventListener<? extends IWorldObjectEvent> listener) {
        ListenersMap<Class<Object>> listenersMap;
        Map<Class, ListenersMap<Class>> map = this.objectFeatureListeners;
        synchronized (map) {
            listenersMap = this.objectFeatureListeners.get(objectFeature);
            if (listenersMap == null) {
                listenersMap = new ListenersMap();
                this.objectFeatureListeners.put(objectFeature, listenersMap);
            }
        }
        listenersMap.add(event, listener);
    }

    private void notifyOnMap(Object event, ListenersMap map) {
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class eventClass : eventClasses) {
            this.notifier.setEvent(event);
            map.notify(eventClass, this.notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRaiseEvent(IWorldEvent event) {
        this.notifyOnMap(event, this.eventListeners);
        if (event instanceof IWorldObjectEvent) {
            ListenersMap<Class> listenersMap;
            IWorldObjectEvent objectEvent = (IWorldObjectEvent)event;
            IWorldObject worldObject = objectEvent.getObject();
            if (event instanceof WorldObjectAppearedEvent) {
                this.notifyOnMap(worldObject, this.appearedListeners);
            }
            if (event instanceof WorldObjectUpdatedEvent) {
                this.notifyOnMap(worldObject, this.updatedListeners);
            }
            if (event instanceof WorldObjectDisappearedEvent) {
                this.notifyOnMap(worldObject, this.disappearedListeners);
            }
            for (Class objectFeature : ClassUtils.getSubclasses(worldObject.getClass())) {
                Map<Class, ListenersMap<Class>> map = this.objectFeatureListeners;
                synchronized (map) {
                    listenersMap = this.objectFeatureListeners.get(objectFeature);
                    if (listenersMap == null) {
                        continue;
                    }
                }
                this.notifyOnMap(event, listenersMap);
            }
            Map<IWorldObjectId, ListenersMap<Class>> map = this.objectListeners;
            synchronized (map) {
                listenersMap = this.objectListeners.get(objectEvent.getId());
                if (listenersMap == null) {
                    return;
                }
            }
            this.notifyOnMap(event, listenersMap);
        }
    }

    protected synchronized void raiseEvent(IWorldEvent event) {
        if (this.raiseEventProcessing) {
            this.raiseEventsList.add(event);
            return;
        }
        this.raiseEventProcessing = true;
        this.innerRaiseEvent(event);
        while (this.raiseEventsList.size() != 0) {
            this.innerRaiseEvent(this.raiseEventsList.poll());
        }
        this.raiseEventProcessing = false;
    }

    private static class ListenerNotifier<T>
    implements Listeners.ListenerNotifier<IListener> {
        private T event = null;

        private ListenerNotifier() {
        }

        public void setEvent(T event) {
            this.event = event;
        }

        @Override
        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }
}

