/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlannerListener;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class SimplePathExecutor<LOC, PATH_ELEMENT>
extends AbstractPathExecutor<LOC> {
    protected PathPlanner planner = null;
    private PathPlannerListener listener = null;
    private List<PATH_ELEMENT> actualPath = null;
    private ListIterator<PATH_ELEMENT> pathIterator = null;
    private PATH_ELEMENT nextPathElement = null;

    public SimplePathExecutor(PathPlanner planner) {
        this.planner = planner;
    }

    @Override
    public void goTo(LOC location) {
        this.listener = new PathPlannerListener<PATH_ELEMENT>(){

            @Override
            public void pathEvent(List<PATH_ELEMENT> path) {
                SimplePathExecutor.this.pathReceived(path);
            }
        };
        this.planner.addPathListener(this.listener);
        try {
            List path = this.planner.computePath(this.getAgentLocation(), location);
            this.pathReceived(path);
        }
        catch (PathNotConstructable ex) {
            this.fireEvent(PathEventType.TARGET_UNREACHABLE);
        }
    }

    protected PATH_ELEMENT getNextPathElement() {
        return this.nextPathElement;
    }

    protected Iterator<PATH_ELEMENT> getPathIterator() {
        return this.actualPath.listIterator(this.pathIterator.nextIndex());
    }

    private void pathReceived(List<PATH_ELEMENT> path) {
        this.actualPath = path;
        if (path != null) {
            this.pathIterator = path.listIterator();
            this.moveToNext();
        }
    }

    protected void moveToNext() {
        try {
            if (this.pathIterator.hasNext()) {
                this.nextPathElement = this.pathIterator.next();
                this.issueMotoricCommands();
            } else {
                this.nextPathElement = null;
                this.fireEvent(PathEventType.TARGET_REACHED);
            }
        }
        catch (PogamutException ex) {
            this.fireEvent(PathEventType.FAILURE);
        }
    }

    protected abstract LOC getAgentLocation();

    public boolean isMoving() {
        return this.nextPathElement != null;
    }

    protected abstract void issueMotoricCommands() throws PogamutException;
}

