/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogComponent;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IHasAction;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogImage
extends DialogComponent
implements IHasAction {
    protected String action;
    protected String image;
    protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
    protected Point2D origin;
    protected Dimension2D scale;

    public DialogImage() {
    }

    public DialogImage(String id) {
        super(id);
    }

    @Override
    public void addListener(IDialogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<DialogItem> createItemCommands() {
        LinkedList<DialogItem> list = new LinkedList<DialogItem>();
        list.add(this.myItemCommand());
        return list;
    }

    @Override
    public void dialogCancelled(Dialog dialog, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogCancelled(dialog, data);
        }
    }

    @Override
    public void dialogCommand(Dialog dialog, String command, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogCommand(dialog, command, data);
        }
    }

    @Override
    public void dialogSubmitted(Dialog dialog, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogSubmitted(dialog, data);
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getImage() {
        return this.image;
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public Dimension2D getScale() {
        return this.scale;
    }

    @Override
    protected DialogItem myItemCommand() {
        DialogItem myItem = super.myItemCommand();
        myItem.setType("IMAGE");
        myItem.setImage(this.image);
        myItem.setOrigin(this.origin);
        myItem.setScale(this.scale);
        myItem.setAction(this.action);
        return myItem;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setOrigin(Point2D origin) {
        this.origin = origin;
    }

    public void setScale(Dimension2D scale) {
        this.scale = scale;
    }
}

