/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogFramedComponent;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IHasAction;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogButton
extends DialogFramedComponent
implements IHasAction {
    protected String action;
    protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
    protected String text;
    protected Color textColor;

    public DialogButton() {
    }

    public DialogButton(String id) {
        super(id);
    }

    @Override
    public void addListener(IDialogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<DialogItem> createItemCommands() {
        LinkedList<DialogItem> list = new LinkedList<DialogItem>();
        list.add(this.myItemCommand());
        return list;
    }

    @Override
    public void dialogCancelled(Dialog dialog, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogCancelled(dialog, data);
        }
    }

    @Override
    public void dialogCommand(Dialog dialog, String command, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogCommand(dialog, command, data);
        }
    }

    @Override
    public void dialogSubmitted(Dialog dialog, Map<String, String> data) {
        for (IDialogListener c : this.listeners) {
            c.dialogSubmitted(dialog, data);
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    protected DialogItem myItemCommand() {
        DialogItem myItem = super.myItemCommand();
        myItem.setType("BUTTON");
        myItem.setAction(this.action);
        myItem.setText(this.text);
        myItem.setTextColor(this.textColor);
        return myItem;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }
}

