/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogBegin;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;
import cz.cuni.amis.pogamut.ut2004.server.commands.PlayerCommunication;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogComponent;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogPanel;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.IHasAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialog {
    private static int dialogCount = 0;
    protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
    protected Map<String, String> data;
    protected boolean displayed = false;
    protected boolean finished = false;
    private String id;
    protected DialogPanel mainPanel;
    protected String targetPlayer;
    protected PlayerCommunication playerCommunication;

    public static final String cleanEscaped(String unclean) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < unclean.length(); ++i) {
            char c = unclean.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    escaped = false;
                    sb.append('\\');
                    continue;
                }
                escaped = true;
                continue;
            }
            escaped = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static final List<String> splitEscaped(String s, char delim, int max) {
        LinkedList<String> list = new LinkedList<String>();
        if (s.isEmpty()) {
            return list;
        }
        int prev = -1;
        int i = -1;
        while ((i = s.indexOf(delim, i + 1)) != -1) {
            int bs = 0;
            for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                ++bs;
            }
            if (bs % 2 == 0) {
                list.add(s.substring(prev + 1, i));
                prev = i;
            }
            if (list.size() < max - 1) continue;
            break;
        }
        list.add(s.substring(prev + 1));
        return list;
    }

    public Dialog() {
        this.id = "d" + ++dialogCount;
    }

    public Dialog(String id) {
        ++dialogCount;
        this.id = id;
    }

    public DialogBegin createBeginCommand() {
        DialogBegin begin = new DialogBegin();
        begin.setPlayer(this.targetPlayer);
        begin.setId(this.id);
        return begin;
    }

    public DialogEnd createEndCommand() {
        DialogEnd end = new DialogEnd();
        end.setPlayer(this.targetPlayer);
        end.setId(this.id);
        return end;
    }

    public List<DialogItem> createItemCommands() {
        if (this.mainPanel != null) {
            return this.mainPanel.createItemCommands();
        }
        throw new IllegalStateException("Main panel not set!");
    }

    public DialogComponent findComponent(String id) {
        return this.mainPanel.findComponent(id);
    }

    public String getId() {
        return this.id;
    }

    public DialogPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getTargetPlayer() {
        return this.targetPlayer;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean processCommand(String sourceId, String command) {
        DialogComponent component = this.findComponent(sourceId);
        if (command.equalsIgnoreCase("SUBMIT")) {
            if (component instanceof IHasAction) {
                ((IHasAction)((Object)component)).dialogSubmitted(this, this.data);
            }
            for (IDialogListener listener : this.listeners) {
                listener.dialogSubmitted(this, this.data);
            }
            this.finished = true;
            return true;
        }
        if (command.equalsIgnoreCase("CANCEL")) {
            if (component instanceof IHasAction) {
                ((IHasAction)((Object)component)).dialogCancelled(this, this.data);
            }
            for (IDialogListener listener : this.listeners) {
                listener.dialogCancelled(this, this.data);
            }
            this.finished = true;
            return true;
        }
        if (component instanceof IHasAction) {
            ((IHasAction)((Object)component)).dialogCommand(this, command, this.data);
        }
        for (IDialogListener listener : this.listeners) {
            listener.dialogCommand(this, command, this.data);
        }
        return false;
    }

    public void addListener(IDialogListener listener) {
        this.listeners.add(listener);
    }

    public void setData(String data) {
        List<String> pairs = Dialog.splitEscaped(data, '&', Integer.MAX_VALUE);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs) {
            List<String> pl = Dialog.splitEscaped(pair, '=', 2);
            map.put(Dialog.cleanEscaped(pl.get(0)), Dialog.cleanEscaped(pl.get(1)));
        }
        this.data = Collections.unmodifiableMap(map);
    }

    public void setMainPanel(DialogPanel panel) {
        this.mainPanel = panel;
    }

    public void setTargetPlayer(String targetPlayer) {
        this.targetPlayer = targetPlayer;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed() {
        this.displayed = true;
    }

    public void setPlayerCommunication(PlayerCommunication playerCommunication) {
        this.playerCommunication = playerCommunication;
    }

    public PlayerCommunication getPlayerCommunication() {
        return this.playerCommunication;
    }
}

