/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.commands;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogBegin;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogCancel;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PlaySound;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetSendKeys;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ShowText;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.DialogCommand;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.KeyEvent;
import cz.cuni.amis.pogamut.ut2004.server.AbstractUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.commands.IKeyEventListener;
import cz.cuni.amis.pogamut.ut2004.server.commands.ServerCommands;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PlayerCommunication
extends ServerCommands {
    protected DialogCommandListener dialogCommandListener;
    protected KeyEventListener keyEventListener;
    protected Map<String, Dialog> dialogs = new HashMap<String, Dialog>();
    protected Map<String, List<IKeyEventListener>> keyListenersMap = new HashMap<String, List<IKeyEventListener>>();

    public PlayerCommunication(AbstractUT2004Server server, Logger log) {
        super(server, log);
        this.dialogCommandListener = new DialogCommandListener((IWorldView)server.getWorldView());
        this.keyEventListener = new KeyEventListener((IWorldView)server.getWorldView());
    }

    public void showDialog(Dialog dialog) {
        if (dialog.isDisplayed() || dialog.isFinished()) {
            throw new IllegalStateException("This dialog was already used.");
        }
        if (dialog.getTargetPlayer() == null) {
            throw new IllegalStateException("No player specified");
        }
        dialog.setPlayerCommunication(this);
        DialogBegin begin = dialog.createBeginCommand();
        this.server.getAct().act((CommandMessage)begin);
        List<DialogItem> items = dialog.createItemCommands();
        for (DialogItem itemCommand : items) {
            itemCommand.setPlayer(dialog.getTargetPlayer());
            this.server.getAct().act((CommandMessage)itemCommand);
        }
        DialogEnd end = dialog.createEndCommand();
        this.server.getAct().act((CommandMessage)end);
        dialog.setDisplayed();
        this.dialogs.put(dialog.getId(), dialog);
    }

    public void removeDialog(Dialog dialog) {
        DialogCancel dialogCancel = new DialogCancel();
        dialogCancel.setId(dialog.getId());
        dialogCancel.setPlayer(dialog.getTargetPlayer());
        this.server.getAct().act((CommandMessage)dialogCancel);
        this.dialogs.remove(dialog.getId());
    }

    public void updateDialog(Dialog dialog) {
        this.updateDialogComponent(dialog, dialog.getMainPanel());
    }

    public void updateDialogComponent(Dialog dialog, DialogComponent component) {
        List<DialogItem> items = component.createItemCommands();
        for (DialogItem itemCommand : items) {
            itemCommand.setPlayer(dialog.getTargetPlayer());
            itemCommand.setDialogId(dialog.getId());
            itemCommand.setEffect("EDIT");
            this.server.getAct().act((CommandMessage)itemCommand);
        }
    }

    public void playSound(String playerName, String sound) {
        PlaySound playSound = new PlaySound();
        playSound.setPlayer(playerName);
        playSound.setSound(sound);
        this.server.getAct().act((CommandMessage)playSound);
    }

    public void removeText(String playerName, String message) {
        ShowText showText = new ShowText();
        showText.setPlayer(playerName);
        showText.setText(message);
        showText.setShow(false);
        this.server.getAct().act((CommandMessage)showText);
    }

    public void addKeyEventListener(String playerName, IKeyEventListener listener) {
        List<IKeyEventListener> list = this.keyListenersMap.get(playerName);
        if (list == null) {
            list = new ArrayList<IKeyEventListener>();
            this.keyListenersMap.put(playerName, list);
        }
        if (list.size() == 0) {
            SetSendKeys setSendKeys = new SetSendKeys();
            setSendKeys.setPlayer(playerName);
            setSendKeys.setSend(true);
            this.server.getAct().act((CommandMessage)setSendKeys);
        }
        list.add(listener);
    }

    public void removeKeyEventListener(String playerName, IKeyEventListener listener) {
        List<IKeyEventListener> list = this.keyListenersMap.get(playerName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            SetSendKeys setSendKeys = new SetSendKeys();
            setSendKeys.setPlayer(playerName);
            setSendKeys.setSend(false);
            this.server.getAct().act((CommandMessage)setSendKeys);
        }
    }

    public void showText(String playerName, String message) {
        this.showText(playerName, message, 0.0, new Color(255, 255, 255));
    }

    public void showText(String playerName, String message, double timeout) {
        this.showText(playerName, message, timeout, new Color(255, 255, 255));
    }

    public void showText(String playerName, String message, double timeout, Color color) {
        ShowText showText = new ShowText();
        showText.setPlayer(playerName);
        showText.setShow(true);
        showText.setText(message);
        showText.setTextColor(color);
        showText.setTime(timeout);
        this.server.getAct().act((CommandMessage)showText);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeyEventListener
    implements WorldEventListener<KeyEvent> {
        public KeyEventListener(IWorldView worldView) {
            worldView.addListener(KeyEvent.class, (WorldEventListener)this);
        }

        public void notify(KeyEvent event) {
            List<IKeyEventListener> list = PlayerCommunication.this.keyListenersMap.get(event.getPlayer());
            if (list == null) {
                return;
            }
            for (IKeyEventListener listener : list) {
                if (event.getAction().equalsIgnoreCase("PRESS")) {
                    listener.keyPressed(event.getKey());
                    continue;
                }
                if (event.getAction().equalsIgnoreCase("RELEASE")) {
                    listener.keyReleased(event.getKey());
                    continue;
                }
                if (!event.getAction().equalsIgnoreCase("HOLD")) continue;
                listener.keyHeld(event.getKey());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DialogCommandListener
    implements WorldEventListener<DialogCommand> {
        public DialogCommandListener(IWorldView worldView) {
            worldView.addListener(DialogCommand.class, (WorldEventListener)this);
        }

        public void notify(DialogCommand event) {
            Dialog dialog = PlayerCommunication.this.dialogs.get(event.getId());
            if (dialog == null) {
                throw new IllegalArgumentException("No apropriate dialog found!");
            }
            dialog.setData(event.getData());
            if (dialog.processCommand(event.getSourceId(), event.getCommand())) {
                PlayerCommunication.this.dialogs.remove(event.getId());
            }
        }
    }
}

