/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMXProxy;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.DefaultUT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetGameSpeed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MutatorListObtained;
import cz.cuni.amis.pogamut.ut2004.server.AbstractUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.TranslatedObservableCollection;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public class UT2004Server
extends AbstractUT2004Server<IStartableWorldView>
implements IUT2004Server {
    ObservableCollection<IAgent> pogamutAgents = new TranslatedObservableCollection<IAgent, Player>(this.players){

        protected IAgent translate(Player obj) {
            try {
                return new AgentJMXProxy(obj.getJmx());
            }
            catch (Exception ex) {
                Logger.getLogger(UT2004Server.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
    };
    protected WorldEventListener<PlayerJoinsGame> playerJoinsListener = null;
    protected WorldEventListener<MapListObtained> mapListListener = null;

    @Inject
    public UT2004Server(AgentLogger logger, DefaultUT2004WorldView worldView, ICommandSerializer act) {
        super(logger, worldView, act);
    }

    @Override
    protected void prePrepareServer() {
        this.getWorldView().addListener(MutatorListObtained.class, (WorldEventListener)new WorldEventListener<MutatorListObtained>(){

            public void notify(MutatorListObtained event) {
                UT2004Server.this.mutators = event.getMutators();
            }
        });
        this.gameSpeed.addListener((FlagListener)new FlagListener<Double>(){

            public void flagChanged(Double changedValue) {
                UT2004Server.this.getAct().act((CommandMessage)new SetGameSpeed(changedValue));
            }
        });
        this.mapListListener = new WorldEventListener<MapListObtained>(){

            public void notify(MapListObtained event) {
                UT2004Server.this.maps = event.getMaps();
                UT2004Server.this.setAgentState(AgentStateType.RUNNING, "Control server connection is up and running.");
                UT2004Server.this.getAct().act((CommandMessage)new StartPlayers(true, true, true));
            }
        };
        this.getWorldView().addListener(MapListObtained.class, (WorldEventListener)this.mapListListener);
    }
}

