/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.server.AbstractWorldServer;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetMaps;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.PlayerListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exceptions.MapChangeException;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ElementListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import cz.cuni.amis.utils.collections.adapters.WVVisibleObjectsSetAdapter;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public abstract class AbstractUT2004Server<WORLD_VIEW extends IStartableWorldView>
extends AbstractWorldServer<WORLD_VIEW, IAgent>
implements IUT2004Server {
    ObservableCollection<Player> players = null;
    List<Mutator> mutators = null;
    Flag<Double> gameSpeed = new Flag();
    List<MapList> maps = null;
    ObservableCollection<AbstractUT2004Bot> agents = null;
    private String desiredPassword = null;
    private WorldEventListener<PlayerListObtained> playerListObtainedListener = new WorldEventListener<PlayerListObtained>(){

        public void notify(PlayerListObtained event) {
            AbstractUT2004Server.this.players.addAll(event.getPlayers());
        }
    };
    private WorldEventListener<MapPointListObtained> mapPointListObtainedListener = new WorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            AbstractUT2004Server.this.getAct().act((CommandMessage)new GetMaps());
        }
    };
    private WorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new WorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUT2004Server.this.setAgentState(AgentStateType.INIT, "GameBots2004 greeted us, adding custom listeners onto the worldview");
            AbstractUT2004Server.this.setAgentStateDescription("Calling prePrepareServer()");
            AbstractUT2004Server.this.prePrepareServer();
            AbstractUT2004Server.this.setAgentStateDescription("prePrepareServer() finished, sending READY");
            AbstractUT2004Server.this.readyCommandRequested();
            AbstractUT2004Server.this.setAgentStateDescription("READY sent.");
        }
    };
    private PasswordReply passwordReply = null;
    private WorldEventListener<Password> passwordRequestedListener = new WorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUT2004Server.this.setAgentStateDescription("Password requested by the world.");
            AbstractUT2004Server.this.passwordReply = AbstractUT2004Server.this.createPasswordReply();
            if (AbstractUT2004Server.this.passwordReply == null) {
                AbstractUT2004Server.this.passwordReply = new PasswordReply("");
            }
            AbstractUT2004Server.this.getLogger().platform().info("Password required for the world, replying with '" + AbstractUT2004Server.this.passwordReply.getPassword() + "'.");
            AbstractUT2004Server.this.getAct().act((CommandMessage)AbstractUT2004Server.this.passwordReply);
        }
    };
    private GameInfo gameInfo = null;
    private WorldEventListener<GameInfo> gameInfoListener = new WorldEventListener<GameInfo>(){

        public void notify(GameInfo event) {
            AbstractUT2004Server.this.gameInfo = event;
            AbstractUT2004Server.this.getWorldView().removeListener(GameInfo.class, (WorldEventListener)this);
        }
    };

    @Inject
    public AbstractUT2004Server(AgentLogger logger, WORLD_VIEW worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
        this.getWorldView().addListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addListener(GameInfo.class, this.gameInfoListener);
        this.getWorldView().addListener(PlayerListObtained.class, this.playerListObtainedListener);
        this.getWorldView().addListener(MapPointListObtained.class, this.mapPointListObtainedListener);
        this.players = new WVVisibleObjectsSetAdapter(Player.class, this.getWorldView());
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected abstract void prePrepareServer();

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public void start() throws AgentException {
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            FlagListener<AgentState> okListener = new FlagListener<AgentState>(){

                public void flagChanged(AgentState changedValue) {
                    if (changedValue.getType().isOKState()) {
                        latch.countDown();
                    }
                }
            };
            this.getAgentState().addListener((FlagListener)okListener);
            super.start();
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new AgentException("Interrupted waiting for initialization.", (Object)ex);
        }
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)super.getWorldView();
    }

    public void pause() throws AgentException {
    }

    public void resume() throws AgentException {
    }

    @Override
    public Collection<MapList> getAvailableMaps() {
        return this.maps;
    }

    @Override
    public Flag<Double> getGameSpeedFlag() {
        return this.gameSpeed;
    }

    @Override
    public ImmutableFlag<String> getMapFlag() {
        return null;
    }

    @Override
    public ObservableCollection<Player> getPlayers() {
        return this.players;
    }

    @Override
    public void setGameMap(String map) throws MapChangeException {
        this.getAct().act((CommandMessage)new ChangeMap(map));
    }

    @Override
    public List<Mutator> getMutators() {
        return this.mutators;
    }

    public ObservableCollection<IAgent> getAgents() {
        if (this.getPlayers() == null) {
            return null;
        }
        return null;
    }

    @Override
    public void connectNativeBot(String botName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AgentsList
    extends ObservableList<AbstractUT2004Bot> {
        public AgentsList(ObservableCollection<Player> players) {
            super(new ArrayList());
            players.addCollectionListener((CollectionEventListener)new ElementListener(){

                public void elementChanged(Object elem, boolean added) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
        }
    }
}

