/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.exceptions.BotAlreadyStartedException;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.BotFirstSpawned;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public abstract class ThreadedUT2004Bot<WorldView extends IStartableWorldView>
extends AbstractUT2004Bot<WorldView> {
    private CountDownLatch logicStartLatch = new CountDownLatch(1);
    protected Flag<Boolean> logicAlive = new Flag((Object)false);
    protected boolean logicShouldBeAlive = true;
    protected Flag<Boolean> logicShouldRun = new Flag((Object)true);
    protected Flag<Boolean> logicRunning = new Flag((Object)true);
    protected Thread logicThread = null;
    private long logicPeriodMillis = 100L;
    private long lastLogicRunMillis = -99999999L;
    private Flag<Boolean> botAlive = new Flag((Object)false);
    private WorldEventListener<BotFirstSpawned> firstSpawnListener = new WorldEventListener<BotFirstSpawned>(){

        public void notify(BotFirstSpawned event) {
            ThreadedUT2004Bot.this.getWorldView().removeListener(BotFirstSpawned.class, (WorldEventListener)this);
            ThreadedUT2004Bot.this.setAgentState(AgentStateType.RUNNING, "Bot is running.");
            ThreadedUT2004Bot.this.botAlive.setFlag((Object)true);
            ThreadedUT2004Bot.this.logicStartLatch.countDown();
        }
    };
    private WorldEventListener<Spawn> spawnListener = new WorldEventListener<Spawn>(){

        public void notify(Spawn event) {
            ThreadedUT2004Bot.this.getLogger().user().warning("Bot spawned.");
            ThreadedUT2004Bot.this.botAlive.setFlag((Object)true);
            if (((AgentState)ThreadedUT2004Bot.this.getAgentState().getFlag()).getType() == AgentStateType.RUNNING) {
                ThreadedUT2004Bot.this.setAgentStateDescription("Bot is running.");
            }
        }
    };
    private WorldEventListener<BotKilled> killedListener = new WorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            ThreadedUT2004Bot.this.getLogger().user().warning("Bot killed.");
            ThreadedUT2004Bot.this.botAlive.setFlag((Object)false);
            if (((AgentState)ThreadedUT2004Bot.this.getAgentState().getFlag()).getType() == AgentStateType.RUNNING) {
                ThreadedUT2004Bot.this.setAgentStateDescription("Bot killed.");
            }
            ThreadedUT2004Bot.this.botKilled(event);
        }
    };

    @Inject
    public ThreadedUT2004Bot(AgentLogger logger, WorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
        this.getWorldView().addListener(BotFirstSpawned.class, this.firstSpawnListener);
        this.getWorldView().addListener(Spawn.class, this.spawnListener);
        this.getWorldView().addListener(BotKilled.class, this.killedListener);
    }

    public long getLastLogicRunMillis() {
        return this.lastLogicRunMillis;
    }

    public long getLogicPeriodMillis() {
        return this.logicPeriodMillis;
    }

    public void setLogicPeriodMillis(long logicPeriodMillis) {
        this.logicPeriodMillis = logicPeriodMillis;
    }

    public ImmutableFlag<Boolean> getBotAlive() {
        return this.botAlive.getImmutable();
    }

    public synchronized void pause() throws AgentException {
        this.logicShouldRun.setFlag((Object)false);
        try {
            new WaitForFlagChange(this.logicRunning, (Object)false).await();
        }
        catch (InterruptedException e) {
            throw new AgentException("Interrupted during waiting for the logic thread to end.", (Logger)this.getLogger().platform(), (Object)this);
        }
    }

    public synchronized void resume() throws AgentException {
        this.logicShouldRun.setFlag((Object)true);
        try {
            new WaitForFlagChange(this.logicRunning, (Object)true).await();
        }
        catch (InterruptedException e) {
            throw new AgentException("Interrupted during waiting for the logic thread to be resumed", (Logger)this.getLogger().platform(), (Object)this);
        }
    }

    @Override
    public synchronized void start() throws AgentException {
        if (this.logicThread != null) {
            throw new BotAlreadyStartedException((Object)((Object)this) + " has already been started before", (Logger)this.getLogger().platform(), (Object)this);
        }
        super.start();
        this.logicThread = new Thread((Runnable)new LogicThread(), (Object)((Object)this) + " logic thread");
        this.logicThread.start();
        try {
            new WaitForFlagChange(this.logicRunning, (Object)true).await();
        }
        catch (InterruptedException e) {
            throw new AgentException("Interrupted during waiting for the logic to start.", (Object)this.getLogger().platform());
        }
    }

    @Override
    public void stop() {
        this.logicShouldBeAlive = false;
        try {
            this.logicStartLatch.countDown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.resume();
        }
        catch (AgentException e1) {
            // empty catch block
        }
        super.stop();
        this.botAlive.setFlag((Object)true);
        try {
            new WaitForFlagChange(this.logicAlive, (Object)false).await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void kill() {
        new Job(){

            protected void job() throws Exception {
                ThreadedUT2004Bot.this.stop();
            }
        }.startJob();
        this.logicThread.interrupt();
    }

    protected void logicThreadCreated() throws PogamutException {
        try {
            this.logicStartLatch.await();
        }
        catch (InterruptedException e) {
            throw new AgentException("interrupted during the waiting for the INIT command to be sent", (Throwable)e, (Object)this.getLogger().platform());
        }
    }

    protected abstract void doBotLogic() throws PogamutException;

    protected abstract void botKilled(BotKilled var1);

    private class LogicThread
    implements Runnable {
        private LogicThread() {
        }

        private void stopping(AgentStateType state, String description) {
            ThreadedUT2004Bot.this.logicShouldBeAlive = false;
            ThreadedUT2004Bot.this.logicAlive.setFlag((Object)false);
            if (!((AgentState)ThreadedUT2004Bot.this.getAgentState().getFlag()).getType().isEndState()) {
                ThreadedUT2004Bot.this.setAgentState(state, description);
            }
            ThreadedUT2004Bot.this.getLogger().platform().warning("Logic thread terminated");
        }

        public void run() {
            block15: {
                ThreadedUT2004Bot.this.logicAlive.setFlag((Object)true);
                ThreadedUT2004Bot.this.getLogger().platform().fine("Logic thread created");
                try {
                    ThreadedUT2004Bot.this.logicThreadCreated();
                }
                catch (PogamutException e) {
                    e.logExceptionOnce((Logger)ThreadedUT2004Bot.this.getLogger().platform());
                    this.stopping(AgentStateType.FAILED, e.getMessage());
                    return;
                }
                catch (PogamutRuntimeException e) {
                    e.logExceptionOnce((Logger)ThreadedUT2004Bot.this.getLogger().platform());
                    this.stopping(AgentStateType.FAILED, e.getMessage());
                    return;
                }
                catch (Exception e) {
                    ThreadedUT2004Bot.this.getLogger().platform().severe(ExceptionToString.process((String)"Exception occured in logicThreadCreated()", (Exception)e));
                    this.stopping(AgentStateType.FAILED, e.getMessage());
                    return;
                }
                ThreadedUT2004Bot.this.getLogger().platform().warning("Logic thread running");
                ThreadedUT2004Bot.this.logicRunning.setFlag((Object)true);
                try {
                    while (ThreadedUT2004Bot.this.logicShouldBeAlive && !Thread.interrupted()) {
                        if (!((Boolean)ThreadedUT2004Bot.this.logicShouldRun.getFlag()).booleanValue()) {
                            ThreadedUT2004Bot.this.logicRunning.setFlag((Object)false);
                            ThreadedUT2004Bot.this.setAgentState(AgentStateType.PAUSED, "Bot is paused.");
                            new WaitForFlagChange(ThreadedUT2004Bot.this.logicShouldRun, (Object)true).await();
                            ThreadedUT2004Bot.this.logicRunning.setFlag((Object)true);
                            ThreadedUT2004Bot.this.setAgentState(AgentStateType.RUNNING, (Boolean)ThreadedUT2004Bot.this.getBotAlive().getFlag() != false ? "Bot is running." : "Bot killed.");
                        }
                        if (System.currentTimeMillis() - ThreadedUT2004Bot.this.lastLogicRunMillis < ThreadedUT2004Bot.this.logicPeriodMillis) {
                            Thread.sleep(ThreadedUT2004Bot.this.logicPeriodMillis - (System.currentTimeMillis() - ThreadedUT2004Bot.this.lastLogicRunMillis));
                        }
                        ThreadedUT2004Bot.this.lastLogicRunMillis = System.currentTimeMillis();
                        if (!((Boolean)ThreadedUT2004Bot.this.getBotAlive().getFlag()).booleanValue()) {
                            new WaitForFlagChange(ThreadedUT2004Bot.this.getBotAlive(), (Object)true).await();
                        }
                        if (ThreadedUT2004Bot.this.logicShouldBeAlive && !Thread.interrupted()) {
                            ThreadedUT2004Bot.this.doBotLogic();
                            continue;
                        }
                        break;
                    }
                }
                catch (PogamutException e) {
                    if (ThreadedUT2004Bot.this.logicShouldBeAlive) {
                        e.logExceptionOnce((Logger)ThreadedUT2004Bot.this.getLogger().platform());
                        ThreadedUT2004Bot.this.setAgentState(AgentStateType.FAILED, e.getMessage());
                    }
                }
                catch (PogamutRuntimeException e) {
                    if (ThreadedUT2004Bot.this.logicShouldBeAlive) {
                        e.logExceptionOnce((Logger)ThreadedUT2004Bot.this.getLogger().platform());
                        ThreadedUT2004Bot.this.setAgentState(AgentStateType.FAILED, e.getMessage());
                    }
                }
                catch (Exception e) {
                    if (!ThreadedUT2004Bot.this.logicShouldBeAlive) break block15;
                    ThreadedUT2004Bot.this.getLogger().platform().severe(ExceptionToString.process((String)"exception occured during the logic of the agent", (Exception)e));
                    ThreadedUT2004Bot.this.setAgentState(AgentStateType.FAILED, e.getMessage());
                }
            }
            this.stopping(AgentStateType.END, "Bot stopped");
        }
    }
}

