/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentRuntimeException;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.InitCommandRequest;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.ReadyCommandRequest;
import cz.cuni.amis.utils.flag.FlagListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public abstract class AbstractUT2004Bot<WORLD_VIEW extends IStartableWorldView>
extends AbstractEmbodiedAgent<WORLD_VIEW> {
    private String desiredPassword = null;
    private FlagListener<Boolean> runningListener = new FlagListener<Boolean>(){

        public void flagChanged(Boolean changedValue) {
            if (!changedValue.booleanValue() && !AbstractUT2004Bot.this.stopCalled) {
                AbstractUT2004Bot.this.stop();
            }
        }
    };
    private boolean stopCalled = false;
    private WorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new WorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUT2004Bot.this.setAgentState(AgentStateType.INIT, "GameBots2004 greeted us, adding custom listeners onto the worldview");
            AbstractUT2004Bot.this.setAgentStateDescription("Calling prePrepareBot()");
            AbstractUT2004Bot.this.prePrepareBot();
            AbstractUT2004Bot.this.setAgentStateDescription("prePrepareBot() finished, sending READY");
            AbstractUT2004Bot.this.readyCommandRequested();
            AbstractUT2004Bot.this.setAgentStateDescription("READY sent, handshaking.");
        }
    };
    private Initialize initializeCommand = null;
    private WorldEventListener<InitCommandRequest> initCommandRequestListener = new WorldEventListener<InitCommandRequest>(){

        public void notify(InitCommandRequest event) {
            AbstractUT2004Bot.this.setAgentStateDescription("Handshake over, calling postPrepareBot()");
            AbstractUT2004Bot.this.postPrepareBot(AbstractUT2004Bot.this.getGameInfo());
            AbstractUT2004Bot.this.setAgentStateDescription("postPrepareBot() finished, sending INIT command");
            AbstractUT2004Bot.this.initCommandRequested();
        }
    };
    private PasswordReply passwordReply = null;
    private WorldEventListener<Password> passwordRequestedListener = new WorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUT2004Bot.this.setAgentStateDescription("Password requested by the world.");
            AbstractUT2004Bot.this.passwordReply = AbstractUT2004Bot.this.createPasswordReply();
            if (AbstractUT2004Bot.this.passwordReply == null) {
                AbstractUT2004Bot.this.passwordReply = new PasswordReply("");
            }
            AbstractUT2004Bot.this.getLogger().platform().info("Password required for the world, replying with '" + AbstractUT2004Bot.this.passwordReply.getPassword() + "'.");
            AbstractUT2004Bot.this.getAct().act((CommandMessage)AbstractUT2004Bot.this.passwordReply);
        }
    };
    private GameInfo gameInfo = null;
    private WorldEventListener<GameInfo> gameInfoListener = new WorldEventListener<GameInfo>(){

        public void notify(GameInfo event) {
            AbstractUT2004Bot.this.gameInfo = event;
            AbstractUT2004Bot.this.getWorldView().removeListener(GameInfo.class, (WorldEventListener)this);
        }
    };
    private ConfigChange firstConfig = null;
    private WorldEventListener<ConfigChange> configListener = new WorldEventListener<ConfigChange>(){

        public void notify(ConfigChange event) {
            AbstractUT2004Bot.this.firstConfig = event;
            AbstractUT2004Bot.this.getWorldView().removeListener(ConfigChange.class, (WorldEventListener)this);
        }
    };
    private WorldEventListener<InitedMessage> initedMessageListener = new WorldEventListener<InitedMessage>(){

        public void notify(InitedMessage event) {
            AbstractUT2004Bot.this.setAgentStateDescription("Bot initialized, calling botInited()");
            AbstractUT2004Bot.this.botInitialized(AbstractUT2004Bot.this.firstConfig, event);
            AbstractUT2004Bot.this.firstConfig = null;
            AbstractUT2004Bot.this.setAgentStateDescription("botInited() finished, bot initialized OK");
            AbstractUT2004Bot.this.setAgentState(AgentStateType.RUNNING, "Bot is running.");
        }
    };

    @Inject
    public AbstractUT2004Bot(AgentLogger logger, WORLD_VIEW worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
        this.getWorldView().getRunning().addListener(this.runningListener);
        this.getWorldView().addListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addListener(InitCommandRequest.class, this.initCommandRequestListener);
        this.getWorldView().addListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addListener(InitedMessage.class, this.initedMessageListener);
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected abstract void prePrepareBot();

    protected abstract void postPrepareBot(GameInfo var1);

    protected abstract Initialize createInitializeCommand();

    protected abstract void botInitialized(ConfigChange var1, InitedMessage var2);

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public Initialize getInitializeCommand() {
        return this.initializeCommand;
    }

    protected void initCommandRequested() {
        this.initializeCommand = this.createInitializeCommand();
        if (this.initializeCommand == null) {
            AgentRuntimeException e = new AgentRuntimeException("createInitializeCommand() method returned null message, can't initialize the agent!", (Object)this.getLogger().platform());
            this.terminate(AgentStateType.FAILED, e.getMessage(), this.getAgentStopTimeoutMillis());
            throw e;
        }
        try {
            this.initializeCommand.setJmx(this.startJMX());
        }
        catch (PogamutException ex) {
            throw new RuntimeException("Error seting up JMX name of the agent.", ex);
        }
        this.getAct().act((CommandMessage)this.initializeCommand);
    }

    protected String startJMX() throws PogamutException {
        String name = Pogamut.getPlatform().getMBeanServerURL().toString() + "|" + this.getJMX().getAgentJMXName().toString();
        return name;
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)super.getWorldView();
    }

    public void start() throws AgentException {
        this.stopCalled = false;
        super.start();
        try {
            this.getJMX().enableJMX(Pogamut.getPlatform().getMBeanServer());
        }
        catch (PogamutException ex) {
            throw new AgentException("Error initializing JMX.", (Throwable)ex, (Object)this);
        }
    }

    public void stop() {
        this.stopCalled = true;
        super.stop();
    }
}

