/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.DefaultUT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public class UT2004LockableWorldView
extends DefaultUT2004WorldView
implements ILockableWorldView {
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();

    @Inject
    public UT2004LockableWorldView(IMediator messageSource, AgentLogger log) {
        super(messageSource, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            this.log.finer("World view locked.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            this.log.finer("World view is being unlocked.");
            this.locked = false;
            for (List list : this.batches) {
                this.processBatch(list);
            }
            this.batches.clear();
            this.log.finer("World view unlocked.");
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(IWorldChangeEvent event) {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (event instanceof BeginMessage) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (event instanceof EndMessage) {
                    this.currentBatch.add(event);
                    this.batches.add(this.currentBatch);
                    this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 20);
                } else {
                    this.currentBatch.add(event);
                }
            } else if (event instanceof EndMessage) {
                this.currentBatch.add(event);
                this.processBatch(this.currentBatch);
                this.currentBatch.clear();
            } else {
                this.currentBatch.add(event);
            }
        }
    }
}

