/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.SimplePathExecutor;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTPathExecutor
extends SimplePathExecutor<ILocated, ILocated> {
    protected final double TARGET_AREA_RADIUS = 120.0;
    IAct commandSerializer = null;
    IWorldView worldView = null;
    WorldObjectEventListener<Self> movementListener = null;

    public UTPathExecutor(IWorldView worldView, IAct commandSerializer, PathPlanner planner) {
        super(planner);
        this.commandSerializer = commandSerializer;
        this.worldView = worldView;
        this.movementListener = new WorldObjectEventListener<Self>(){
            double lastDist = Double.MAX_VALUE;

            public void notify(Self event) {
                if (UTPathExecutor.this.isMoving() && event.getLocation().getDistance(((ILocated)UTPathExecutor.this.getNextPathElement()).getLocation()) < 120.0) {
                    UTPathExecutor.this.moveToNext();
                }
            }
        };
        worldView.addUpdatedListener(Self.class, (WorldObjectEventListener)this.movementListener);
    }

    protected ILocated getAgentLocation() {
        Collection slfCol = this.worldView.getAll(Self.class).values();
        if (slfCol.size() == 1) {
            return ((Self)slfCol.iterator().next()).getLocation();
        }
        throw new PogamutRuntimeException("None or more than one Self messages present.", (Object)this);
    }

    protected void issueMotoricCommands() throws PogamutException {
        Iterator it = this.getPathIterator();
        Location l1 = ((ILocated)this.getNextPathElement()).getLocation();
        if (it.hasNext()) {
            Location l2 = ((ILocated)it.next()).getLocation();
            this.commandSerializer.act((CommandMessage)new Move().setFirstLocation(l1).setSecondLocation(l2));
        } else {
            this.commandSerializer.act((CommandMessage)new Move().setFirstLocation(l1));
        }
    }
}

