/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Thrown;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WeaponUpdate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weaponry
extends AgentModule {
    private Storage storage = new Storage();
    AddInventoryMsgListener addInventoryMsgListener;
    ItemPickedUpListener itemPickedUpListener;
    WeaponUpdateListener weaponUpdateListener;
    ThrownListener thrownListener;
    protected AgentInfo agentInfo;

    public boolean hasWeapon(UnrealId unrealId) {
        return this.storage.byUnrealId.containsKey(unrealId);
    }

    public boolean hasWeapon(String type) {
        return this.storage.byType.containsKey(type);
    }

    public AddInventoryMsg getWeapon(UnrealId unrealId) {
        return (AddInventoryMsg)this.storage.byUnrealId.get(unrealId);
    }

    public AddInventoryMsg getWeapon(String type) {
        return (AddInventoryMsg)this.storage.byType.get(type);
    }

    public int getPrimaryAmmo(AddInventoryMsg weapon) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getAlternateAmmo(AddInventoryMsg weapon) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getPrimaryAmmo(UnrealId unrealId) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getAlternateAmmo(UnrealId unrealId) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getPrimaryAmmo(String type) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getAlternateAmmo(String type) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public AddInventoryMsg getCurrentWeapon() {
        UnrealId current = this.agentInfo.getCurrentWeapon();
        return current == null ? null : this.getWeapon(current);
    }

    public int getCurrentPrimaryAmmo() {
        return this.agentInfo.getCurrentAmmo();
    }

    public int getCurrentAlternateAmmo() {
        return this.agentInfo.getCurrentAlternateAmmo();
    }

    public Map<UnrealId, AddInventoryMsg> getWeapons() {
        return Collections.unmodifiableMap(this.storage.byUnrealId);
    }

    public Map<UnrealId, AddInventoryMsg> getLoadedWeapons() {
        return Collections.unmodifiableMap(this.storage.allLoaded);
    }

    public Map<UnrealId, AddInventoryMsg> getMeleeWeapons() {
        return Collections.unmodifiableMap(this.storage.allMelee);
    }

    public Map<UnrealId, AddInventoryMsg> getRangedWeapons() {
        return Collections.unmodifiableMap(this.storage.allRanged);
    }

    public Map<UnrealId, AddInventoryMsg> getLoadedMeleeWeapons() {
        return Collections.unmodifiableMap(this.storage.allLoadedMelee);
    }

    public Map<UnrealId, AddInventoryMsg> getLoadedRangedWeapons() {
        return Collections.unmodifiableMap(this.storage.allLoadedRanged);
    }

    public Map<UnrealId, AddInventoryMsg> getAmmos() {
        return Collections.unmodifiableMap(this.storage.ammoByUnrealId);
    }

    public boolean hasLoadedWeapon() {
        return !this.getLoadedWeapons().isEmpty();
    }

    public Weaponry(IWorldView worldView, AgentInfo agentInfo, Logger log) {
        super(log);
        this.agentInfo = agentInfo != null ? agentInfo : new AgentInfo(worldView, null, log);
        this.addInventoryMsgListener = new AddInventoryMsgListener(worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(worldView);
        this.weaponUpdateListener = new WeaponUpdateListener(worldView);
        this.thrownListener = new ThrownListener(worldView);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThrownListener
    implements WorldEventListener<Thrown> {
        public void notify(Thrown event) {
        }

        public ThrownListener(IWorldView worldView) {
            worldView.addListener(Thrown.class, (WorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeaponUpdateListener
    implements WorldEventListener<WeaponUpdate> {
        public void notify(WeaponUpdate event) {
        }

        public WeaponUpdateListener(IWorldView worldView) {
            worldView.addListener(WeaponUpdate.class, (WorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemPickedUpListener
    implements WorldEventListener<ItemPickedUp> {
        public void notify(ItemPickedUp event) {
        }

        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addListener(ItemPickedUp.class, (WorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddInventoryMsgListener
    implements WorldEventListener<AddInventoryMsg> {
        public void notify(AddInventoryMsg event) {
            boolean isWeapon = false;
            boolean isAmmo = false;
            if (event.getType().contains("Ammo")) {
                isAmmo = true;
            } else if (event.getType().contains("Weapon")) {
                isWeapon = true;
            }
            if (!isWeapon && isAmmo) {
                Weaponry.this.storage.ammoByUnrealId.put(event.getId(), event);
                Weaponry.this.storage.ammoByType.put(event.getType(), event);
            }
        }

        public AddInventoryMsgListener(IWorldView worldView) {
            worldView.addListener(AddInventoryMsg.class, (WorldEventListener)this);
        }
    }

    private class Storage {
        private HashMap<UnrealId, AddInventoryMsg> byUnrealId = new HashMap();
        private HashMap<String, AddInventoryMsg> byType = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> ammoByUnrealId = new HashMap();
        private HashMap<String, AddInventoryMsg> ammoByType = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> allLoaded = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> allMelee = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> allRanged = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> allLoadedMelee = new HashMap();
        private HashMap<UnrealId, AddInventoryMsg> allLoadedRanged = new HashMap();

        private Storage() {
        }
    }
}

