/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Players
extends AgentModule {
    private PlayerMaps players = new PlayerMaps();
    private PlayerMaps enemies = new PlayerMaps();
    private PlayerMaps friends = new PlayerMaps();
    PlayerListener playerListener;
    PlayerLeftListener playerLeftListener;
    protected AgentInfo agentInfo;

    public Player getPlayer(UnrealId UnrealId2) {
        return (Player)this.players.all.get(UnrealId2);
    }

    public Player getVisiblePlayer(UnrealId UnrealId2) {
        return (Player)this.players.visible.get(UnrealId2);
    }

    public Player getReachablePlayer(UnrealId UnrealId2) {
        return (Player)this.players.reachable.get(UnrealId2);
    }

    public Map<UnrealId, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players.all);
    }

    public Map<UnrealId, Player> getEnemies() {
        return Collections.unmodifiableMap(this.enemies.all);
    }

    public Map<UnrealId, Player> getFriends() {
        return Collections.unmodifiableMap(this.friends.all);
    }

    public Map<UnrealId, Player> getVisiblePlayers() {
        return Collections.unmodifiableMap(this.players.visible);
    }

    public Map<UnrealId, Player> getVisibleEnemies() {
        return Collections.unmodifiableMap(this.enemies.visible);
    }

    public Map<UnrealId, Player> getVisibleFriends() {
        return Collections.unmodifiableMap(this.friends.visible);
    }

    public Map<UnrealId, Player> getReachablePlayers() {
        return Collections.unmodifiableMap(this.players.reachable);
    }

    public Map<UnrealId, Player> getReachableEnemies() {
        return Collections.unmodifiableMap(this.enemies.reachable);
    }

    public Map<UnrealId, Player> getReachableFriends() {
        return Collections.unmodifiableMap(this.friends.reachable);
    }

    public Player getNearestPlayer(Collection<Player> players) {
        double distance = Double.MAX_VALUE;
        Iterator<Player> iterator = players.iterator();
        Player player = null;
        while (iterator.hasNext()) {
            Player nextPlayer = iterator.next();
            double temp = this.agentInfo.getLocation().getPoint3d().distance(nextPlayer.getLocation().getPoint3d());
            if (!(temp < distance)) continue;
            distance = temp;
            player = nextPlayer;
        }
        return player;
    }

    public boolean canSeePlayers() {
        return this.players.visible.size() > 0;
    }

    public boolean canSeeEnemies() {
        return this.enemies.visible.size() > 0;
    }

    public boolean canSeeFriends() {
        return this.friends.visible.size() > 0;
    }

    public boolean canReachPlayers() {
        return this.players.reachable.size() > 0;
    }

    public boolean canReachEnemies() {
        return this.enemies.reachable.size() > 0;
    }

    public boolean canReachFriends() {
        return this.friends.reachable.size() > 0;
    }

    public Players(IWorldView worldView, AgentInfo agentInfo, Logger log) {
        super(log);
        this.agentInfo = agentInfo != null ? agentInfo : new AgentInfo(worldView, null, log);
        this.playerListener = new PlayerListener(worldView);
        this.playerLeftListener = new PlayerLeftListener(worldView);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayerLeftListener
    implements WorldEventListener<PlayerLeft> {
        public void notify(PlayerLeft event) {
            UnrealId uid = event.getId();
            Players.this.players.remove(uid);
            Players.this.enemies.remove(uid);
            Players.this.friends.remove(uid);
        }

        public PlayerLeftListener(IWorldView worldView) {
            worldView.addListener(PlayerLeft.class, (WorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayerListener
    implements WorldObjectEventListener<Player> {
        public void notify(Player event) {
            Players.this.players.notify(event);
            if (Players.this.agentInfo.isEnemy(event)) {
                Players.this.enemies.notify(event);
            }
            if (Players.this.agentInfo.isFriend(event)) {
                Players.this.friends.notify(event);
            }
        }

        public PlayerListener(IWorldView worldView) {
            worldView.addUpdatedListener(Player.class, (WorldObjectEventListener)this);
        }
    }

    private class PlayerMaps {
        private HashMap<UnrealId, Player> all = new HashMap();
        private HashMap<UnrealId, Player> visible = new HashMap();
        private HashMap<UnrealId, Player> reachable = new HashMap();

        private PlayerMaps() {
        }

        private void notify(Player player) {
            UnrealId uid = player.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, player);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = player.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, player);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
            }
            boolean wasReachable = this.reachable.containsKey(uid);
            boolean isReachable = player.isReachable();
            if (isReachable && !wasReachable) {
                this.reachable.put(uid, player);
            } else if (!isReachable && wasReachable) {
                this.reachable.remove(uid);
            }
        }

        private void remove(UnrealId uid) {
            this.all.remove(uid);
            this.visible.remove(uid);
            this.reachable.remove(uid);
        }
    }
}

