/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.InternalContext;
import com.google.inject.InternalFactory;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.spi.SourceProviders;
import com.google.inject.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Provider<? extends T> provider;
    private final Object source;

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider) {
        this(provider, SourceProviders.UNKNOWN_SOURCE);
    }

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider, Object source) {
        this.provider = Objects.nonNull(provider, "provider");
        this.source = Objects.nonNull(source, "source");
    }

    @Override
    public T get(InternalContext context) {
        T provided = this.provider.get();
        if (provided != null) {
            return provided;
        }
        if ("I'm a bad hack".equals(System.getProperty("guice.allow.nulls.bad.bad.bad"))) {
            return provided;
        }
        String message = String.format("Null value returned by custom provider bound at %s", this.source);
        throw new ProvisionException(context.getExternalContext(), (Throwable)new NullPointerException(message));
    }

    public String toString() {
        return this.provider.toString();
    }
}

