/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInputField
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 4673684743657328492L;
    boolean isDirectory;
    InstallerFrame parentFrame;
    IzPanel parent;
    List<ValidatorContainer> validators;
    JTextField filetxt;
    JButton browseBtn;
    String set;
    int size;
    InstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    boolean mustExist;

    public FileInputField(IzPanel izPanel, InstallData installData, boolean bl, boolean bl2, String string, int n, List<ValidatorContainer> list) {
        this(izPanel, installData, bl, bl2, string, n, list, null, null);
    }

    public FileInputField(IzPanel izPanel, InstallData installData, boolean bl, boolean bl2, String string, int n, List<ValidatorContainer> list, String string2, String string3) {
        this.parent = izPanel;
        this.parentFrame = izPanel.getInstallerFrame();
        this.data = installData;
        this.validators = list;
        this.set = string;
        this.size = n;
        this.fileExtension = string2;
        this.fileExtensionDescription = string3;
        this.isDirectory = bl;
        this.mustExist = bl2;
        this.initialize();
    }

    public void initialize() {
        this.filetxt = new JTextField(this.set, this.size);
        this.filetxt.setCaretPosition(0);
        this.filetxt.addFocusListener(this);
        this.browseBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.search.browse"), this.data.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.add(this.filetxt);
        this.add(this.browseBtn);
    }

    public void setFile(String string) {
        this.filetxt.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseBtn) {
            Object object;
            Debug.trace("Show dirchooser");
            String string = ".";
            if (this.filetxt.getText() != null) {
                string = this.filetxt.getText();
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            if (this.isDirectory) {
                jFileChooser.setFileSelectionMode(1);
            } else {
                jFileChooser.setFileSelectionMode(0);
                if (this.fileExtension != null && this.fileExtensionDescription != null) {
                    object = new UserInputFileFilter();
                    ((UserInputFileFilter)object).setFileExt(this.fileExtension);
                    ((UserInputFileFilter)object).setFileExtDesc(this.fileExtensionDescription);
                    jFileChooser.setFileFilter((FileFilter)object);
                }
            }
            if (jFileChooser.showOpenDialog(this.parentFrame) == 0) {
                object = jFileChooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText((String)object);
                Debug.trace("Setting current file chooser directory to: " + (String)object);
            }
        }
    }

    public File getSelectedFile() {
        File file = null;
        if (this.filetxt.getText() != null) {
            file = new File(this.filetxt.getText());
        }
        return file;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.langpack.getString("UserInputPanel." + string + ".message"), this.parentFrame.langpack.getString("UserInputPanel." + string + ".caption"), 2);
    }

    public boolean validateField() {
        boolean bl = false;
        String string = this.filetxt.getText();
        if (this.allowEmpty && (string == null || string.length() == 0)) {
            bl = true;
        } else if (string != null) {
            File file = new File(string);
            if (this.isDirectory && !file.isDirectory()) {
                if (this.mustExist) {
                    bl = false;
                    this.showMessage("dir.notdirectory");
                } else {
                    bl = this.verifyCreateOK();
                }
            } else if (!this.isDirectory && !file.isFile()) {
                if (this.mustExist) {
                    bl = false;
                    this.showMessage("file.notfile");
                } else {
                    bl = this.verifyCreateOK();
                }
            } else {
                StringInputProcessingClient stringInputProcessingClient = new StringInputProcessingClient(string, this.validators);
                boolean bl2 = stringInputProcessingClient.validate();
                if (!bl2) {
                    JOptionPane.showMessageDialog(this.parentFrame, stringInputProcessingClient.getValidationMessage(), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                }
                bl = bl2;
            }
        } else if (this.isDirectory) {
            this.showMessage("dir.nodirectory");
        } else {
            this.showMessage("file.nofile");
        }
        return bl;
    }

    public boolean verifyCreateOK() {
        Object object;
        String string = this.filetxt.getText();
        if (string.startsWith("~")) {
            object = System.getProperty("user.home");
            string = (String)object + string.substring(1);
        }
        object = new File(string).getAbsoluteFile();
        string = ((File)object).toString();
        this.filetxt.setText(string);
        if (!((File)object).exists() && !this.parent.emitNotificationFeedback(this.parent.getI18nStringForClass("createdir", "TargetPanel") + "\n" + string)) {
            return false;
        }
        if (!this.isWriteable()) {
            this.parent.emitError(this.parentFrame.langpack.getString("installer.error"), this.parent.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        return true;
    }

    public boolean isWriteable() {
        File file = IoHelper.existingParent(new File(this.filetxt.getText()));
        if (file == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File file2 = File.createTempFile("izWrTe", ".tmp", file);
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                Debug.trace(iOException.toString());
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    public boolean isAllowEmptyInput() {
        return this.allowEmpty;
    }

    public void setAllowEmptyInput(boolean bl) {
        this.allowEmpty = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.filetxt) {
            // empty if block
        }
    }
}

