package cz.cuni.amis.pogamut.ut2004.pcomm.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Logger;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class PCommServer {
	
	private static PCommServer instance = null;
	
	private Logger log = Logger.getAnonymousLogger();
	
	public static PCommServer getInstance() {
		return instance;
	}
	
	private IoAcceptor acceptor;
	
	private PCommServer(int port) throws IOException {
		PCommServer.instance = this;
		initServer(port);
	}
	
	public Logger getLog() {
		return log;
	}

	private void initServer(int port) throws IOException {
		ByteBuffer.setUseDirectBuffers(false);
        ByteBuffer.setAllocator(new SimpleByteBufferAllocator());

        acceptor = new SocketAcceptor();

        SocketAcceptorConfig cfg = new SocketAcceptorConfig();

        cfg.getFilterChain().addLast( "codec", new ProtocolCodecFilter( new ObjectSerializationCodecFactory()));

        acceptor.bind( new InetSocketAddress(port), new PCommHandler(), cfg);

	}
	
	public void exceptionCaught(Throwable arg1) {
		acceptor.unbindAll();		
	}
	
//	
///
////
// MAIN
////
///
//

	public static final int PCOMM_DEFAULT_PORT = 21212;
	
	public static void main(String[] args) {
		int port = PCOMM_DEFAULT_PORT;
		if (args.length > 0) {
			try {
				port = Integer.parseInt(args[0]);
			} catch (NumberFormatException e) {
				System.err.println("Can't parse port-number from the first argument '" + args[0] + "'...");
				System.err.println("TERMINATING");
				System.exit(1);
			}
		}		
		try {
			new PCommServer(port);
		} catch (Exception e) {
			System.err.println("Can't create server at *:" + port);
			e.printStackTrace(System.err);
			System.err.println("TERMINATING");
			System.exit(1);
		}
		System.out.println("PCOMM server is running at *:" + port);
	}

}
