package cz.cuni.amis.pogamut.ut2004.pcomm.server;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;


public class PCommHandler implements IoHandler {
	
	private PCommSession getSession(IoSession ses) {
		synchronized(ses) {
			PCommSession res = (PCommSession) ses.getAttribute(PCommSession.KEY_PCOMM_SESSION);
			if (res != null) return res;
			res = new PCommSession(ses);
			return res;
		}
	}
	
	@Override
	public void exceptionCaught(IoSession ses, Throwable arg1) throws Exception {
		getSession(ses).exceptionCaught(arg1); 
	}

	@Override
	public void messageReceived(IoSession ses, Object arg1) throws Exception {
		getSession(ses).messageReceived(arg1);
	}

	@Override
	public void messageSent(IoSession ses, Object arg1) throws Exception {
		getSession(ses).messageSent(arg1);
	}

	@Override
	public void sessionClosed(IoSession ses) throws Exception {
		getSession(ses).sessionClosed();
	}

	@Override
	public void sessionCreated(IoSession ses) throws Exception {
		getSession(ses).sessionCreated();		
	}

	@Override
	public void sessionIdle(IoSession ses, IdleStatus arg1) throws Exception {
		getSession(ses).sessionIdle(arg1);
	}

	@Override
	public void sessionOpened(IoSession ses) throws Exception {
		getSession(ses).sessionOpened();		
	}

}