package cz.cuni.amis.pogamut.ut2004.pcomm.message;

import java.io.Serializable;

public class PCommMessage implements Serializable {
	
	public static final String PCOMM_SERVER = "PCommServer";
	
	private static final long serialVersionUID = 8177467799679350075L;
	
	private int team;
	private String from;
	private String to;
	private boolean broadcast;
	private boolean broadcastTeam;

	private String[] strs;
	
	/**
	 * Send message only to 'to'.
	 * @param from
	 * @param to
	 * @param object
	 */
	public PCommMessage(String from, String to, String[] strings) {
		this.from = from;
		this.to = to;
		this.team = -1;
		this.strs = strings;
		this.broadcast = false;
		this.broadcastTeam = false;
	}

	/**
	 * Broadcast message to the 'team'.
	 */
	public PCommMessage(String from, int team, String... strings) {
		this.from = from;
		this.to = null;
		this.team = team;
		this.strs = strings;
		this.broadcast = false;
		this.broadcastTeam = true;
	}
	
	/**
	 * Broadcast message - to all connected bots.
	 * @param from
	 * @param object
	 */
	public PCommMessage(String from, String... strings) {
		this.from = from;
		this.to = null;
		this.team = -1;
		this.strs = strings;
		this.broadcast = true;
		this.broadcastTeam = false;
	}
	
	public String getFrom() {
		return from;
	}	

	public String getTo() {
		return to;
	}

	public int getTeam() {
		return team;
	}
	
	public boolean isBroadcast() {
		return broadcast;
	}
	
	public boolean isBroadcastTeam() {
		return broadcastTeam;
	}
	
	public boolean isServerMessage() {
		return to != null && to.equals(PCOMM_SERVER);
	}

	public String[] getStrings() {
		return strs;
	}
	
	protected String getStringsString() {
		StringBuffer sb = new StringBuffer();		
		for (int i = 0; i < strs.length; ++i) { 
			sb.append(strs[i]);
			if (i != strs.length-1) {
				sb.append(", ");
			}
		}
		return sb.toString();
	}

	public String toString() {
		if (isBroadcast()) {
			return "PCommMessage[" + from + ", broadcast]: " + getStringsString(); 
		} else
		if (isBroadcastTeam()) {
			return "PCommMessage[" + from + ", broadcast team " + team + "]: " + getStringsString();
		} else 
		if (isServerMessage()) {
			return "PCommMessage[server]: " + getStringsString();
		} else {
			return "PCommMessage[" + from + "->" + to + "]: " + getStringsString();
		}
	}
	
}