package cz.cuni.amis.pogamut.ut2004.pcomm.client;

import java.io.IOException;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.ut2004.pcomm.message.PCommMessage;

/**
 * Simple facade to PCommClient that contains methods for sending messages to PCommServer.
 * <p><p>
 * Easier to use them PCommClient where you have to construct PCommMessage instances for
 * yourself.
 * <p><p>
 * 1) create<p>
 * 2) connect()<p>
 * 3) send messages<p>
 * 4) close<p>
 * 
 * @author Jimmy
 */
public class PComm {
	
	private PCommClient client;
	private Logger log;

	public PComm(String name, int team, Logger log) {
		client = new PCommClient(name, team);		
		this.log = log;
	}	
	
	protected int getTeam() {
		return client.getTeam();
	}

	protected String getName() {
		return client.getName();
	}
	
	/**
	 * Tries to connect to 127.0.0.1:PCOMM_DEFAULT_PORT.
	 * 
	 * @throws IOException
	 */
	public void connect() throws IOException {
		client.connect();
	}
	
	/**
	 * host: 127.0.0.1, localhost, artemis.ms.mff.cuni.cz, etc.
	 * <p><p>
	 * Connects to default PCommServer port.
	 * <p><p>
	 * DO NOT CONTAIN PROTOCOL NOR PORT INTO ADDRESS.
	 * 
	 * @param host
	 * @throws IOException
	 */
	public void connect(String host) throws IOException {
		client.connect(host);
	}
	
	/**
	 * Connects to PCommServer at host:port.
	 * 
	 * @param host
	 * @param port
	 */
	public void connect(String host, int port) {
		client.connect(host, port);		
	}
	
	/**
	 * Closes the connection.
	 */
	public void close() {
		client.close();
	}
	
	/**
	 * Tests whether the connection is alive.
	 * @return
	 */
	public boolean isConnected() {
		return client.isConnected();
	}
	
	/**
	 * Broadcasts message to all bots at the server.
	 * @param object
	 */
	public void sendAll(String... strs) {
		PCommMessage msg = new PCommMessage(getName(), strs); 
		try {
			log.fine("[PComm] Broadcasting: " + msg);
			client.send(msg);
		} catch (IOException e) {
			log.severe("[PComm] Could not send: " + msg + " (IOException: " + e.getMessage() + ")");
		}
	}
	
	/**
	 * Broadcasts message to all team members.
	 * @param object
	 */
	public void sendTeam(String... strs) {
		PCommMessage msg = new PCommMessage(getName(), getTeam(), strs);
		log.fine("[PComm] Broadcasting: " + msg);
		try {			
			client.send(msg);
		} catch (IOException e) {
			log.severe("[PComm] Could not send: " + msg + " (IOException: " + e.getMessage() + ")");
		}
	}
	
	/**
	 * Sends message to a specific bot.
	 * @param bot
	 * @param object
	 */
	public void sendBot(String bot, String... strs) {
		PCommMessage msg = new PCommMessage(getName(), bot, strs);
		log.fine("[PComm] Broadcasting: " + msg);
		try {						
			client.send(msg);
		} catch (IOException e) {
			log.severe("[PComm] Could not send: " + msg + " (IOException: " + e.getMessage() + ")");
		}
	}

	/**
	 * Returns all messages that has came till the last call of the method.
	 * 
	 * @return
	 */
	public PCommMessage[] receive() {
		return client.receive();		
	}

	/**
	 * Test whether some messages are ready to be received.
	 * @return
	 */
	public boolean hasMessages() {
		return client.hasMessages();
	}

}
