package cz.cuni.amis.pogamut.ut2004.pcomm;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.ut2004.pcomm.client.PComm;
import cz.cuni.amis.pogamut.ut2004.pcomm.message.PCommMessage;
import cz.cuni.amis.pogamut.ut2004.pcomm.server.PCommServer;

public class TestPComm {
	
	public static String check(PCommMessage[] msgs, int index, String expected) {
		if (msgs.length <= index) {
			System.out.println("Wrong num of messages, can't access index " + index);
			return null;
		}
		System.out.println("received " + msgs[index].getStrings()[0]);
		return msgs[index].getStrings()[0];
	}
	
	public static boolean check(PComm comm, int num, String[] expected) {
		Set<String> expectedSet = new HashSet<String>();
		for (String i : expected) {
			expectedSet.add(i);
		}
		PCommMessage[] msgs;		
		System.out.println("CLIENT " + num);		
		msgs = comm.receive();
		boolean ok = true;
		for (int i = 0; i < expected.length; ++i) {
			expectedSet.remove(check(msgs, i, expected[i]));
		}		
		if (msgs.length > expected.length) {
			System.out.println("Wrong num of messages!");
			ok = false;
		}
		if (expectedSet.size() != 0) {
			System.out.print("Missing: ");
			for (String i : expectedSet) {
				System.out.print(i + " | ");				
			}
			System.out.println();
			ok = false;
		}
		return ok;
	}
		
	
	public static void main(String[] args) throws IOException {
		
		PCommServer.main(new String[0]);
		
		String[] names = new String[]{ "test-bot-1", "test-bot-2", "test-bot-3", "test-bot-4"};
		int[] teams = new int[]{ 1, 1, 1, 2 };
		PComm[] clients = new PComm[names.length];
		
		for (int i = 0; i < names.length; ++i) {
			clients[i] = new PComm(names[i], teams[i], Logger.getAnonymousLogger());
			clients[i].connect();
		}
		
		System.out.println("CONNECTED!");
		
		clients[3].sendAll("0");
		clients[0].sendAll("1");
		clients[0].sendTeam("2");
		clients[0].sendBot(names[2], "3");
		
		
		System.out.println("MESSAGES SENT!");
		
		try {
			Thread.sleep(50);
		} catch (InterruptedException e) {
		}
		
		boolean ok = true;
		
		ok = check(clients[0], 0, new String[]{ "0" });
		ok = check(clients[1], 1, new String[]{"0", "1", "2"}) && ok;
		ok = check(clients[2], 2, new String[]{"0", "1", "2", "3"}) && ok;
		ok = check(clients[3], 3, new String[]{"1"}) && ok;
		
		System.out.println();
		if (!ok) {
			System.out.println("======");
			System.out.println("BAD!!!");
			System.out.println("======");
		} else {
			System.out.println("======");
			System.out.println("All OK");
			System.out.println("======");
		}
		System.exit(1);
	}

}
