package healthforager;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarGoal;
import cz.cuni.astar.AStarMap;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.ArrayList;
import java.util.List;

/**
 * This bot is doing a few things: <BR>
 * 1) it's running randomly between health-packs and health-vials <BR>
 * 2) is example how to use A-Star (note that it may fail from time to time because the GB's edges aren't 100% OK) <BR>
 * <BR>
 * Read through the code as it is commented, everything should be clear ;-) if not -> jakub.gemrot@gmail.com
 */
public class Main extends Agent {
    
    /** Creates a new instance of agent. */
    public Main() {
    }
    
    /** 
     * Here we're keeping the track of the health we're running to.
     * If null next doLogic() iteration will pick a new target to run to.
     */
    protected Health runningTo = null;
    
    /**
     * Here we're counting how many times the AStar returns path for us, note that
     * the PogProp annotation will make this field visible in introspection during
     * runtime (you must open View->Properties + click on the Introspection node
     * under the running bot in the server).
     */
    @PogProp public int aStarSuccess = 0;    
    
    /**
     * This counts how many time the AStar fails to return path to the health.
     */
    @PogProp public int aStarFailure = 0;
    
    /**
     * This method randomly choose and return health.
     * Note that the implementation is really fail-safe ...
     */     
    protected Health chooseHealth() {
        // first -> let's query the current agent's location
        //          note that every query means that we're getting something from Lists/Maps, better
        //          to save the result then to call it every time
        Triple myLocation = memory.getAgentLocation();
        
        // here we will store candidates for healths to run to
        List<Health> healths = new ArrayList<Health>();
        
        // if there is no health item in the map, return null and log the failure
        if (memory.getKnownHealths().size() == 0) {
            log.severe("This map doesn't contains healths.");            
            return null;
        }
        
        // this construction may be little unfamiliar, but clear ... we're going through the list
        // memory.getKnownHealths() and 'health' will be taken one by one from the list
        for (Health health : memory.getKnownHealths()) {
            // let's take only those health points there are further then 100
            if (Triple.distanceInSpace(myLocation, health.location) > 100) {
                healths.add(health);
            }
        }
        // after this for-cycle, we have intialized 'healths' (candidates)
        
        // if we have no candidates, log the error and return null
        if (healths.size() == 0) {
            log.severe("Furthest health too near.");
            return null;
        }
        
        // okey, now return the health at random from the list
        // notice, that 'random' is protected field of the Agent class (no magic here ;-)
        return healths.get(random.nextInt(healths.size()));        
    }
    
    /**
     * Returns the nearest navpoint to your current location.
     * Not used here, but you may be interested in this in your work, so I've put it here.
     */
    protected NavPoint nearestNavpoint() {
        // get all navpoints we know of
        List<NavPoint> navPoints = memory.getKnownNavPoints();
        // here we will keep the distance from currently known closest navpoint
        double nearestNavPointDistance = Double.MAX_VALUE;
        // this will store the nearest navpoint, it will be computer in for-cycle...
        NavPoint nearestNavPoint = null;
        // query the agent location
        Triple myLocation = memory.getAgentLocation();
        // and go through all the navpoints we know of...
        for (NavPoint navPoint : navPoints) {
            // always count the distance between the bot and navPoint
            double navPointDistance = Triple.distanceInPlane(navPoint.location, myLocation);
            // if it is closer then currently found navpoint
            if (navPointDistance < nearestNavPointDistance) {
                // remember it
                nearestNavPoint = navPoint;
                nearestNavPointDistance = navPointDistance;
            }
        }
        // return the navpoint we have found
        return nearestNavPoint;
    }
    
    /**
     * This will ask the AStar to find the path within the graph of map's navigation points.
     * You always have to specify where you want the path to (toWhat) and how many
     * iterations the AStar may work (pass -1 if you want the AStar to do exhaustive search).
     * 
     * Returns the list of navpoints you have to follow.
     */
    public List<NavPoint> getPathAStar(NavPoint toWhat, int maxNumOfIterations) {           
            if (toWhat == null) return null;
            // initialize the AStarGoal, that will tell the AStar when to stop (that's why
            // we're passing the 'toWhat' as an argument
            AStarGoal goal = new GameMapAStarGoal(toWhat);
            // wrapper for the navpoints the GB sends us
            AStarMap map = new GameMapAStarMap();
            
            // now we have to construct the begin point for the AStar
            // as the AStar is working over NavPoint, it has to be NavPoint
            NavPoint start = new NavPoint();
            // make the start.location as bot's location
            start.location = memory.getAgentLocation();
            // and constructs it's neighbours (NeighNav is better viewed as EDGE in the navpoint graph)
            start.neighbours = new ArrayList<NeighNav>();
            // get all the navpoints the bot can see
            ArrayList<NavPoint> nvs = memory.seeAllNavPoints();
            NeighNav nn;
            for (NavPoint navPoint : nvs){
                    // and if the navpoint is reachable, add it as a neighbour to our start
                    if (navPoint.reachable) {
                        nn = new NeighNav();
                        nn.neighbour = navPoint;
                        start.neighbours.add(nn);
                    }
            }
            // fire tha AStar
            AStarResult result = AStar.aStar(goal, map, start, maxNumOfIterations);		
            // and if it succeeds
            if (!result.success) return null;
            // return the list of navpoints
            return gameMap.getNavPointsAStar(result);
    }	
    
    /**
     * Simple method computing the path length... no need for exmplanation I hope...
     */
    public double pathLength(List<NavPoint> path) {
        double length = 0;
        Triple lastLocation = memory.getAgentLocation();
        for (NavPoint navPoint : path) {
            length += Triple.distanceInSpace(lastLocation, navPoint.location);
            lastLocation = navPoint.location;
        }
        return length;
    }

    /**
     * If you want to log the found path, you may need something like this.
     * Returns string representation of the path...
     */
    public String getPathString(List<NavPoint> path) {
        StringBuffer sb = new StringBuffer(path.size() * 20);
        sb.append("Path: ");
        for (NavPoint navPoint : path) {
            sb.append(navPoint.location.toString() + " | ");
        }
        return sb.toString();
    }

    /**
     * Okey, main method of the bot ... the brain is here :-)
     * This bot is doing a few things: <BR>
     * 1) it's running randomly between health-packs and health-vials <BR>
     * 2) is example how to use A-Star (note that it may fail from time to time because the GB's edges aren't 100% OK) <BR>
     */
    protected void doLogic() {        
        // first, check whether we're already have a health to run to
        if (runningTo == null) {
            // if not, choose the health
            runningTo = chooseHealth();
            // if chosen health is null
            if (runningTo == null) {
                // we're doomed
                log.severe("No health to run to... terminating.");
                // and stops the bot
                this.stopAgentSoft();
                return;
            }
            // if chosen health is not null... let's log it
            log.info("Chosen health: " + runningTo.ID + " -> " + runningTo.UnrealID);
            // and checks whether the AStar could be used as our navigator through space...
            List<NavPoint> path = getPathAStar(runningTo.navPoint, -1);
            if (path == null) {
                log.warning("AStar hasn't found the path.");
                ++aStarFailure;
            } else {
                log.info("AStar " + getPathString(path));
                ++aStarSuccess;
            }
        }
        
        // okey, in this point, we're pretty darn sure, the runningTo is not null, we have out health
        
        // first, check whether we already arrived to the health point
        if (Triple.distanceInPlane(runningTo.location, memory.getAgentLocation()) < 100) {
            // if so, log it + restart the logic
            log.info("We have arrived to the health point.");
            log.warning("NEXT");
            // simply by nulling the runningTo, next doLogic() iteration will fill it again
            runningTo = null;
            return;
        }
        
        // okey, we haven't arrive to the destination yet
        
        // check whether we can see the navpoint we're running to ...
        // NOTICE HERE that every Item has 'navPoint' field that contains the NavPoint
        // where it lies
        if (memory.getSeeNavPoint(runningTo.navPoint.getID()) != null) {
            log.info("I can see the navpoint of the health I'm running to!");            
            // if we may see the navpoint, check whether we can see the health as well
            if (memory.getSeeHealth(runningTo.UnrealID) != null) {
                log.info("I can see the health as well.");
            } else {
                log.warning("But I CAN'T see the health!");
            }                
            // bad is, that this sometimes fails... we may see the point but not the health
            // reasons: 1) the health is not there
            //          2) the health is partly hidden and trace from the bot to the heatlh failed
        }
        
        
        // okey, now follow the path to the location we want to run to
        if (!gameMap.safeRunToLocation(runningTo.location)) {
            // if this returns false ... running to that location failed
            log.severe("Running to health failed ...");
            // and we have to replan...
            runningTo = null;
            return;
        }
    }

    protected void prePrepareAgent() throws PogamutException {
    /* Prepares agent logic to run - like initializing neural networks etc.
    not for establishing communication! */

    }

    protected void postPrepareAgent() throws PogamutException {
    /* Prepare logic according to information from gathered from startCommunication
    like choosing plan/parameters according to game type. */

    }

    protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent

    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}
