/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.pogamut.experiments.Parameter;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.utils.FlagListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExperimentDescriptor
implements Serializable {
    protected transient Collection listeners = null;
    protected String name = "Experiment";
    protected List<Parameter> parameters = new ArrayList<Parameter>();
    private File outputDirectory = null;
    protected transient Logger logger = null;
    private double experimentSpeed = 1.0;
    private ClassLoader classLoader = null;

    public ExperimentDescriptor() {
        this.init();
    }

    public abstract Experiment createExperiment(UTServer var1);

    public void addExperimentStateListener(FlagListener<ExperimentExecutionState> listener) {
        this.listeners.add(listener);
    }

    public Collection<FlagListener<ExperimentExecutionState>> getExperimentStateListeners() {
        return this.listeners;
    }

    protected void init() {
        this.listeners = new ArrayList();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters.clear();
        if (parameters == null) {
            return;
        }
        for (Parameter param : parameters) {
            this.parameters.add(param);
        }
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void addParameter(Parameter param) {
        this.parameters.add(param);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public double getExperimentSpeed() {
        return this.experimentSpeed;
    }

    public void setExperimentSpeed(double experimentSpeed) {
        this.experimentSpeed = experimentSpeed;
    }
}

