/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.Client.KnownObjects;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
extends MessageObject
implements Serializable {
    public ArrayList<NavPoint> nodes = null;
    public String pongID = null;

    public Path(int ID, String UnrealID, ArrayList<NavPoint> nodes) {
        super(MessageType.PATH, ID, UnrealID);
        this.nodes = nodes;
    }

    public Path() {
        super(MessageType.PATH);
        this.nodes = new ArrayList();
    }

    @Override
    public String toString() {
        String answer = super.toString() + " PongID " + this.pongID;
        int i = 0;
        for (NavPoint nv : this.nodes) {
            answer = answer + System.getProperty("line.separator");
            answer = answer + String.valueOf(++i) + ". -> " + nv.toString();
        }
        return answer;
    }

    public void diff(KnownObjects knownObjects) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!knownObjects.contains(this.nodes.get(i).getID())) continue;
            this.nodes.get(i).diff(knownObjects.getObject(this.nodes.get(i).getID()));
        }
    }

    public void update(KnownObjects knownObjects) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getLocation() != null) continue;
            this.nodes.set(i, (NavPoint)knownObjects.getObject(this.nodes.get(i).getID()));
        }
    }

    public String printPathIDs() {
        String content = "";
        for (NavPoint nav : this.nodes) {
            content = content + String.valueOf(nav.ID) + ", ";
        }
        return content;
    }

    public String printPathIDAndLocations() {
        String content = "";
        for (NavPoint nav : this.nodes) {
            content = content + "ID: " + String.valueOf(nav.ID) + ", Loc: " + String.valueOf(nav.location);
            content = content + ", Reach: " + String.valueOf(nav.reachable) + "\n";
        }
        return content;
    }
}

