/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.HistoryBatch;
import cz.cuni.pogamut.Client.HistoryIterator;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.DeleteFromBatch;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.communication.CommunicationState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
implements RcvMsgListener {
    private ArrayList<HistoryBatch> batches = new ArrayList();
    private Logger platformLog;
    private int maxLenghtOfStoring = 20;

    public History(AgentBody body, Logger logger) {
        this.batches.add(new HistoryBatch(logger));
        this.platformLog = logger;
        body.addRcvMsgListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartHistory() {
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            this.batches.clear();
        }
        HistoryBatch hb = new HistoryBatch(this.platformLog);
        ArrayList<HistoryBatch> arrayList2 = this.batches;
        synchronized (arrayList2) {
            this.batches.add(hb);
        }
    }

    public int getMaxLenghtOfStoring() {
        return this.maxLenghtOfStoring;
    }

    public void setMaxLenghtOfStoring(int maxLenghtOfStoring) {
        this.maxLenghtOfStoring = maxLenghtOfStoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endMessage() {
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            HistoryBatch newBatch = this.batches.get(0).copyVisibleObjects();
            newBatch.setNext(this.batches.get(0));
            this.batches.add(0, newBatch);
            if (this.batches.size() > this.maxLenghtOfStoring) {
                this.batches.get(this.maxLenghtOfStoring - 1).setNext(null);
                this.batches.remove(this.maxLenghtOfStoring);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessage(MessageObject newMsg) {
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            this.batches.get(0).addMessage(newMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
            return;
        }
        switch (e.getMessage().getType()) {
            case END: {
                this.endMessage();
                break;
            }
            case DELETE_FROM_BATCH: {
                ArrayList<HistoryBatch> arrayList = this.batches;
                synchronized (arrayList) {
                    this.batches.get(0).remove(((DeleteFromBatch)e.getMessage()).msgType, e.getMessage().ID);
                    break;
                }
            }
            default: {
                this.addMessage(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String temp = "";
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            for (int i = 0; i < this.batches.size(); ++i) {
                temp = temp + String.valueOf(i) + ". " + this.batches.get(i).toString() + "\n";
            }
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageObject getFirstMessageOfType(MessageType type) {
        MessageObject temp = null;
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            temp = this.batches.get(0).getFirstObjectOfType(type);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HistoryBatch getFirstBatch() {
        HistoryBatch temp = null;
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            temp = this.batches.get(0);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<MessageObject> getMessagesOfType(MessageType type) {
        ArrayList<MessageObject> objects = new ArrayList<MessageObject>();
        HashMap<Integer, MessageObject> objectsInBatch = null;
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            objectsInBatch = this.batches.get(0).getAllObjectsOfType(type);
            if (objectsInBatch == null) {
                return null;
            }
            Iterator<Integer> iterator = objectsInBatch.keySet().iterator();
            while (iterator.hasNext()) {
                objects.add(objectsInBatch.get(iterator.next()));
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<MessageObject> getSeenMessageObjectsInTime(int time, MessageType type) {
        ArrayList<MessageObject> seenObjects = new ArrayList<MessageObject>();
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            HistoryIterator iterator = new HistoryIterator(time, type, true, this.batches.get(0));
            while (iterator.hasNext()) {
                seenObjects.add((MessageObject)iterator.next());
            }
        }
        return seenObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HistoryIterator iterator(int depth, MessageType type, boolean unique) {
        HistoryIterator temp = null;
        ArrayList<HistoryBatch> arrayList = this.batches;
        synchronized (arrayList) {
            temp = new HistoryIterator(depth, type, unique, this.batches.get(0));
        }
        return temp;
    }
}

