/*
 * Decompiled with CFR 0.152.
 */
package healthforager;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.ArrayList;
import java.util.List;

public class Main
extends Agent {
    Health runningTo = null;
    @PogProp
    public int aStarSuccess = 0;
    @PogProp
    public int aStarFailure = 0;

    protected Health chooseHealth() {
        Triple myLocation = this.memory.getAgentLocation();
        ArrayList<Health> healths = new ArrayList<Health>();
        if (this.memory.getKnownHealths().size() == 0) {
            this.log.severe("This map doesn't contains healths.");
            return null;
        }
        for (Health h : this.memory.getKnownHealths()) {
            if (!(Triple.distanceInSpace(myLocation, h.location) > 100.0)) continue;
            healths.add(h);
        }
        if (healths.size() == 0) {
            this.log.severe("Furthest health too near.");
            return null;
        }
        return (Health)healths.get(this.random.nextInt(healths.size()));
    }

    protected NavPoint nearestNavpoint() {
        ArrayList<NavPoint> navPoints = this.memory.getKnownNavPoints();
        double nearestNavPointDistance = Double.MAX_VALUE;
        NavPoint nearestNavPoint = null;
        Triple myLocation = this.memory.getAgentLocation();
        for (NavPoint navPoint : navPoints) {
            double navPointDistance = Triple.distanceInPlane(navPoint.location, myLocation);
            if (!(navPointDistance < nearestNavPointDistance)) continue;
            nearestNavPoint = navPoint;
            nearestNavPointDistance = navPointDistance;
        }
        return nearestNavPoint;
    }

    public List<NavPoint> getPathAStar(NavPoint toWhat, int maxNumOfIterations) {
        if (toWhat == null) {
            return null;
        }
        GameMapAStarGoal goal = new GameMapAStarGoal(toWhat);
        GameMapAStarMap map = new GameMapAStarMap();
        NavPoint start = new NavPoint();
        start.location = this.memory.getAgentLocation();
        start.neighbours = new ArrayList();
        ArrayList<NavPoint> nvs = this.memory.seeAllNavPoints();
        for (NavPoint navPoint : nvs) {
            if (!navPoint.reachable) continue;
            NeighNav nn = new NeighNav();
            nn.neighbour = navPoint;
            start.neighbours.add(nn);
        }
        AStarResult result = AStar.aStar(goal, map, start, maxNumOfIterations);
        if (!result.success) {
            return null;
        }
        return this.gameMap.getNavPointsAStar(result);
    }

    public double pathLength(List<NavPoint> path) {
        double length = 0.0;
        Triple lastLocation = this.memory.getAgentLocation();
        for (NavPoint navPoint : path) {
            length += Triple.distanceInSpace(lastLocation, navPoint.location);
            lastLocation = navPoint.location;
        }
        return length;
    }

    public String getPathString(List<NavPoint> path) {
        StringBuffer sb = new StringBuffer(path.size() * 20);
        sb.append("Path: ");
        for (NavPoint navPoint : path) {
            sb.append(navPoint.location.toString() + " | ");
        }
        return sb.toString();
    }

    @Override
    protected void doLogic() {
        if (this.runningTo == null) {
            this.runningTo = this.chooseHealth();
            if (this.runningTo == null) {
                this.log.severe("No health to run to... terminating.");
                this.stopAgentSoft();
                return;
            }
            this.log.info("Chosen health: " + this.runningTo.ID + " -> " + this.runningTo.UnrealID);
            List<NavPoint> path = this.getPathAStar(this.runningTo.navPoint, -1);
            if (path == null) {
                this.log.warning("AStar hasn't found the path.");
                ++this.aStarFailure;
            } else {
                this.log.info("AStar " + this.getPathString(path));
                ++this.aStarSuccess;
            }
        }
        if (Triple.distanceInPlane(this.runningTo.location, this.memory.getAgentLocation()) < 100.0) {
            this.log.info("We have arrived to the health point.");
            this.log.warning("NEXT");
            this.runningTo = null;
            return;
        }
        if (this.memory.getSeeNavPoint(this.runningTo.navPoint.getID()) != null) {
            this.log.info("I can see the navpoint of the health I'm running to!");
            if (this.memory.getSeeHealth(this.runningTo.UnrealID) != null) {
                this.log.info("I can see the health as well.");
            } else {
                this.log.warning("But I CAN'T see the health!");
            }
        }
        if (!this.gameMap.safeRunToLocation(this.runningTo.location)) {
            this.log.severe("Running to health failed ...");
            this.runningTo = null;
            return;
        }
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] args) {
    }
}

