/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.UTMap;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.utils.Flag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTServerInfoSnapshot
implements Serializable,
Cloneable {
    protected transient Flag<UTServerState> serverStateFlag = new Flag<UTServerState>(UTServerState.NONE);
    protected boolean pingPong = true;
    protected int pongTimeoutMillis = 2000;
    protected boolean automaticallyReconnect = true;
    protected int autoReconnectMillis = 2000;
    protected URI gamebotsControlConnectionURI = null;
    protected URI gamebotsBotsURI = null;
    protected URI serverRemoteParserURI = null;
    protected boolean serverOpened = true;
    protected String name = null;
    protected transient List<Agent> bots = null;
    protected transient GameInfo gameInfo = null;
    protected transient List<NavPoint> navPoints = null;
    protected transient List<Item> items = null;
    protected transient List<UTMap> maps = null;
    protected transient Set<Player> players = null;
    protected transient Map<String, Item> inventory = null;

    public UTServerInfoSnapshot() {
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    protected void init() {
        this.bots = new ArrayList<Agent>();
        this.serverOpened = true;
        this.autoReconnectMillis = 2000;
        this.pongTimeoutMillis = 2000;
        this.automaticallyReconnect = true;
        this.pingPong = true;
        this.players = new HashSet<Player>();
    }

    public boolean isAutomaticallyReconnect() {
        return this.automaticallyReconnect;
    }

    public int getAutoReconnectMillis() {
        return this.autoReconnectMillis;
    }

    public List<Agent> getBots() {
        return this.bots;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<UTMap> getMaps() {
        return this.maps;
    }

    public String getName() {
        return this.name;
    }

    public List<NavPoint> getNavPoints() {
        return this.navPoints;
    }

    public boolean isPingPong() {
        return this.pingPong;
    }

    public Set<Player> getPlayers() {
        return this.players;
    }

    public int getPongTimeoutMillis() {
        return this.pongTimeoutMillis;
    }

    public boolean isServerOpened() {
        return this.serverOpened;
    }

    public URI getServerRemoteParserURI() {
        return this.serverRemoteParserURI;
    }

    public URI getGamebotsControlConnectionURI() {
        return this.gamebotsControlConnectionURI;
    }

    public URI getGamebotsBotsURI() {
        return this.gamebotsBotsURI;
    }

    public Object clone() {
        UTServerInfoSnapshot snapshot = new UTServerInfoSnapshot();
        snapshot.automaticallyReconnect = this.automaticallyReconnect;
        snapshot.autoReconnectMillis = this.autoReconnectMillis;
        snapshot.bots = this.bots;
        snapshot.gameInfo = this.gameInfo;
        snapshot.inventory = this.inventory;
        snapshot.items = this.items;
        snapshot.maps = this.maps;
        snapshot.name = this.name;
        snapshot.navPoints = this.navPoints;
        snapshot.pingPong = this.pingPong;
        snapshot.players = this.players;
        snapshot.pongTimeoutMillis = this.pongTimeoutMillis;
        snapshot.serverOpened = this.serverOpened;
        snapshot.serverRemoteParserURI = this.serverRemoteParserURI;
        snapshot.serverStateFlag = new Flag<UTServerState>(this.serverStateFlag.getFlag());
        snapshot.gamebotsBotsURI = this.gamebotsBotsURI;
        snapshot.gamebotsControlConnectionURI = this.gamebotsControlConnectionURI;
        return snapshot;
    }

    public Flag<UTServerState> getServerStateFlag() {
        return this.serverStateFlag;
    }

    public UTServerState getServerState() {
        return this.getServerStateFlag().getFlag();
    }

    public Map<String, Item> getInventory() {
        return this.inventory;
    }
}

