/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class LogFileStorage
implements Serializable {
    transient File fileCache = null;
    transient StreamHandler handler = null;
    String logString = "Log handler not closed";

    public LogFileStorage(Logger logger) throws IOException {
        this.init(logger, new SimpleFormatter());
    }

    protected void init(Logger logger, Formatter formatter) throws IOException {
        this.fileCache = File.createTempFile("pogamut", "log", null);
        this.fileCache.deleteOnExit();
        this.handler = new StreamHandler(new FileOutputStream(this.fileCache), formatter);
        logger.addHandler(this.handler);
    }

    public void close() {
        this.handler.close();
        this.loadLogToStr();
    }

    protected void loadLogToStr() {
        try {
            FileInputStream inputStream = new FileInputStream(this.fileCache);
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line + "\n");
            }
            this.logString = buffer.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(LogFileStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getLogString() {
        return this.logString;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.close();
        out.writeObject(this);
    }
}

