/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.astar;

import cz.cuni.astar.AStarGoal;
import cz.cuni.astar.AStarHeap;
import cz.cuni.astar.AStarHeapComparator;
import cz.cuni.astar.AStarMap;
import cz.cuni.astar.AStarResult;
import java.util.Collection;

public class AStar {
    public static AStarResult aStar(AStarGoal goal, AStarMap map, Object start, long iterationsMax) {
        AStarResult result = new AStarResult();
        AStarHeap open = new AStarHeap(new AStarHeapComparator(result.estimatedCost), 64);
        result.openList = open;
        Collection close = result.closeList;
        goal.setCloseList(result.closeList);
        goal.setOpenList(result.openList);
        result.startNode = start;
        result.putCostToNode(result.startNode, 0);
        result.putEstimatedCostToNode(result.startNode, goal.getEstimatedDistanceToGoal(result.startNode));
        open.add(result.startNode);
        while (!(open.empty() || iterationsMax >= 0L && result.interations >= iterationsMax)) {
            ++result.interations;
            Object node = open.getMin();
            if (node == null) {
                result.success = false;
                break;
            }
            open.deleteMin();
            if (goal.isGoalReached(node)) {
                result.goalNode = node;
                result.success = true;
                break;
            }
            int nodePathCost = result.getCostToNode(node);
            Collection neighbours = map.getNodeNeighbours(node);
            for (Object nextNode : neighbours) {
                int estimatedPathCost;
                if (!goal.isNodeOpened(nextNode)) continue;
                int travelCost = map.getEdgeCost(node, nextNode);
                int extraCost = goal.getExtraCost(node, nextNode);
                int nextNodePathCost = result.getCostToNode(nextNode);
                if (nextNodePathCost == -1) {
                    nextNodePathCost = nodePathCost + travelCost + extraCost;
                    if (nextNodePathCost < 0) {
                        nextNodePathCost = 0;
                    }
                    result.putCostToNode(nextNode, nextNodePathCost);
                    result.putPreviousNode(nextNode, node);
                    estimatedPathCost = nextNodePathCost + goal.getEstimatedDistanceToGoal(nextNode);
                    result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                    open.add(nextNode);
                    continue;
                }
                int newNextNodePathCost = nodePathCost + travelCost + extraCost;
                if (newNextNodePathCost < 0) {
                    newNextNodePathCost = 0;
                }
                if (newNextNodePathCost >= nextNodePathCost) continue;
                estimatedPathCost = newNextNodePathCost + goal.getEstimatedDistanceToGoal(nextNode);
                result.putCostToNode(nextNode, newNextNodePathCost);
                result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                if (close.contains(nextNode)) {
                    close.remove(nextNode);
                    open.add(nextNode);
                    continue;
                }
                if (open.contains(nextNode)) {
                    open.decreaseKey(node);
                    continue;
                }
                open.add(nextNode);
            }
            close.add(node);
        }
        return result;
    }

    public static AStarResult aStar(AStarGoal goal, AStarMap map, Object start) {
        return AStar.aStar(goal, map, start, -1L);
    }
}

