/*
 * Decompiled with CFR 0.152.
 */
package guntestbot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Main
extends Agent {
    public static final int BOT_SKILL = 2;
    public static final double BOT_ACCURACY = 1.0;
    public static final int MESSAGE_WAIT_TIME = 1000;
    private State myState = State.BEGIN;
    private Set<ItemType> weaponsToCollect = new HashSet<ItemType>();
    private KillListener killListener = new KillListener();
    private WeaponListener weaponListener = new WeaponListener();
    private Weapon collectingWeapon = null;
    private Set<Weapon> forbidden = new HashSet<Weapon>();
    private List<AddWeapon> collectedWeapons = new ArrayList<AddWeapon>();
    private int stuckCounter = 0;
    private String desiredNavPointUnrealID = "DM-GunTest.PathNode0";
    private String turnToNavPointUnrealID = "DM-GunTest.PathNode2";
    NavPoint desiredNavPoint = null;
    NavPoint turnToNavPoint = null;
    private ShowTimeStates showTimeState = ShowTimeStates.BEGIN;
    private List<AddWeapon> weaponsToShow = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLogic() {
        State state = this.myState;
        synchronized (state) {
            switch (this.myState) {
                case BEGIN: {
                    this.body.removeAllRaysFromAutoTrace();
                    this.body.configureAutoTrace(false);
                    this.myState = State.COLLECTING_WEAPONS;
                    break;
                }
                case COLLECTING_WEAPONS: {
                    this.stateCollectingWeapons();
                    break;
                }
                case RUNNING_TO_THE_DESIRED_NAVPOINT: {
                    this.startRunning();
                    this.stateRunningToTheDesiredNavPoint();
                    break;
                }
                case SHOWTIME: {
                    this.stateShowTime();
                    break;
                }
                default: {
                    this.log.severe("Unknown state: " + (Object)((Object)this.myState));
                    this.stopAgentSoft();
                }
            }
        }
    }

    private void startRunning() {
        this.stuckCounter = 0;
    }

    private boolean isStucked() {
        if (this.memory.getAgentVelocity().vectorSize() < 20.0) {
            ++this.stuckCounter;
        }
        return this.stuckCounter > 4;
    }

    private boolean arrivedToLocation(Triple location) {
        return Triple.distanceInSpace(location, this.memory.getAgentLocation()) < 60.0;
    }

    private void stateCollectingWeapons() {
        if (this.weaponsToCollect.size() == 0) {
            this.log.warning("Bot collected as many weapon types as he could.");
            this.myState = State.RUNNING_TO_THE_DESIRED_NAVPOINT;
            return;
        }
        if (this.collectingWeapon != null) {
            if (this.arrivedToLocation(this.collectingWeapon.location)) {
                if (this.memory.hasWeaponOfType(this.collectingWeapon.weaponType)) {
                    this.log.info("Weapon: " + (Object)((Object)this.collectingWeapon.weaponType) + " collected.");
                    this.collectingWeapon = null;
                    this.startRunning();
                    return;
                }
                this.log.fine("Waiting for the weapon " + (Object)((Object)this.collectingWeapon.weaponType) + " to respawn.");
                return;
            }
            if (!this.gameMap.safeRunToLocation(this.collectingWeapon.location) || this.isStucked()) {
                this.forbidden.add(this.collectingWeapon);
                this.collectingWeapon = null;
                return;
            }
            return;
        }
        double closest = Double.MAX_VALUE;
        Weapon closestWeapon = null;
        for (Weapon weapon : this.memory.getKnownWeapons()) {
            if (this.memory.hasWeaponOfType(weapon.weaponType) || this.forbidden.contains(weapon) || !(Triple.distanceInSpace(this.memory.getAgentLocation(), weapon.location) < closest)) continue;
            closest = Triple.distanceInSpace(this.memory.getAgentLocation(), weapon.location);
            closestWeapon = weapon;
        }
        if (closestWeapon != null) {
            this.collectingWeapon = closestWeapon;
            this.log.info("Trying to collect the weapon " + (Object)((Object)this.collectingWeapon.weaponType));
            return;
        }
        this.log.warning("Not all weapon types collected, some are unreachable.");
        this.myState = State.RUNNING_TO_THE_DESIRED_NAVPOINT;
    }

    private void stateRunningToTheDesiredNavPoint() {
        if (this.desiredNavPoint == null) {
            this.log.severe("This map doesn't have desired navpoint " + this.desiredNavPointUnrealID);
            this.stopAgentSoft();
            return;
        }
        if (this.arrivedToLocation(this.desiredNavPoint.location)) {
            this.log.info("Got to desired navpoint " + this.desiredNavPointUnrealID);
            if (this.turnToNavPoint == null) {
                this.log.severe("This map doesn't have desired turnto-navpoint " + this.turnToNavPointUnrealID);
                this.stopAgentSoft();
                return;
            }
            this.body.turnToTarget(this.turnToNavPoint);
            this.sleep(200L);
            this.myState = State.SHOWTIME;
            return;
        }
        if (!this.gameMap.safeRunToLocation(this.desiredNavPoint.location) || this.isStucked()) {
            this.log.severe("Can't get to desired navpoint " + this.desiredNavPointUnrealID);
            this.stopAgentSoft();
            return;
        }
    }

    private void stateShowTime() {
        switch (this.showTimeState) {
            case BEGIN: {
                this.messageShowTimeBegins();
                this.showTimeState = ShowTimeStates.SHOW_WEAPONS;
                this.weaponsToShow = new ArrayList<AddWeapon>();
                this.weaponsToShow.addAll(this.collectedWeapons);
                this.messageSkill(this.body.initializer.getBotSkillLevel(), this.body.initializer.getAccuracy());
                break;
            }
            case SHOW_WEAPONS: {
                this.stateShowWeapons();
            }
        }
    }

    private void stateShowWeapons() {
        if (this.weaponsToShow.size() != 0) {
            AddWeapon toShow = this.weaponsToShow.get(0);
            this.weaponsToShow.remove(0);
            this.body.changeWeapon(toShow);
            this.sleep(600L);
            this.messageShowWeapon(toShow.weaponType);
            this.messageFireWeapon(toShow.weaponType);
            this.body.shoot(this.turnToNavPoint.location);
            this.sleep(2000L);
            this.body.stopShoot();
            this.sleep(500L);
            this.messageFireAlternateWeapon(toShow.weaponType);
            this.body.shootAlternate(this.turnToNavPoint.location);
            this.sleep(2000L);
            this.body.stopShoot();
            this.sleep(500L);
            if (this.weaponsToShow.size() != 0) {
                this.messageTimeForMore();
                this.sleep(1000L);
            } else {
                this.messageShowEnds();
                this.sleep(1000L);
                this.stopAgentSoft();
            }
        } else {
            this.log.severe("No more weapons to show...");
            this.stopAgentSoft();
        }
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        for (Weapon weapon : this.memory.getKnownWeapons()) {
            this.weaponsToCollect.add(weapon.weaponType);
        }
        for (NavPoint navPoint : this.memory.getKnownNavPoints()) {
            if (this.desiredNavPoint != null && this.turnToNavPoint != null) break;
            if (this.desiredNavPoint == null && navPoint.UnrealID.equals(this.desiredNavPointUnrealID)) {
                this.desiredNavPoint = navPoint;
                continue;
            }
            if (this.turnToNavPoint != null || !navPoint.UnrealID.equals(this.turnToNavPointUnrealID)) continue;
            this.turnToNavPoint = navPoint;
        }
        this.body.initializer.setBotSkillLevel(2);
        this.body.initializer.setAccuracy(1.0);
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void messageSleep() {
        this.sleep(1000L);
    }

    private void messageGotAWeapon(ItemType weapon) {
        switch (this.random.nextInt(4)) {
            case 0: {
                this.body.sendGlobalMessage("Ha! I've got " + (Object)((Object)weapon) + ".");
                break;
            }
            case 1: {
                this.body.sendGlobalMessage("You loser, now try to get me, I've got " + (Object)((Object)weapon) + ".");
                break;
            }
            case 2: {
                this.body.sendGlobalMessage("So now I've got " + (Object)((Object)weapon) + ", you're bone man!");
                break;
            }
            case 3: {
                this.body.sendGlobalMessage("TADAAA! I've picked up " + (Object)((Object)weapon) + ", you dead-meat!");
                break;
            }
            default: {
                this.body.sendGlobalMessage("Ssssh, I've got " + (Object)((Object)weapon) + ".");
            }
        }
        this.messageSleep();
    }

    private void messageShowTimeBegins() {
        try {
            this.body.sendGlobalMessage("...in position. Now, the showtime begins! Watch me closely...");
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageSleep();
    }

    private void messageSkill(int skill, double accuracy) {
        switch (skill) {
            case 1: {
                this.body.sendGlobalMessage("My skill is '1' -> I'm total newbie!");
                break;
            }
            case 2: {
                this.body.sendGlobalMessage("My skill is '2' -> I know where the trigger is...");
                break;
            }
            case 3: {
                this.body.sendGlobalMessage("My skill is '3' -> May be I can shoot something down.");
                break;
            }
            case 4: {
                this.body.sendGlobalMessage("My skill is '4' -> Hey, I've got some skill");
                break;
            }
            case 5: {
                this.body.sendGlobalMessage("My skill is '5' -> I handle the Doom at 'Hurt me plenty' difficulty.");
                break;
            }
            case 6: {
                this.body.sendGlobalMessage("My skill is '6' -> I'm god's right hand!");
                break;
            }
            case 7: {
                this.body.sendGlobalMessage("My skill is '7' -> I'm the incarnation of His Hollines Itself!");
            }
        }
        this.body.sendGlobalMessage("My accuracy is " + accuracy + ".");
        this.messageSleep();
    }

    private void messageShowWeapon(ItemType weapon) {
        switch (this.random.nextInt(3)) {
            case 0: {
                this.body.sendGlobalMessage("Okey, this is " + (Object)((Object)weapon) + ".");
                break;
            }
            case 1: {
                this.body.sendGlobalMessage("Now I'm holding " + (Object)((Object)weapon) + ".");
                break;
            }
            case 2: {
                this.body.sendGlobalMessage("This iron baby is " + (Object)((Object)weapon) + ".");
                break;
            }
            default: {
                this.body.sendGlobalMessage("Watch out! This is " + (Object)((Object)weapon) + ".");
            }
        }
        this.messageSleep();
    }

    private void messageFireWeapon(ItemType weapon) {
        this.body.sendGlobalMessage("Hear the sweet sound of the " + (Object)((Object)weapon) + ".");
        this.messageSleep();
    }

    private void messageFireAlternateWeapon(ItemType weapon) {
        this.body.sendGlobalMessage("Does this " + (Object)((Object)weapon) + " have alternate fire?");
        this.messageSleep();
    }

    private void messageTimeForMore() {
        this.body.sendGlobalMessage("Now... time for more stuff...");
        this.messageSleep();
    }

    private void messageShowEnds() {
        this.body.sendGlobalMessage("So long, loser!");
        this.messageSleep();
    }

    public static void main(String[] args) {
    }

    private static enum ShowTimeStates {
        BEGIN,
        SHOW_WEAPONS;

    }

    private class WeaponListener
    implements RcvMsgListener {
        public WeaponListener() {
            Main.this.body.addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AddWeapon weapon = (AddWeapon)e.getMessage();
            if (weapon.ID == 0) {
                Main.this.collectedWeapons.add(weapon);
                Main.this.weaponsToCollect.remove((Object)weapon.weaponType);
                Main.this.messageGotAWeapon(weapon.weaponType);
            }
        }
    }

    private class KillListener
    implements RcvMsgListener {
        public KillListener() {
            Main.this.body.addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            State state = Main.this.myState;
            synchronized (state) {
                Main.this.myState = State.COLLECTING_WEAPONS;
                Main.this.collectedWeapons.clear();
                Main.this.showTimeState = ShowTimeStates.BEGIN;
            }
        }
    }

    private static enum State {
        BEGIN,
        COLLECTING_WEAPONS,
        RUNNING_TO_THE_DESIRED_NAVPOINT,
        SHOWTIME;

    }
}

