
/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


//=============================================================================
// RemoteBot.
// Basedon Bot class
//=============================================================================
class RemoteBot extends UTBot
	config(GameBots2007);


var config bool bDebug;

//maybe link to bot's periphreal vision? UT bots need much less of an arc though
//like Pawn's PeriphrealVision, this value should be the cosine of the limits
//of visual field. (i.e. 0.707 = 45 degrees to each side, or a 90* arc.)
var config float remoteVisionLimit;

//The socket to the agent
var BotConnection myConnection;


//The three remote vars compliment the my vars right below. The only one
//that ever needs to be duplicated is RemoteEnemy and myTarget
//just need RemoteDestination || myDestination and RFocus || myFocus

//Who the remote bot is trying to shoot at. Used by the aiming code.
var Actor RemoteEnemy;
//Thing the remote bot is trying to move to.
var Actor RemoteDestination;
//Thing the remote bot is looking at.
var Actor myFocus;

//The spot the bot is shooting at
var FocusActorClass myTarget;

//If false, we will update myTarget location according our current focal point
var bool bTargetLocationLocked;

//The spot the bot is moving to
var vector myDestination;
//The spot the bot is looking at
var vector myFocalPoint;

var class<UTPawn> PawnClass;

//This is an indicator that we are in StartUp:MoveContinuous state. We need this, so turn
//command work properly when the bot is moving continuous!
var bool movingContinuous;

//Used for smooth movement, see StartUp state
var vector pendingDestination;

//If true bot will respawn automatically when killed
var config bool bAutoSpawn;

//When true auto raytracing producing sync. ATR messsages will be on
var config bool bAutoTrace;

//If true we will draw trace lines (results of AutoTrace() functionsin BotConnection)
//in the game
var config bool bDrawTraceLines;

//If we should spawn an actor at the point the bot has set as focal point
var config bool bShowFocalPoint;

//If we should provide aim correct based on bot Skill also when shooting at Location
var config bool bPerfectLocationAim;

//If we should include FadeOut attribute into message text or not. for debug.
var config bool bIncludeFadeOutInMsg;

//maximum number we can multiply BaseSpeed of the bot
var config float MaxSpeed;

//Used for changing the bot appearance. see GBxPawn.Setup() function
var config string DesiredSkin;

//TODO: Probably not used anymore - delete
var bool bSecondJumpPossible;

//For disabling auto pickup, custom varialbe, will affect Pawn.bCanPickupInventory
var config bool bDisableAutoPickup;

//By this default pawn speed will be multiplied ranges from 0.1 to 2
var config float SpeedMultiplier;

//helper variable to store the direction we want to go with CMOVE
var vector cmoveDirection;

//this is here, so we can properly debug the bot in java. it is the adress we need
//to connect to in order to debug the bot (in Pogamut the bots are now run each one in
//different JVM)
var string jmx;

//holing last bump time to avoid sending the message repeatably
var float lastBumpTime;





//override - using translocator in this function
function Actor FaceActor(float StrafingModifier)
{
	return none;
}


//Called at the start of the match
function StartMatch()
{
	// SENDMESSAGE
	// !!! possible new message
}


//This function will properly destroy the pawn of this conroller (otherwise conflicts with game mechanics)
function DestroyPawn()
{
	if (Pawn == None)
		return;

	Pawn.Died(none, class'DamageType', Pawn.Location);
}

//This function is called by the RESPAWN command - it makes sure everything will work ok
function RespawnPlayer(optional vector startLocation, optional rotator startRotation)
{
	if (IsInState('Dead') && !bAutoSpawn) //
	{
		RemoteRestartPlayer(startLocation,startRotation);
	}
	else if (bAutoSpawn)
	{
		bAutoSpawn = false; //otherwise it would get respawned in Dead state without specifyed locatin, rotation
		DestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);
		bAutoSpawn = true;

	}
	else  if (!IsInState('Dead') && !bAutoSpawn)
	{
		DestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);

	}
}

//This function handles actual bot respawning - when it dies for instance
function RemoteRestartPlayer(optional vector startLocation, optional rotator startRotation)
{
	if( WorldInfo.Game.isA('BotDeathMatch'))
	{
		BotDeathMatch(WorldInfo.Game).RemoteRestartPlayer( self, startLocation, startRotation );
	}

	if (Pawn != None)
	{
		gotostate('StartUp','DoStop');
	}
	else
	{
		`log("Pawn is None after ResartPlayer");
	}

}

//Function which determines if our weapon should fire again or stop firing
function bool WeaponFireAgain(bool bFinishedFire)
{

	if (!RemoteHasAmmo())
	{
		Super.StopFiring();
		return false;
	}

	return true;
}

//Use from local code - stops firing and ticks weapon to let it stop
function HaltFiring()
{
	if ((Pawn != none) && (Pawn.Weapon != none))
	{
		Pawn.Weapon.StopFire(0);
		Pawn.Weapon.StopFire(1);
	}


}

//we have to override this function, otherwise US will reset our vision settings
//and etc..
function ResetSkill()
{
	//`log("We are in ResetSkill");
}

//Overriding function, otherwise code from states in Bot.uc would be executed
function HearPickup(Pawn Other)
{
	//myConnection.SendLine("HRP" $ib$as$"Rotation" $ib$ rotator(Location - Other.Location) $ae);
}

event SoakStop(string Problem)
{
	myConnection.SendLine("SOAKED {Problem " $ Problem $"}");
	`log("We are Soaked! Problem: "$Problem);
}



//Called right before bot falls off something
//If bot running, set bCanJump to true - let him fall
//if walking, won't fall
event MayFall()
{
	local bool bFall;

	bFall = !Pawn.bIsWalking;

	if(!bfall)
	{
		GotoState('Startup', 'Begin');
	}

	myConnection.SendLine("FAL {Fell " $ bFall $
		"} {Location " $ Pawn.Location $
		"}");

	Pawn.bCanJump = bFall;
}

//Called when the bot land on the ground after falling
function bool NotifyLanded(vector HitNormal, Actor FloorActor)
{
	myConnection.SendLine("LAND {HitNormal " $ HitNormal $ "}");

	//restart, so we continue moving and not going back to our previous
	//destination, as we may be over it because of the fall
	if (movingContinuous)
		gotoState('StartUp','MoveContRepeat');
	return true;
}

//TODO: This function returns wrong numbers - reimplement?
function float GetSpeed()
{
	if(Pawn.bIsWalking)
	{
		return Pawn.WalkingPct;
	}
	else
	{
		return 1.0;
	}
}

// Called when get new weapon or ammunition for weapon we do not have yet.
// Called just once per weapon type or per new ammunition type (notify new object in our inventory, NOT pickup)
// For exporting weapons we have new attributes.
function NotifyAddInventory( Inventory inputInventory )
{
	local string outstring;

	//For weapons
	local Weapon inputWeapon;
	local bool bUseAlternateAmmo;

	Super.NotifyAddInventory(inputInventory);

    outstring = "AIN {Id " $ myConnection.GetUniqueId(inputInventory) $
		"} {Type " $ inputInventory.class $
		//"} {PickupType " $ inputInventory.PickupClass $
		"}";

	myConnection.SendLine(outstring);
}

function SetHealth(int amount)
{
	if (Pawn == none)
		return;
	if ((amount > 0) && (amount < 200))
		Pawn.Health = amount;
}


//functions to send tokenized messages
/*
function SendTeamMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//`log(self@"Send message"@MessageType@MessageID@"at"@WorldInfo.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (WorldInfo.TimeSeconds - OldMessageTime < Wait) )
		return;

	//`log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'TEAM');
}*/
/*
function SendGlobalMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//`log(self@"Send message"@MessageType@MessageID@"at"@WorldInfo.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (WorldInfo.TimeSeconds - OldMessageTime < Wait) )
		return;

	//`log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'GLOBAL');
}*/


//handles sending messages to all and to team
function RemoteBroadcast( string Id, coerce string Msg, bool bGlobal, float FadeOut )
{

	local Controller C;
	local string MsgForVoice;

	MsgForVoice = Msg;
	if (bIncludeFadeOutInMsg)
		Msg = Msg $ " FadeOut=" $ FadeOut $ " s.";


    //Set the text bubble, which will be shown on the HUDs of Human players
    //when they see the bot
    if (Pawn != none)
   	{
   		//if (bSpeakingBots)
	   		//Pawn.TextToSpeech( MsgForVoice, 10 );
		//GBxPawn(Pawn).SetTextBubble(Id, Msg, bGlobal, FadeOut);
	}

	if (Id != "")
	{

		//If we haven't found Id or Id doesn't belong to RemoteBot we will end
		return;
	}

	if ( bGlobal || !WorldInfo.Game.bTeamGame )
	{
	    //Send the message to the game channel
	    WorldInfo.Game.Broadcast(self, Msg, 'Say');
	    //Send the message to RemoteBots
	    SendGlobalMessage( Msg );
	    return;
	}

	if (WorldInfo.Game.bTeamGame)
	{
		//Send the message to team channel
		WorldInfo.Game.BroadcastTeam(self, Msg, 'TeamSay');
		//Send the message to RemoteBots
		SendTeamMessage( Msg );
		return;
	}
}

//Event for receiving string messages, called manually
event RemoteNotifyClientMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	S = Repl(S, "{", "_", false );
	S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMS {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//Event for receiving string messages, called manually
event RemoteNotifyTeamMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	S = Repl(S, "{", "_", false );
	S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMT {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//Send the team message to RemoteBots
function SendTeamMessage( string S )
{
	local Controller C;

}

//Send the global message to RemoteBots
function SendGlobalMessage( string S )
{
	local Controller C;

}

//other code may try to call this. make sure nada happens
//!!! need to change - make sure orders are actually recorded somewhere
//             for reference
function SetOrders(name NewOrders, Controller OrderGiver);

//events that are called when head, feet or whole bot changes zones
//e.g. air to water or lava
//only way to tell if underwater until drowning damage starts
/*
function FootZoneChange(ZoneInfo newFootZone)
{
	Super.FootZoneChange(newFootZone);

	myConnection.SendLine("ZCF" $ib$as$ "Id" $ib$ newFootZone $ae);
}
function HeadZoneChange(ZoneInfo newHeadZone)
{
	Super.HeadZoneChange(newHeadZone);

	myConnection.SendLine("ZCH" $ib$as$ "Id" $ib$ newHeadZone $ae);
} */

//The bot (or some part of the bot - legs) entered new volume
event NotifyPhysicsVolumeChange( PhysicsVolume NewVolume )
{

	//this code is taken from super class (Bot). Had to disable automatic jumping out of water
	//super class is not called anymore
	if ( newVolume.bWaterVolume )
	{
		bPlannedJump = false;
		if (!Pawn.bCanSwim)
			MoveTimer = -1.0;
		else if (Pawn.Physics != PHYS_Swimming)
			Pawn.setPhysics(PHYS_Swimming);
	}
	else if (Pawn.Physics == PHYS_Swimming)
	{
		if ( Pawn.bCanFly )
			 Pawn.SetPhysics(PHYS_Flying);
		else
		{
			Pawn.SetPhysics(PHYS_Falling);
			/*if ( Pawn.bCanWalk && (Abs(Pawn.Acceleration.X) + Abs(Pawn.Acceleration.Y) > 0)
				&& (Destination.Z >= Pawn.Location.Z)
				&& Pawn.CheckWaterJump(jumpDir) )
			{
				Pawn.JumpOutOfWater(jumpDir);
				bNotifyApex = true;
				bPendingDoubleJump = true;
			}*/
		}
	}

	myConnection.SendLine("VCH {Id " $ myConnection.GetUniqueId(NewVolume) $
		"} {ZoneVelocity " $ NewVolume.ZoneVelocity $  //vector
		//"} {ZoneGravity " $ NewVolume.Gravity $  //vector
		//"} {GroundFriction " $ NewVolume.GroundFriction $  //float
		//"} {FluidFriction " $ NewVolume.FluidFriction $  //float
		//"} {TerminalVelocity " $ NewVolume.TerminalVelocity $  //float
		//"} {WaterVolume " $ NewVolume.bWaterVolume $
		//"} {PainCausing " $ NewVolume.bPainCausing $
		//"} {Destructive " $ NewVolume.bDestructive $
		//"} {DamagePerSec " $ NewVolume.DamagePerSec $ //float
		//"} {DamageType " $ NewVolume.DamageType $
		//"} {NoInventory " $ NewVolume.bNoInventory $
		//"} {MoveProjectiles " $ NewVolume.bMoveProjectiles $
		//"} {NeutralZone " $ NewVolume.bNeutralZone $
		"}");


}





//called on collisions with other actors
event bool NotifyBump(Actor Other, Vector HitNormal)
{
	local vector VelDir, OtherDir;
	local float speed;


	speed = VSize(Velocity);
	if ( speed > 10 )
	{
		VelDir = Velocity/speed;
		VelDir.Z = 0;
		OtherDir = Other.Location - Location;
		OtherDir.Z = 0;
		OtherDir = Normal(OtherDir);
		if ( (VelDir Dot OtherDir) > 0.8 )
		{
			Velocity.X = VelDir.Y;
			Velocity.Y = -1 * VelDir.X;
			Velocity *= FMax(speed, 280);
		}
	}

	if ( WorldInfo.TimeSeconds - 0.5 >= lastBumpTime )
	{

		myConnection.SendLine("BMP {Id " $ myConnection.GetUniqueId(Other) $
			"} {Location " $ Other.Location $"}");

		lastBumpTime = WorldInfo.TimeSeconds;
	}

	// Need to disable bumping ???
	//Disable('Bump');
	//TODO: Experiment with this?
	return false;
}



/* Added func RemoteKilled - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteKilled(Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType)
{
	local string outstring;

	outstring = "KIL {Id " $ myConnection.GetUniqueId(Killed) $
		"} {KilledPawn " $ KilledPawn $
        "} {Killer " $ myConnection.GetUniqueId(Killer) $
		"}";
	if (CanSee(KilledPawn))
	{
		outstring = outstring $ " {DamageType " $ damageType $
        //"} {DeathString " $ damageType.default.DeathString $
        //"} {WeaponName " $ damageType.default.DamageWeaponName $
        //"} {Flaming " $ damageType.default.bFlaming $
        //"} {CausedByWorld " $ damageType.default.bCausedByWorld $
        //"} {DirectDamage " $ damageType.default.bDirectDamage $
        //"} {BulletHit " $ damageType.default.bBulletHit $
        //"} {VehicleHit " $ damageType.default.bVehicleHit $
		"}";
	}

	myConnection.sendLine(outstring);
}

/* Added func RemoteDied - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteDied(Controller Killer, class<DamageType> damageType)
{
	myConnection.SendLine("DIE {Killer " $ myConnection.GetUniqueId(Killer) $
		"} {DamageType " $ damageType $
        //"} {DeathString " $ damageType.default.DeathString $
        //"} {WeaponName " $ damageType.default.DamageWeaponName $
        //"} {Flaming " $ damageType.default.bFlaming $
        //"} {CausedByWorld " $ damageType.default.bCausedByWorld $
        //"} {DirectDamage " $ damageType.default.bDirectDamage $
        //"} {BulletHit " $ damageType.default.bBulletHit $
        //"} {VehicleHit " $ damageType.default.bVehicleHit $
		"}");
}





//Jumps a bot
function RemoteJump(bool bDouble)
{

	if (Pawn == none)
		return;


}

//Intercept FireWeapon - is called from other code
function FireWeapon();

function bool RemoteHasAmmo()
{
  return true;
}

function RemoteFireWeapon(bool bUseAltMode)
{

	if ((Pawn == none) || (Pawn.Weapon == none))
		return;

	if (bUseAltMode)
		Pawn.Weapon.StartFire(1);
	else
		Pawn.Weapon.StartFire(0);
}



function bool TryToDuck(vector duckDir, bool bReversed);

// CloseToPointMan - called if orders are 'follow' to check if close enough to point man
function bool CloseToPointMan(Pawn Other)
{
	//return what engine wants to hear
	return true;
}

//Don't need our bots autotaunting
function MaybeTaunt(Pawn Other);

//Called when someone other than this bot dies.
//TODO: We dont need this
function Killed(pawn Killer, pawn Other, name damageType);

//Pointless callback
function EnemyAcquired();

//All kinds of things can call this mostly special trigger points
function Trigger( actor Other, pawn EventInstigator )
{
	myConnection.SendLine("TRG {Actor " $ myConnection.GetUniqueId(Other) $
		"} {EventInstigator " $ myConnection.GetUniqueId(EventInstigator) $
		"}");
}

//Much of translocator brains implemented in translocator
//For now better off playing without it - need to research how
//it interacts with path finding
function TranslocateToTarget(Actor Destn)
{
	//MyTranslocator.DesiredTarget = Destn;
}

//Don't let engine pick nodes that must be impact jumped
function bool CanImpactJump()
{
	return false;
}

//Don't handle impact jumps or low gravity manuevers for bots
function ImpactJump();
function BigJump(Actor JumpDest);

//Don't have engine direct to Ambush
function bool FindAmbushSpot()
{
	return false;
}




function SetFall()
{
	if (Pawn.bCanFly)
	{
		Pawn.SetPhysics(PHYS_Flying);
		return;
	}
	if (bDebug)
		`log("In RemoteBot.uc: SetFall() enganged.");
	/*
	if ( Pawn.bNoJumpAdjust )
	{
		Pawn.bNoJumpAdjust = false;
		return;
	}
	else
	{
		bPlannedJump = true;
		Pawn.Velocity = EAdjustJump(Pawn.Velocity.Z,Pawn.GroundSpeed);
		Pawn.Acceleration = vect(0,0,0);
	} */
}


//**********************************************************************************
//Base RemoteBot AI, that controls the Pawn (makes him move)

auto state StartUp
{
	function BeginState(Name PreviousStateName)
	{
		//`log("StartUp,BeginState");
		//TODO:HACK: Should examine Squad issues if it should be here

        movingContinuous = false;
/*
		if (Squad == none)
			Squad = spawn(class'GBSquadAI');

		Squad.AddBot(self);
*/
	}
Begin:
	movingContinuous = false;
    //This is necessary, because if someone keeps shooting on our bot,
	//sometimes it starts sliding to side
	//`log("Physics "$Physics$"Pawn Physics "$Pawn.Physics);
	if (Pawn != none)
	{
		if (Pawn.Physics != PHYS_Falling)
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
 	sleep(0.5);
	goto 'Begin';
DoStop:
	movingContinuous = false;
	if (Pawn != none)
	{
		if (Pawn.Physics == PHYS_Falling) //TODO: This is just a test, but it should repair one issue.
		{
			WaitForLanding(); //We wait when we are on ground and THEN we will stop.
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0;
		}
		else
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
	//Pawn.PlayWaiting();
	goto 'Begin';
MoveToActor:
	movingContinuous = false;
	if (Pawn != None)
	{
		MoveToward(MoveTarget, , , , Pawn.bIsWalking);
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
Move: //Moves swiftly between two locations - could be a problem normaly because of TCP/IP delays
	movingContinuous = false;
	if (Pawn != None)
	{
		if (Focus == none)
		{
			MoveTo( myDestination, , Pawn.bIsWalking );
			MoveTo( pendingDestination, , Pawn.bIsWalking);
		}
		else
		{
			MoveTo( myDestination, Focus, Pawn.bIsWalking );
			MoveTo( pendingDestination, Focus, Pawn.bIsWalking);
		}
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
MoveContinuous:
	if (Pawn != None)
	{
		//to prevent that our focal point moves too much above or below us
		//remember we want to move
		myFocalPoint.z = Pawn.Location.z;
	 	cmoveDirection = vector(rotator(myFocalPoint - Pawn.Location));
	}
MoveContRepeat:
	if (Pawn != None)
	{
		movingContinuous = true;
		MoveTo( Pawn.Location + 500 * cmoveDirection, , Pawn.bIsWalking );

		myFocalPoint = Pawn.Location + 500 * cmoveDirection;
		FocalPoint = myFocalPoint;
		goto 'MoveContRepeat';
	}
	goto 'Begin';
}

// This state was called somehow on our bot. That is highly undersirable.
// Overriding
state Roaming
{
	function BeginState(Name PreviousStateName)
	{
		//`log("In Roaming STATE! Shouldnt be!");
		gotostate('StartUp','Begin');
	}
Begin:
	gotostate('StartUp','Begin');
}

state TakeHit
{
	//ignores seeplayer, hearnoise, bump, hitwall;

	function Timer();

Begin:
	//error("!!!TakeHit");
}

state GameEnded
{
ignores SeePlayer, EnemyNotVisible, HearNoise, TakeDamage, Bump, Trigger, HitWall, Falling, ReceiveWarning;

	function SpecialFire()
	{
	}
	function bool TryToDuck(vector duckDir, bool bReversed)
	{
		return false;
	}
	function SetFall()
	{
	}
	function LongFall()
	{
	}
	function Killed(pawn Killer, pawn Other, name damageType)
	{
	}
	function ClientDying(class<DamageType> DamageType, vector HitLocation)
	{
	}

	function BeginState(Name PreviousStateName)
	{
		//Pawn.SimAnim.AnimRate = 0.0;
		bFire = 0;
		//bAltFire = 0;

		SetCollision(false,false,false);
		SetPhysics(PHYS_None);
		Velocity = vect(0,0,0);
		myConnection.SendLine("FIN");
	}
}

state Dead
{
ignores SeePlayer, HearNoise, KilledBy;

function BeginState(Name PreviousStateName)
{
	//`log("State: Dead, fc BeginState()");

	//We can be sent to this state sometimes, when it is not desired ( by game mechanics)
	//Escaping here
	if (Pawn != none)
		gotostate('StartUp','Begin');

	//This is taken from working AI in UT2004, probably needed to assure bot
	//will behave normally after restart - 02/03/07 Michal Bida
	movingContinuous = false;
	Enemy = None;
	Focus = None;
	Target = None;
	RouteGoal = None;
	MoveTarget = None;
	bFire = 0;

	Super.StopFiring(); //Not needed anymore to call super, but for sure.
/*	FormerVehicle = None;
	bFrustrated = false;
	BlockedPath = None;
	bInitLifeMessage = false;
	bPlannedJump = false;
	bInDodgeMove = false;
	bReachedGatherPoint = false;
	bFinalStretch = false;
	bWasNearObjective = false;
	bPreparingMove = false;
	bEnemyEngaged = false;
	bPursuingFlag = false;
*/


}
/*
function EndState()
{
	myConnection.sendLine("SPW2");
}*/
Begin:
	`log("In Dead:Begin:");
	//AutoSpawn policy
	if (Pawn != None)
		gotostate('StartUp','Begin');

	if (bAutoSpawn)// && !WorldInfo.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	//	if (Pawn == none) //bug during restart?
	//		goto('Begin');
		//ServerRestartPlayer(); //Dunno if this is needed here - Could it cause troubles?
	}

	if (Pawn != None)
		gotostate('StartUp','Begin');
/*	if (!WorldInfo.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	}
	if (Pawn != None)
		gotostate('StartUp','Begin');*/
	sleep(1.0);
	goto('Begin');

}



//-------------RemoteBot Specific Functions--------------------


//Check to see if a location is really in front of the bot
//may be a more efficient algorithm
function bool inFront(Vector A)
{
	local rotator angle;

	//can't be infront if inside bot
	//if( VSize(Pawn.Location - A) < CollisionRadius )
		//return false;

	angle = ( Pawn.Rotation - rotator(A - Pawn.Location) );

	if( (cos(angle.Yaw / 10435.0) < remoteVisionLimit) ||
		(cos(angle.Pitch / 10435.0) < remoteVisionLimit) )
		return false;
	else
		return true;
}


//Called by the gametype when someone else is injured by the bot
//TODO: From old gamebots, is not called anymore, TO REMOVE - mb
/*
function int HurtOther(int Damage, name DamageType, pawn injured)
{
	myConnection.SendLine("HIT" $ib$as$ "Id" $ib$ injured $ae$ib$as$
		"Damage" $ib$ Damage $ae$ib$as$
		"DamageType" $ib$ DamageType $ae);
} */

function checkSelf()
{
	local string outstring, TeamIndex, altFiring;
	local rotator PawnRotation;
	local bool bIsShooting;

	local vector FloorLocation, FloorNormal;

	if(WorldInfo.Game.isA('BotTeamGame'))
	{
		TeamIndex = string(PlayerReplicationInfo.Team.TeamIndex);
	}
	else
	{
    	TeamIndex = "255";
	}

  if( Pawn != none )
	{
		if( Pawn.Weapon != None)
		    bIsShooting = Pawn.Weapon.IsFiring();

		PawnRotation = Pawn.Rotation;
		//PawnRotation.Pitch = int(Pawn.ViewPitch) * 65556/255;

		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal,Pawn.Location + vect(0,0,-1000),Pawn.Location, false, ,);

		outstring = "SLF {Id " $ myConnection.GetUniqueId(self) $
			"} {Vehicle False" $
			"} {Rotation " $ PawnRotation $
			"} {Location " $ Pawn.Location $
			"} {Velocity " $ Pawn.Velocity $
			"} {Name " $ PlayerReplicationInfo.PlayerName $
			"} {Team " $ TeamIndex $
			"} {Health " $ Pawn.Health $
			"} {Weapon " $ Pawn.Weapon $
			"} {Shooting " $ bIsShooting $
			//"} {Armor " $ int(Pawn.ShieldStrength) $
			//"} {SmallArmor " $ int(xPawn(Pawn).SmallShieldStrength) $
			//"} {Adrenaline " $ int(Adrenaline) $
			"} {Crouched " $ Pawn.bIsCrouched $
			"} {Walking " $ Pawn.bIsWalking $
			"} {FloorLocation " $ FloorLocation $
			"} {FloorNormal " $ FloorNormal $
			//"} {Combo " $ xPawn(Pawn).CurrentCombo $
			//"} {UDamageTime " $ xPawn(Pawn).UDamageTime $
			"}";


		if( Pawn.Weapon != None)
		{
			if (Pawn.Weapon.HasAnyAmmo())
				outstring = outstring $" {PrimaryAmmo 1} {SecondaryAmmo 0}";
			else
				outstring = outstring $" {PrimaryAmmo 0} {SecondaryAmmo 0}";

/*
			if( Pawn.Weapon.GetFireMode(1).IsFiring() )
			{
				outstring = outstring $" {AltFiring True}";
			}
			else
			{
				outstring = outstring $" {AltFiring False}";
			}*/
		}

        //`log("Debug: bFire "$bFire$" bAltFire "$bAltFire);

		myConnection.sendLine(outstring);
	}
	else
	{
		`log("Pawn is none in CheckSelf() ");
	}


}

function checkVision()
{
	local PickupFactory Pickup; //Respawned Inventory on the map is now Pickup;
	local Controller C;
	local NavigationPoint N;
	local int temp;
	local string outstring, TeamIndex, WeaponClass;
	local bool flagVisible;

	//for PRJ
	local Projectile Proj;
	local vector FireDir;
	local float projDistance;

	if( Pawn == none )
	{
		`log("In CheckVision() - Pawn is none ");
		return;
	}

	//!!! view rotation sometimes falls out of synch with rotation? wtf?
	foreach WorldInfo.AllControllers(class'Controller', C)
	{
		if( C != self && C.Pawn != none && CanSee(C.Pawn))//to match peripheral vision
		{

			if(WorldInfo.Game.isA('BotTeamGame'))
			{
				TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
			}
			else
			{
    			TeamIndex = "255";
			}
			if (C.Pawn.Weapon != none)
			{
				WeaponClass = string(C.Pawn.Weapon.Class);
			}
			else
			{
				WeaponClass = "None";
			}
			outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
				"} {Rotation " $ C.Pawn.Rotation $
				"} {Location " $ C.Pawn.Location $
				"} {Velocity " $ C.Pawn.Velocity $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {Team " $ TeamIndex $
				"} {Reachable " $ actorReachable(C.Pawn) $
				"} {Weapon " $ WeaponClass $
				"}";
/*
			if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(0).IsFiring() )
				outstring = outstring $" {Firing 1}";
			else if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(1).IsFiring() )
				outstring = outstring $" {Firing 2}";
			else
				outstring = outstring $" {Firing 0}";
*/
			myConnection.sendLine(outstring);

        }//end if
	}//end for P=WorldInfo.ControllerList

	foreach DynamicActors(class'PickupFactory',Pickup)
	{
		if( (Pickup.GetStateName() == 'Pickup') && !Pickup.bHidden && inFront(Pickup.Location) && LineOfSightTo(Pickup) )
		{
			myConnection.SendLine("INV {Id " $ myConnection.GetUniqueId(Pickup) $
				"} {Location " $ Pickup.Location $
				"} {Type " $ Pickup.Class $
				"}");
		}
	}
	foreach WorldInfo.AllNavigationPoints(class'NavigationPoint', N)
	{
		//Added attribute Visible, so inFront is not here anymore
		if( LineOfSightTo(N))//FastTrace(N.Location) )
		{

				outstring = "NAV {Id " $ N $
					"} {Location " $ N.Location $
					"} {Visible " $ inFront( N.Location ) $
					"} {Reachable " $ actorReachable(N) $
					"}";
			/*	Location returned to all NavPoints for now
			if (N.IsA('LiftCenter'))
   				{
   					outstring = outstring $ " {Location "$ N.Location $"}";
   				}*/
				myConnection.SendLine(outstring);
			
		}
	}//end for N=WorldInfo.NavigationPointList
	
}


simulated event Destroyed()
{



	//Destroying bot Pawn
	DestroyPawn(); //kill him properly first
	if (Pawn != None)
	{
		Pawn.Destroy();//destroy him
		Pawn = None;
    }

	//Destroying actor for aiming our shooting on location
    if (myTarget != none)
    {
		myTarget.Destroy();
	}

	if (myConnection != none)
		myConnection.SendLine("FIN");
	else
		`log("Problem with sending FIN, myConnection = none");

    Super.Destroyed();
}

function ChangeWeapon();
state MoveToGoal
{
	function BeginState(Name PreviousStateName);
}

function ServerChangedWeapon(Weapon OldWeapon, Weapon NewWeapon);


//-----------------

defaultproperties
{
	remoteVisionLimit=0.707000
	SpeedMultiplier=1.0
	bDrawTraceLines=true
	bIncludeFadeOutInMsg=true
	bShowFocalPoint=false
	bPerfectLocationAim=false
	bSpeakingBots=true
	bAutoTrace=false
	bAutoSpawn=true
	MaxSpeed=2.00000
	DesiredSkin="ThunderCrash.JacobM"
	PawnClass=Class'UTGame.UTPawn'
}
