/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


class GBClientClass extends TcpLink
	config(GameBots2007);

//Maximum number of arguments
const ArgsMaxCount = 15;

// the main variables where we have incoming messages stored
var string ReceivedData;
var string ReceivedArgs[ArgsMaxCount];
var string ReceivedVals[ArgsMaxCount];

//for `logging purposes
var string lastGBCommand;

// enables disables cheating - invulnerability, spawning items for bots
var config bool bAllowCheats;

// if control server or bots can or cannot pause the game
var config bool bAllowPause;

var GBClientClass Next; //create list of all classes


//Here is where we handle incoming commands
/* Commands expected to look like:
runto {Argument value} {Arg value}...
Currently hard coded to take no more than ArgsMaxCount args
Command type and arguments can be
any length, but first space terminates the name. Values can
have spaces or any other kind of character.
*/
function ReceivedLine(string S)
{
	local string cmdType, argBody, rem;
	local int endloc, wordsplit, attrNum;

	if(bDebug)
		`log(S);

	wordsplit = InStr(S," ");
	if( wordsplit == -1)
		wordsplit = Len(S);

	cmdType = left(S,wordsplit);
	rem = mid(S,InStr(S,"{"));

	attrNum = 0;
	// clear previously received attr/val pairs
	while(attrNum < ArgsMaxCount)
	{
		if (ReceivedArgs[attrNum] == "")
			break;

		ReceivedArgs[attrNum] = "";
		ReceivedVals[attrNum] = "";

		attrNum++;
	}

	attrNum = 0;

	//iterate through attr/val pairs, storring them in the
	//parallel arrays ReceivedArgs and ReceivedVals
	while(attrNum < ArgsMaxCount && rem != "")
	{
		endloc = InStr(rem,"}");
		argBody = mid(rem,1,(endloc - 1));

		wordsplit = InStr(argBody," ");
		ReceivedArgs[attrNum] = left(argBody,wordsplit);
		ReceivedVals[attrNum] = mid(argBody,(wordsplit + 1));

		rem = mid(rem,1); //advance
		rem = mid(rem,InStr(rem,"{"));
		attrNum++;
	}

	cmdType = Caps(cmdType);

	ProcessAction(cmdType);
}

//Recieve info - parse into lines and call RecievedLine
event ReceivedText( string Text )
{
	local int i;
	local string S;

    if(bDebug)
    	`log("Recieved - "$Text);

	ReceivedData = ReceivedData $ Text;
	//for `logging purposes
	lastGBCommand = Text;

	// remove a LF which arrived in a new packet
	// and thus didn't get cleaned up by the code below
	if(Left(ReceivedData, 1) == Chr(10))
		ReceivedData = Mid(ReceivedData, 1);
	i = InStr(ReceivedData, Chr(13));
	while(i != -1)
	{
		S = Left(ReceivedData, i);
		i++;
		// check for any LF following the CR.
		if(Mid(ReceivedData, i, 1) == Chr(10))
			i++;

		ReceivedData = Mid(ReceivedData, i);

		ReceivedLine(S);

		if(LinkState != STATE_Connected)
			return;

		i = InStr(ReceivedData, Chr(13));
	}
}

function ProcessAction(string cmdType)
{
	//Shouldnt be called, just for inheritance
	`log("Error - we are in GBClientClass, ProcessAction() ");
}

// function for getting string value of input received attribute
function string GetArgVal(string argName)
{

	local int i;
	while (i < 9 && ReceivedArgs[i] != "")
	{
		if (ReceivedArgs[i] ~= argName)
			return ReceivedVals[i];
		i++;
	}

	return "";
}

// should use int's for locations rather than floats
// we don't need to be that precise
function ParseVector(out vector v, string vecName)
{
	local int i;
	local string rem;
	local string delim;

	delim = " ";

	rem = GetArgVal(vecName);
	if(rem != "")
	{
		if( InStr(rem,delim) == -1 )
			delim = ",";
		i = InStr(rem,delim);
		v.X = float(left(rem,i));
		rem = mid(rem,i+1);
		i = InStr(rem,delim);
		v.Y = float(left(rem,i));
		v.Z = float(mid(rem,i+1));
	}
	else
	{
		v.x = float( GetArgVal("x") );
		v.y = float( GetArgVal("y") );
		v.z = float( GetArgVal("z") );
	}
}

// function for parsing rotation
function ParseRot(out rotator rot, string rotName)
{
    local int i;
    local string rem;
    //local float y,p,r;
    local string delim;

    delim = " ";

	rem = GetArgVal(rotName);
	if(rem != "")
	{
        if( InStr(rem,delim) == -1 )
        	delim = ",";
        i = InStr(rem,delim);
        rot.Pitch = float(left(rem,i));
        rem = mid(rem,i+1);
        i = InStr(rem,delim);
        rot.Yaw = float(left(rem,i));
        rot.Roll = float(mid(rem,i+1));
	}
	else
	{
		rot.Pitch = float( GetArgVal("pitch") );
		rot.Yaw = float( GetArgVal("yaw") );
		rot.Roll = float( GetArgVal("roll") );
	}
}

//Send a line to the client
function SendLine(string Text, optional bool bNoCRLF)
{
	if(bDebug)
		`log("    Sending: "$Text);
	if(bNoCRLF)
		SendText(Text);
	else
		SendText(Text$Chr(13)$Chr(10));
}

//When we need to tell something to all
function GlobalSendLine(string Text, bool bNotifyAllControlServers, bool bNotifyAllBots, optional bool bNoCRLF)
{

}

//sends NFO message
function SendGameInfo()
{
	local string gameInfoStr, WorldInfoName, PauseResult;
	local int i;

	//gameInfoStr = BotDeathMatch(WorldInfo.Game).GetGameInfo();
	WorldInfoName = string(WorldInfo);
	i = InStr(Caps(WorldInfoName), ".WorldInfoINFO");

	if(i != -1)
		WorldInfoName = Left(WorldInfoName, i);

	if (WorldInfo.Pauser != None)
		PauseResult = "True";
	else
		PauseResult = "False";

	SendLine("NFO {Gametype " $ BotDeathMatch(WorldInfo.Game).GameClass $
		//"} {WeaponStay " $ WorldInfo.Game.bWeaponStay $
		"} {GamePaused " $ PauseResult $
		"} {BotsPaused " $ WorldInfo.bPlayersOnly $
		"} {Level " $ WorldInfo.GetMapName(true) $
		"}" $ gameInfoStr);   //last part may differ according to the game type
}

//Sends list of all mutators on the server (MUT batch info mess.)
function ExportMutators()
{
	local Mutator M;

	SendLine("SMUT");
	/*
	for (M = BotDeathMatch(Level.Game).BaseMutator; M != None; M = M.NextMutator)
	{
		SendLine("MUT {Id " $ M $
			"} {Name " $ M.Name $
			"}");
	}
	*/
	SendLine("EMUT");

}

//Exports all navpoints in a level also with their reachable graph
function ExportNavPoints()
{
	local string message, item, itemClass, flag;
	local NavigationPoint N;
	local int i,j,PathListLength;

	SendLine("SNAV");

	foreach WorldInfo.AllNavigationPoints(class'NavigationPoint', N)
	{
		item = "None";
		itemClass = "None";
		flag = "PathNode";
		if (N.IsA('PickupFactory'))
		{
			flag = "InventorySpot";
			item = string(PickupFactory(N).InventoryType);
			itemClass = string(PickupFactory(N).InventoryType);
		}

		if (N.IsA('PlayerStart'))
		{
			flag = "PlayerStart";
		}

		message = "NAV {Id " $ N $
			"} {Location " $ N.Location $
			"} {Visible false} {Reachable false}";
		if (item != "None")
		{
			message = message $ " {Item " $ item $
			"} {ItemClass " $ itemClass $ "}";
		}

/*
		if (N.IsA('AIMarker') && AIMarker(N).markedScript.IsA('UnrealScriptedSequence'))
		{

			flag = "AIMarker";

			message = message $ " {Rotation " $ UnrealScriptedSequence(AIMarker(N).markedScript).Rotation $
					"} {RoamingSpot " $ UnrealScriptedSequence(AIMarker(N).markedScript).bRoamingScript $
					"} {SnipingSpot " $ UnrealScriptedSequence(AIMarker(N).markedScript).bSniping $
					"} {PreferedWeapon " $ UnrealScriptedSequence(AIMarker(N).markedScript).WeaponPreference $
					"}";

		}*/

		message = message $" {Flag " $ flag $ "}";
		SendLine(message);

		i = 0;
		PathListLength = N.PathList.Length;
		SendLine("SNGP");
		while (i < PathListLength)
		{
			message = "INGP {Id " $ string(N.PathList[i].End.Nav) $
				"} {Flags " $ N.PathList[i].reachFlags $
				"} {CollisionR " $ N.PathList[i].CollisionRadius $
				"} {CollisionH " $ N.PathList[i].CollisionHeight $
				"}";
/*
			if (N.PathList[i].End.Nav.IsA('JumpDest'))
			{
				message = message $" {ForceDoubleJump " $ JumpDest(N.PathList[i].End.Nav).bForceDoubleJump $
					"}" ;
				for (j = 0; j < JumpDest(N.PathList[i].End.Nav).NumUpstreamPaths; j++)
				{
					//message = message $ " {Path"$j$" "$ JumpDest(N.PathList[i].End.Nav).UpstreamPaths[j].Start $"}";

					//Searching the record which refers to the path we are now exporting
					if (JumpDest(N.PathList[i].End.Nav).UpstreamPaths[j].Start == N)
					{
						message = message $ " {CalculatedGravityZ " $ JumpDest(N.PathList[i].End.Nav).CalculatedGravityZ[j] $
							"} {NeededJump " $ JumpDest(N.PathList[i].End.Nav).NeededJump[j] $
							"}";
					}
				}

			}
*/
			//Jump spot is a child of jump dest
			/*
			if (N.PathList[i].End.Nav.IsA('JumpSpot'))
				message = message $ " {NeverImpactJump " $ JumpSpot(N.PathList[i].End.Nav).bNeverImpactJump $
					"} {NoLowGrav " $ JumpSpot(N.PathList[i].End.Nav).bNoLowGrav $
					"} {OnlyTranslocator " $ JumpSpot(N.PathList[i].End.Nav).bOnlyTranslocator $
					"} {TranslocTargetTag " $ JumpSpot(N.PathList[i].End.Nav).TranslocTargetTag $
					"} {TranslocZOffset " $ JumpSpot(N.PathList[i].End.Nav).TranslocZOffset $
					"}";*/

			SendLine(message);
			i++;
		}
		SendLine("ENGP");

	}
	SendLine("ENAV");

}

function ExportInventory()
{
	local PickupFactory Pickup;

	SendLine("SINV");

	foreach DynamicActors(class'PickupFactory',Pickup)
	{

		SendLine("INV {Id " $ GetUniqueId(Pickup) $
			"} {Location " $ Pickup.Location $
			//"} {Amount " $ GetItemAmount(Pickup) $
			//"} {Dropped " $ Pickup.bDropped $
			"} {Type " $ Pickup.Class $
			"} {Visible false} {Reachable false}");
	}

	SendLine("EINV");

}

//Exports all players in the level
function ExportPlayers(optional bool bLimitedInfo)
{
	local Controller C;
	local string message, TeamIndex, WeaponClass;

	foreach WorldInfo.AllControllers(class'Controller', C)
	{
		if (C.PlayerReplicationInfo.Team != none)
			TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
		else
    		TeamIndex = "255";

		if ((C.Pawn != none) && (C.Pawn.Weapon != none))
			WeaponClass = string(C.Pawn.Weapon.Class);
		else
			WeaponClass = "None";

		message = "PLR {Id " $ GetUniqueId(C) $
			"} {Name " $ C.PlayerReplicationInfo.PlayerName $
			"} {Team " $ TeamIndex $
			"} {Visible True}";

		if (!bLimitedInfo)
		{
			if (C.IsA('RemoteBot'))
	            message = message $ " {Jmx " $ RemoteBot(C).jmx $ "}";

			if (C.Pawn != none)
				message = message$" {Location " $ C.Pawn.Location $
					"} {Rotation " $ C.Pawn.Rotation $
					"} {Velocity " $ C.Pawn.Velocity $
					"} {Weapon " $ WeaponClass $
					"}";
			else
				message = message$" {Location " $ C.Location $
					"} {Rotation " $ C.Rotation $
					"} {Velocity " $ C.Velocity $
					"}";

		}
		SendLine(message);
		

	}
}

//TODO: implement this
function ExportItemClasses() 
{
	SendLine("SITC");
	SendLine("EITC");
}


//Here the unique IDs are created from objects in UT
function string GetUniqueId(Actor inputActor)
{
	if (inputActor == none)
		return "None";

	if (inputActor.IsA('Controller'))
	{
		if (Controller(inputActor).PlayerReplicationInfo != none)
		{
			return inputActor $ Controller(inputActor).PlayerReplicationInfo.PlayerID;
		}
	}
	return string(inputActor);
}

defaultproperties
{

}
