/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


//=============================================================================
// DeathMatchPlus.
//=============================================================================
class BotDeathMatch extends UTDeathMatch
	config(GameBots2007);


var BotServer		theBotServer;
var bool		bServerLoaded, bBoolResult;
var int			NumRemoteBots;
var string GameClass;

var string RemoteBotController;

var string BotServerClass;

//this is ID counter that is used for objects in UnrealScript that doesn't have
//exportable unique ID - (dropped weapons, vehicles or projectiles)
var int GameBotsID;

var config int BotServerPort;
var config int ControlServerPort;

//enables vehicles in the game
var config bool bVehiclesEnabled;

//if set to true all weapons from map will be erased
var bool bShouldEraseAllWeapons;

//here we store if our connections to bot and cotrol server are protected by pass
//will force a bit changed initial protocol (to check password)
var bool bPasswordProtected;

//here we store Password for bot and control connections
var string Password;

//who initiated the password protection
var string PasswordByIP;

// This class is used for pausing the game. We supply it to WorldInfo.Pauser variable.
var PauserFeed WorldInfoPauserFeed;
//Here we store all available maps
var array<string> Maps;

//this function is called even before PreBeginPlay, we parse GB parameters from
//command line here
event InitGame(string Options, out string Error )
{
	local string InOpt;
	local Mutator M;
	local bool bFound;

	super.InitGame(Options, Error);

/*
	bFound = false;
	//Make sure the GBHUDMutator is on!
	for (M = BaseMutator; M != None; M = M.NextMutator)
	{
    	if (M.IsA('GBHudMutator'))
    	{
    		bFound = true;
			break;
		}
	} 
	
	if (!bFound)
		AddMutator("GameBots2004.GBHudMutator");
*/
	BotServerPort = Clamp(GetIntOption( Options, "BotServerPort", BotServerPort ),2000,32000);
	ControlServerPort = Clamp(GetIntOption( Options, "ControlServerPort", ControlServerPort ),2000,32000);


	InOpt = ParseOption( Options, "Password");
	if (InOpt != "")
	{
	    bPasswordProtected = true;
	    PasswordByIP = WorldInfo.GetAddressURL();
	    Password = InOpt;
	}
	else
	{
		bPasswordProtected = false;
	}

}

//This function is automaticaly called after beginning of the game
function PostBeginPlay()
{
	local GameInfo FoundGameInfo; //for vehicle support

	Super.PostBeginPlay();

	if(!bServerLoaded)
    {

		theBotServer = Spawn(class<BotServer>(DynamicLoadObject(BotServerClass, class'Class')),self);

		bServerLoaded = true;
	}
	else
	{

		theBotServer.bClosed = false;
		theBotServer.Listen();

	}

	//HACK? Set to true, so the match will start imediatelly
	//We should implement support for StartMatch function...
    bQuickStart = true;


    GameBotsID = 0;
	WorldInfoPauserFeed = Spawn(class'PauserFeed');

	//RemoteBotConfig.Difficulty = AdjustedDifficulty;

	//`log("GB server on.");
	//`log("ControlServerPort:"$theControlServer.ListenPort$" BotServerPort:"$theBotServer.ListenPort);


}

//This function returns text information about game
function string GetGameInfo()
{
	local string outStr;

	outStr = " {FragLimit " $ GoalScore $
		"} {TimeLimit " $ TimeLimit $ "}";

	return outStr;
}

//Returns game status - list of players and their score
function SendGameStatus(GBClientClass requester)
{

	local Controller C;

	foreach WorldInfo.AllControllers(class'Controller', C)
	{
		if( (C.IsA('RemoteBot')) && !C.IsA('Spectator') )
		{
			requester.SendLine("PLS {Id " $ requester.GetUniqueId(C) $
				"} {Score " $ int(C.PlayerReplicationInfo.Score) $
				"} {Deaths " $ int(C.PlayerReplicationInfo.Deaths) $
				"}");
		}
	}
}

function LoadMapsFromPreFix(string Prefix)
{
}

//Used for restarting our RemoteBots
function RemoteRestartPlayer( Controller aPlayer, optional vector startLocation, optional rotator startRotation )
{
	//`log("We are in RemoteRestartPlayer");

	SpawnPawn( RemoteBot(aPlayer), startLocation, startRotation);

}


//Main function for adding bot to the game (creates also controller)
function RemoteBot AddRemoteBot
(
	BotConnection theConnection,
	string clientName,
	int TeamNum,
	optional string className,
	optional string DesiredSkin,
	optional float DesiredSkill,
	optional bool ShouldLeadTarget
)
{
	local RemoteBot NewBot;

	//I dont think location here is necessary. Its just controller class
	NewBot = Spawn(class<RemoteBot>(DynamicLoadObject(RemoteBotController, class'Class')),self);

	if ( NewBot == None )
	{
		////`log("In AddRemoteBot() - Cant spawn RemoteBot ");
		return None;
	}


	//hook up connection to socket
	NewBot.myConnection = theConnection;

	NewBot.bIsPlayer = true;

	// Set the player's ID.
	NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;


	//Increase numbers properly, so no epic bot will join the game
	NumRemoteBots++;
	NumPlayers++;

	if ( clientName != "" )
	{
		NewBot.PlayerReplicationInfo.PlayerName = clientName;
		changeName( newBot, clientName, true );
	}

	if (!AddRemoteBotToTeam(NewBot,TeamNum))
	{
		//`log("In AddRemoteBot() - In Team Game Bot without team!");
		//NewBot.Destroy();
		//return None;
	}

	//Turns on strafing ability
	Newbot.StrafingAbility = 1.0;
    //From 0 to 7
    if ((DesiredSkill > 0) && (DesiredSkill <= 7))
    	Newbot.Skill = DesiredSkill;
    else
		Newbot.Skill = 7;
	//Shooting ahead of targets - disabled? - aiming is thing of a client
	NewBot.bLeadTarget = ShouldLeadTarget;

	//We will let the bots know that new bots came to server
	//RemoteNotifyloging(newBot);

	return NewBot;
}

//Here we spawn and respawn the bot Pawn - thats the visible avatar of the bot
function SpawnPawn
(
	RemoteBot NewBot,
	optional vector startLocation,
	optional rotator startRotation
)
{
	local NavigationPoint startSpot;

	if (NewBot == None)
	{
    	////`log("In SpawnPawn(), - NewBot is None! ");
    	return;
	}

	if (NewBot.Pawn != None)
	{
		////`log("In SpawnPawn(), - "$NewBot$" Pawn already spawned ");
		return;
	}

	if ( StartLocation == vect(0,0,0) && StartRotation == rot(0,0,0) )
	{
		StartSpot = FindPlayerStart(NewBot);
    	newBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartSpot.Location,StartSpot.Rotation);
	}
	else
	{
		if (StartLocation != vect(0,0,0) && StartRotation != rot(0,0,0))
		{
			NewBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartLocation,StartRotation);
		}
		else
		{
			if (StartRotation != rot(0,0,0))
			{
				StartSpot = FindPlayerStart(NewBot);
				newBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartSpot.Location,StartRotation);
			}
			else  //this means StartLocation != vect(0,0,0)
			{
				newBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartLocation, );
			}
		}

	}

	if (NewBot.Pawn == None)
	{
    	////`log("In SpawnPawn() - Cant spawn the pawn of bot "$NewBot);
		return;
	}


	//For disabling automatic pickup (items picked through command PICK)
    newBot.Pawn.bCanPickupInventory = !newBot.bDisableAutoPickup;

    //Multiply Pawn GroundSpeed by our custom GB SpeedMultiplier
    newBot.Pawn.GroundSpeed = newBot.SpeedMultiplier * newBot.Pawn.Default.GroundSpeed;

	//GBxPawn(NewBot.Pawn).SetSkin(NewBot.DesiredSkin);//, NewBot.myConnection.BotSkin);
	newBot.Pawn.Controller = newBot;

	//Taken from Spawning class of Epic bots
	if (StartSpot != none) //TODO: Find here nearest NavPoint?
	{
    	//NewBot.Pawn.Anchor = startSpot;
		NewBot.Pawn.LastStartSpot = PlayerStart(startSpot);
	}
	NewBot.Pawn.LastStartTime = WorldInfo.TimeSeconds;
    //NewBot.PreviousPawnClass = NewBot.Pawn.Class;

    NewBot.Possess(NewBot.Pawn,false);
    //NewBot.PawnClass = NewBot.Pawn.Class;

    NewBot.Pawn.PlayTeleportEffect(true, true);

	//Notify spawning
	NewBot.myConnection.SendLine("SPW");

    //NewBot.ClientSetRotation(aPlayer.Pawn.Rotation); //We want to preserve our rotation
    if (!bShouldEraseAllWeapons)
    	AddDefaultInventory(NewBot.Pawn);


   	//Setting some initial Pawn properties
	//Newbot.Pawn.PeripheralVision = -0.3;
	//Newbot.Pawn.bAvoidLedges = false;
	//Newbot.Pawn.bStopAtLedges = false;
	//Newbot.Pawn.bCanJump = true;


 	// broadcast a welcome message.
	//BroadcastLocalizedMessage(GameMessageClass, 1, NewBot.PlayerReplicationInfo);

	NewBot.GotoState('StartUp', 'DoStop'); //TODO: Really here?
}

function bool AddRemoteBotToTeam(Controller NewBot, int TeamNum)
{
	return true;
}


//Prevents epic bots from automatically joining the game
function bool NeedPlayers()
{
	return false;
}

//Prevents epic bots from automatically joining the game
function bool BecomeSpectator(PlayerController P)
{
	if ( !Super.BecomeSpectator(P) )
		return false;

	return true;
}

defaultproperties
{
	NetWait=2
	CountDown=0
	bPauseable=True
	RemoteBotController="GameBots2007.RemoteBot"
	BotServerClass="GameBots2007.BotServer"
	GameName="GameBots07 DeathMatch"
	GameClass="BotDeathMatch"
	Acronym="DM"
	MapPrefix="DM"
	BotServerPort=3000
	ControlServerPort=3001
}
