/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/

//=============================================================================
// BotConnection.
// Based connection class
//=============================================================================
class BotConnection extends GBClientClass;

//------------Variables---------------------------

// delay between visionUpdates
var config float visionTime;

// on / off all synchronous messages
var config bool bSynchronousMessagesOff;

var RemoteBot theBot;

var Actor tempActor;

//------------Events---------------------------

// triggered when a socket connection with the server is established
event Accepted()
{
	if(bDebug)
		`log("Accepted BotConnection" @ self);

  visionTime = 0.25;
  
	SendLine("HELLO_BOT");


	if (BotDeathMatch(WorldInfo.Game).bPasswordProtected)
		gotoState('checkingPassword','Waiting');
	else
		gotoState('waiting','Waiting');
}
event Closed()
{
	Destroyed();
	Destroy();
}

event Destroyed()
{
	if ( theBot != None && theBot.Pawn != None )
	{
		theBot.SetLocation(theBot.Pawn.Location);
		theBot.Pawn.RemoteRole = ROLE_SimulatedProxy;
		theBot.Pawn.UnPossessed();
		theBot.Pawn.Destroy();
	}

	if (theBot != None)
	{
		theBot.Destroy();
	}
/*
	if (FocusActor != None)
	{
		FocusActor.Destroy();
	}
*/
}


//------------Functions---------------------------

//Init recieved from client
function InitBot()
{
	local string clientName, className, temp, DesiredSkin, outstring;
	local int teamNum;
	local vector StartLocation;
	local rotator StartRotation;
	local float DesiredSkill, DesiredAccuracy;
	local bool ShouldLeadTarget;

	clientName = GetArgVal("Name");

	DesiredSkin = GetArgVal("Skin");

	className = GetArgVal("ClassName");

	temp = GetArgVal("Team");
	if( temp != "" )
		teamNum = int(temp);
	else
		teamNum = 255;

	temp = GetArgVal("DesiredSkill");
	if (temp != "")
		DesiredSkill = float(temp);
	else
		DesiredSkill = -1; //that means deufault value will be used

	temp = GetArgVal("ShouldLeadTarget");
	if (temp != "")
		ShouldLeadTarget = bool(temp);
	else
		ShouldLeadTarget = false;

	// add the bot into the game
	theBot = BotDeathMatch(WorldInfo.Game).AddRemoteBot(
		self,
		clientName,
		teamNum,
		className,
		DesiredSkin,
		DesiredSkill,
		ShouldLeadTarget
	);

	//Here the spawning of the pawn is handled - after weve got controler created
	if(theBot != None)
	{
		if (GetArgVal("ManualSpawn")!="")
			theBot.bAutoSpawn = !bool(GetArgVal("ManualSpawn"));

		if (GetArgVal("AutoPickupOff") != "")
			theBot.bDisableAutoPickup = bool(GetArgVal("AutoPickupOff"));

		theBot.jmx = GetArgVal("Jmx");

		if (GetArgVal("AutoTrace")!="")
			theBot.bAutoTrace = bool(GetArgVal("AutoTrace"));


		if ( GetArgVal("Location")!="" )
		{
        	ParseVector(StartLocation,"Location");

        	if ( GetArgVal("Rotation")!="" )
			{
				ParseRot(StartRotation,"Rotation");
				BotDeathMatch(WorldInfo.Game).SpawnPawn(theBot,StartLocation,StartRotation);
			}
			else
			{
				BotDeathMatch(WorldInfo.Game).SpawnPawn(theBot,StartLocation, );
			}
		}
		else
		{
			if ( GetArgVal("Rotation")!="" )
			{
				ParseRot(StartRotation,"Rotation");
				BotDeathMatch(WorldInfo.Game).SpawnPawn(theBot, ,StartRotation);
			}
		}

		if (theBot.Pawn != none)
			theBot.GotoState('StartUp', 'Begin');
		else
			theBot.GotoState('Dead', 'Begin');

		gotoState('monitoring','Running');
	}
	else
	{
		if (bDebug)
			`log("In InitReceived() - Error adding bot");
	}

}

//Main function for processing commands
function ProcessAction(string cmdType)
{
	if(bDebug)
		`log("comandType:"@cmdType);

	switch(cmdType)
	{
		case "CMOVE":
			ReceivedCMove();
		break;
		case "INIT":
			InitBot();
		break;
		case "GETPATH":
			ReceivedGetPath();
		break;
		case "JUMP":
			ReceivedJump();
		break;
		case "MESSAGE":
			ReceivedMessage();
		break;
		case "MOVE":
			ReceivedMove();
		break;
		case "PING":
			SendLine("Pong");
		break;
		case "QUIT":
			Closed();
		break;
		case "READY":
			ReceivedReady();
		break;		
		case "ROTATE":
			ReceivedRotate();
		break;
		case "SETCROUCH":
			ReceivedSetCrouch();
		break;
		case "SETWALK":
			ReceivedSetWalk();
		break;
		case "SHOOT":
			ReceivedShoot();
		break;
		case "STOP":
			ReceivedStop();
		break;
		case "STOPSHOOT":
			ReceivedStopShoot();
		break;
		case "TURNTO":
			ReceivedTurnTo();
		break;
	}//end switch
}


function ReceivedCMove()
{

	local rotator yawRotation;

	if (theBot == None || theBot.Pawn == None)
		return;

	//We need to reset focus, otherwise the focus would reset focal point to its own location
	theBot.Focus = None;
	theBot.myFocus = None;

	yawRotation.Yaw = theBot.Pawn.Rotation.Yaw;
    theBot.myFocalPoint = theBot.Pawn.Location + 500 * vector(yawRotation);
	theBot.GotoState('StartUp','MoveContinuous');
}

function ReceivedGetPath()
{
	local vector v;
	local string id;
	local int i;

	if ( theBot == None )
		return;

	//clear the old path
	for ( i=0; i<16; i++ )
	{
		if ( theBot.RouteCache[i] == None )
			break;
		else
		{
			theBot.RouteCache[i] = None;
		}
	}

	ParseVector(v,"Location");
	theBot.FindPathTo(v);
	id = GetArgVal("Id");

	SendLine("SPTH {MessageId " $ id $ "}");
	for ( i=0; i<16; i++ )
	{
		if ( theBot.RouteCache[i] == None )
			break;
		else
		{
			SendLine("IPTH {RouteId " $ theBot.RouteCache[i] $"}");
		}
	}
	SendLine("EPTH");
}

function ReceivedJump()
{
	local string tmp;
	local bool bDouble;

	if (theBot == None || theBot.Pawn == None)
		return;

	bDouble = false;
	tmp = GetArgVal("DoubleJump");
	if (tmp != "")
		bDouble = bool(tmp);

	theBot.RemoteJump(bDouble);

}

function ReceivedMessage()
{
	local string target, text;
	local bool boolResult;
	local float FadeOut;

	if (theBot == None )
		return;

	//Note - currently only allow messages under 256 chars
	target = GetArgVal("Id");
	text = GetArgVal("Text");
	boolResult = bool(GetArgVal("Global"));
	FadeOut = float(GetArgVal("FadeOut"));
	if(text != "")
	{
		theBot.RemoteBroadcast(target,text,boolResult,FadeOut);
	}

}

function ReceivedMove()
{
	local vector v,v2,focusLoc;
	local string focusId;
	local Actor tmpFocus;
	local Controller C;

	if (theBot == None || theBot.Pawn == None)
		return;

	//if first location not specified, we wont move
	if (GetArgVal("FirstLocation")=="")
		return;

	ParseVector(v,"FirstLocation");
	focusId = GetArgVal("FocusTarget");

	//set the destinations we want to traverse
	theBot.myDestination = v;
	theBot.Destination = v;
	if (GetArgVal("SecondLocation")!="")
	{
		ParseVector(v2,"SecondLocation");
		theBot.pendingDestination = v2;
	}
	else
	{
		theBot.pendingDestination = v;
	}

	if(focusId == "")
	{
		if (GetArgVal("FocusLocation")!="")
		{
			ParseVector(focusLoc,"FocusLocation");
			//Cant focus to location, but can to actor, we set position of our helper actor to desired
	        //FocusActor.SetLocation(focusLoc);
	        //Lets se the bots focus to our helper actor
			//theBot.Focus = FocusActor;
			//theBot.myFocus = FocusActor;
			//Set FocalPoint accordingly (it would change to desired values anyway)
			//theBot.myFocalPoint = FocusActor.Location;
			//theBot.FocalPoint = FocusActor.Location;
		}
		else
		{
			//we reset old focus, if none focus set, the bot will turn towards destination
			theBot.Focus = none;
			theBot.myFocus = none;
			//todo: reset also target?

			//set myFocalPoint to prevent unwanted turning back at the end of movement
			//myFocalPoint will be set at the end of movement
			if (GetArgVal("SecondLocation")!="")
				theBot.myFocalPoint = v2 + 500 * vector(rotator(v2 - v));
			else
				theBot.myFocalPoint = v + 500 * vector(rotator(v - theBot.Pawn.Location));
		}
	}
	else //We have Id of the object we want to face
	{
		//First we determine if it is a bot id
		tmpFocus = None;
	foreach WorldInfo.AllControllers(class'Controller', C)
	{
			if( (C$C.PlayerReplicationInfo.PlayerID) == focusId)
			{
				if( theBot.Pawn.LineOfSightTo(C.Pawn))
				{
					tmpFocus = C.Pawn;
					break;
				}
			}
		}
		//we found it is a bot id, lets set it as our focus
		if (tmpFocus != none)
		{
			//point the bot at the location of the target
			theBot.FocalPoint = tmpFocus.Location;
			theBot.myFocalPoint = tmpFocus.Location;
			theBot.Focus = tmpFocus;
			theBot.myFocus = tmpFocus;
			theBot.Target = tmpFocus;
		}
		else // it was not a bot id
		{
			//lets try if there is an object with this id
			//can be navpoint or some of the items have unique id
			//setPropertyText("tempActor", focusId);
			//if succes, then set this object as our focus object
			if ((tempActor != none) && theBot.Pawn.LineOfSightTo(tempActor))
			{
				theBot.myFocus = tempActor;
				theBot.Focus = tempActor;
				theBot.myFocalPoint = tempActor.Location;
				theBot.FocalPoint = tempActor.Location;
			}
		}
	}
	theBot.GotoState('StartUp','Move');
}

function ReceivedReady()
{

	if (IsInState('waiting')) 
	{
		//Methods defined in super class
		SendGameInfo(); //NFO message
		ExportMutators(); //SMUT, MUT, EMUT messages
		ExportItemClasses(); //SITC, ITC, EITC messages
		ExportNavPoints(); //SNAV, NAV, ENAV messages
		ExportInventory(); //SINV, IINV, EINV messages
		SendLine("SPLR");
		ExportPlayers(true); //true for limited info, PLR messages
		SendLine("EPLR");
	}

}

function ReceivedRotate()
{
	local string target;
	local rotator r;
	local int i;

	if (theBot.Pawn == None)
		return;

	target = GetArgVal("Axis");
	r = theBot.Rotation;
	i = int(GetArgVal("Amount"));
	if(target == "Vertical")
	{
		//r.Pitch = int(theBot.Pawn.ViewPitch) * 65556/255 + i;
		//r.Yaw = theBot.Pawn.Rotation.Yaw;
	}
	else
	{
		//r.Pitch = int(theBot.Pawn.ViewPitch) * 65556/255;
		r.Yaw += i;
	}

	theBot.myFocalPoint = theBot.Pawn.Location + ( vector(r) * 500);
	theBot.FocalPoint = theBot.myFocalPoint;
	theBot.myFocus = None;
	theBot.Focus = None; //theBot.Pawn.Location + ( vector(r) * 1000);

    if (theBot.movingContinuous)
		theBot.GotoState('StartUp','MoveContinuous');

	//We comment this so turning commands do not interupt moving commands.
	//theBot.StopWaiting();
	//theBot.GotoState('Startup', 'Turning');

}

function ReceivedSetCrouch()
{
	local string target;

	if (theBot == None || theBot.Pawn == None)
		return;

	target = GetArgVal("Crouch");
	
	theBot.Pawn.ShouldCrouch( bool(target) );

}

function ReceivedSetWalk()
{

	local string target;

	if (theBot == None || theBot.Pawn == None)
		return;

	target = GetArgVal("Walk");
	
	theBot.Pawn.bIsWalking = bool(target);

}

function ReceivedShoot()
{
	local rotator r;
	local string Target;
	local Controller C;
	local vector v;
	local bool targetLocked;

	if (theBot == None || theBot.Pawn == None)
		return;

	targetLocked = false;
	theBot.bTargetLocationLocked = false;
	Target = GetArgVal("Target");
	if( Target != "")
	{
	foreach WorldInfo.AllControllers(class'Controller', C)
	{
			//We wont start shooting at non visible targets
			if( ((C $ C.PlayerReplicationInfo.PlayerID) == target) &&
				(C.Pawn != None) &&
				(theBot.LineOfSightTo(C.Pawn))
			)
			{
				//We will set desired bot as our enemy
				theBot.Focus = C.Pawn;
				theBot.myFocus = C.Pawn;
				theBot.Enemy = C.Pawn;
				theBot.RemoteEnemy = C;
				theBot.Target = C.Pawn;

				theBot.FocalPoint = C.Pawn.Location;
				theBot.myFocalPoint = C.Pawn.Location;
				targetLocked = true;
				break;
			}
		}
	}

	if (!targetLocked && GetArgVal("Location") != "")
	{
		ParseVector(v,"Location");

		theBot.myTarget.SetLocation(v);
		theBot.bTargetLocationLocked = true;

		//We are shooting at a location. We will set the FocalPoint
		theBot.FocalPoint = theBot.myTarget.Location;
		theBot.myFocalPoint = theBot.myTarget.Location;

		theBot.Focus = theBot.myTarget;
		theBot.Enemy = None;
		theBot.Target = theBot.myTarget;
	}

	theBot.RemoteFireWeapon(bool(GetArgVal("Alt")));
}


function ReceivedStop()
{
	if (theBot == None || theBot.Pawn == None)
		return;

	theBot.GotoState('Startup', 'DoStop');
}

function ReceivedStopRec()
{
	ConsoleCommand("stopdemo", True);
	SendLine("RECEND");
}

function ReceivedStopShoot()
{
	if (theBot == None)
		return;

	theBot.HaltFiring();
}


function ReceivedTurnTo()
{
	local Controller C;
	local vector v;
	local rotator r;
	local string target;

	if (theBot == none || theBot.Pawn == None)
		return;

	target = GetArgVal("Target");
	if(target == "")
	{
		ParseRot(r,"Rotation");
		if(r.Yaw == 0 && r.Pitch == 0 && r.Roll == 0)
		{
			//no target or rotation defined
			ParseVector(v,"Location");
			theBot.FocalPoint = v;
			theBot.myFocalPoint = v;
			//We erase possible focus actors
			theBot.myFocus = None;
			theBot.Focus = None;

			if (theBot.movingContinuous)
				theBot.GotoState('StartUp','MoveContinuous');
		}
		else
		{
			//no target, yes rotation
			theBot.myFocalPoint = theBot.Pawn.Location + ( vector(r) * 500);
			theBot.FocalPoint = theBot.myFocalPoint;

			//We erase possible focus actors
			theBot.myFocus = None;
			theBot.Focus = None;

			if (theBot.movingContinuous)
				theBot.GotoState('StartUp','MoveContinuous');
		}
	}
	else
	{
		//target defined

		//First we try to find if we should focus to a player or bot
	foreach WorldInfo.AllControllers(class'Controller', C)
	{
			if( target == (C $ C.PlayerReplicationInfo.PlayerID) )
			{
				break;
			}
		}//end for
		if (C != None)
		{
			//Pawn must exists and must be visible
			if ((C.Pawn != None) && theBot.Pawn.LineOfSightTo(C.Pawn))
			{
				//We set the Controller as our target
				theBot.FocalPoint = C.Pawn.Location;
				theBot.myFocalPoint = C.Pawn.Location;
				theBot.Focus = C.Pawn;
				theBot.myFocus = C.Pawn;

				if (theBot.movingContinuous)
					theBot.GotoState('StartUp','MoveContinuous');

			}
			else
			{
				return;
			}
		}
		else
		{
			tempActor = None;
			//SetPropertyText("tempActor",target);
			//Actor must be visible
			if ((tempActor != None) && theBot.Pawn.LineOfSightTo(tempActor))
			{
				theBot.myFocus = tempActor;
				theBot.Focus = tempActor;
				theBot.myFocalPoint = tempActor.Location;
				theBot.FocalPoint = theBot.myFocalPoint;

				if (theBot.movingContinuous)
					theBot.GotoState('StartUp','MoveContinuous');
			}
			else
			{
				return;
			}
		}
	}
	//We comment this so turning commands do not interupt moving commands.
	//theBot.StopWaiting();
	//theBot.GotoState('Startup', 'Turning');

}

//----------------- STATES

//Waiting state when connected
auto state waiting
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';

}

state checkingPassword
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';
}

state monitoring
{

Begin:
Running:
	if (bSynchronousMessagesOff)
		goto 'SynchronousOff';
	if((theBot != none) && !theBot.IsInState('Dead') && !theBot.IsInState('GameEnded') )
	{
		//This is where synchronous batch messages are sent
		SendLine("BEG {Time " $ WorldInfo.TimeSeconds $"}");

		//`log("Measuring Time of synchronous batch: ");
		//StopWatch(false);

       // ExportGameStatus();
		theBot.checkSelf();
		theBot.checkVision();


		//StopWatch(true);


		SendLine("END {Time " $ WorldInfo.TimeSeconds $"}");
	}
	//theBot.bDebug = true;
	if (theBot.bDebug && !theBot.IsInState('StartUp'))
		`log(theBot.getStateName());
	sleep(visionTime);
	goto 'Running';
SynchronousOff:
	if (!bSynchronousMessagesOff)
		goto 'Running';
	sleep(1);
	goto 'SynchronousOff';
}


