class CaveUTMut extends Mutator
  notplaceable;

var bool bHasInteraction;

function ModifyLogin(out string Portal, out string Options) {
  Level.Game.PlayerControllerClassName = "CaveUT.Spectator";
  log("Loading");
  Level.Game.PlayerControllerClass =
    Class<PlayerController>(DynamicLoadObject(Level.Game.PlayerControllerClassName, Class'Class'));

  Super.ModifyLogin(Portal, Options);
}

function Class<Weapon> GetDefaultWeapon() {
  return None;
}


simulated function Tick(float DeltaTime)
{
    local PlayerController PC;

    // If the player has an interaction already, exit function.
    if (bHasInteraction) {
      Return;
    }

    PC = Level.GetLocalPlayerController();

    if(PC == None) {
      Return;
    }

    // Run a check to see whether this mutator should create an interaction for the player
    PC.Player.InteractionMaster.AddInteraction("CaveUT.CaveUTInteraction", PC.Player); // Create the interaction
    bHasInteraction = True; // Set the variable so this lot isn't called again
    log("CaveUT: Interaction Added");


    // hide all of the HUD display, but leave the code intact since we play nice that way
//    if((!PC.IsA('AVCRxPlayer')) && (PC.myHUD.bCrosshairShow) )
  //    PC.ToggleScreenShotMode(); // (also hides the weapon)

    Disable('Tick');

}

function ModifyPlayer(Pawn Other)
{
  if(Other.Weapon != None) {
    Other.Weapon.Destroy();
    Other.Weapon = None;
  }
  Super.ModifyPlayer(Other);
}

function string GetInventoryClassOverride(string InventoryClassName)
{
  return "";
}

defaultproperties
{
     FriendlyName="CaveUT"
     Description="Multiple screen Unreal Tournament 2003"
     bAlwaysRelevant=True
     RemoteRole=ROLE_SimulatedProxy
}
