//We've got this class here to allow specators to go through walls
class AVCRxPlayer extends xPlayer;

//var NameMarker pickup;
var ScriptedTexture Tex;
var bool bExperimentOn;
var float my_timer;

var input byte bExperiment;

var int ClientExperimentState;
var int ServerExperimentState;

var bool ClientbSecondStage;
var bool ClientbSecondVariation;
var float ClientMarkHeight;
var int ClientExperimentCount;

var array<vector> PlayerPosList;


replication
{
    // Functions server can call.
    reliable if( Role==ROLE_Authority )
		ClientExperimentState, ClientbSecondStage, ClientExperimentCount, ClientMarkHeight, ClientbSecondVariation;
	// Functions client can call.
	reliable if ( Role<ROLE_Authority )
		NotifyServer, SecondStage, SecondVariation, SpeedIncreased, SpeedDecreased,
		MarkHeightIncreased, MarkHeightDecreased, bExperimentOn;
}


simulated function NotifyClient()
{
	if (AVCR_Experiment(Level.Game).IsInState('ExperimentStart'))
		ClientExperimentState = 1;
	if (bExperimentOn)
		ClientExperimentState = 2;
	if (AVCR_Experiment(Level.Game).IsInState('ExperimentEnd'))
		ClientExperimentState = 3;

	ClientbSecondStage = AVCR_Experiment(Level.Game).bSecondStage;
	ClientbSecondVariation = AVCR_Experiment(Level.Game).bSecondVariation;
	ClientMarkHeight = AVCR_Experiment(Level.Game).MarkHeight;
	ClientExperimentCount = AVCR_Experiment(Level.Game).ExperimentCount;

}

function SecondStage()
{
	//log("In SecondStage");
	if (!AVCR_Experiment(Level.Game).IsInState('ExperimentStart') && !AVCR_Experiment(Level.Game).IsInState('ExperimentRunning'))
	{

		AVCR_Experiment(Level.Game).bSecondStage = !AVCR_Experiment(Level.Game).bSecondStage;
		AVCR_Experiment(Level.Game).ExperimentCount = 1;
		if (AVCR_Experiment(Level.Game).bSecondStage)
			ClientMessage("Switching to SECOND STAGE");
		else
			ClientMessage("Switching to FIRST STAGE");
	}
	else
		ClientMessage("Cannot change stage during experiment!");
	NotifyClient();

}

function SecondVariation()
{
	if (!AVCR_Experiment(Level.Game).IsInState('ExperimentStart') && !AVCR_Experiment(Level.Game).IsInState('ExperimentRunning'))
	{

		AVCR_Experiment(Level.Game).bSecondVariation = !AVCR_Experiment(Level.Game).bSecondVariation;
		AVCR_Experiment(Level.Game).ExperimentCount = 1;
		if (AVCR_Experiment(Level.Game).bSecondVariation)
			ClientMessage("Switching to SECOND VARIATION (goal at 130 degrees from mark)");
		else
			ClientMessage("Switching to FIRST VARIATION (goal at 15 degrees from mark)");
	}
	else
	{
		ClientMessage("Cannot change variation during experiment!");
	}
	NotifyClient();
}
	  /*
simulated function InsertPressed()
{
	bChangeBool = !bChangeBool;
	NotifyInsert();
}

function NotifyInsert()
{
	ServerbChangeBool = bChangeBool;
}    */

simulated function KeyPressed()
{
	log("We are in KeyPressed function");
	NotifyServer();
}

function NotifyServer()
{
  //Level.Game.Broadcast(self,"My state is"$GetStateName());
	//log("We are in NotifyServer");
	AVCR_Experiment(Level.Game).bExperimentKeyPressed = true;
	ServerExperimentState = 2;
	if (AVCR_Experiment(Level.Game).IsInState('ExperimentRunning'))
	{
    	AVCR_Experiment(Level.Game).gotoState('ExperimentEnd');
		ServerExperimentState = 3;
	}
	else
	{
		if (!AVCR_Experiment(Level.Game).IsInState('ExperimentStart'))
		{
			if (!AVCR_Experiment(Level.Game).bSecondStage)
			{
				AVCR_Experiment(Level.Game).gotoState('ExperimentStart','FirstStage');
				ServerExperimentState = 1;
			}
			else
			{
				AVCR_Experiment(Level.Game).gotoState('ExperimentStart','SecondStage');
				ServerExperimentState = 1;
			}
		}
	}
	NotifyClient();
}

function MarkHeightIncreased()
{
	AVCR_Experiment(Level.Game).UpdateHeight(AVCR_Experiment(Level.Game).MarkHeight + 10);
	NotifyClient();

}

function MarkHeightDecreased()
{
	AVCR_Experiment(Level.Game).UpdateHeight(AVCR_Experiment(Level.Game).MarkHeight - 10);
	NotifyClient();
}

function SpeedIncreased()
{
	//log("We are in SpeedIncreased");
	if (Pawn != none)
	{
		if (Pawn.GroundSpeed <= 1.9 * Pawn.Default.GroundSpeed)
			Pawn.GroundSpeed += 0.1 * Pawn.Default.GroundSpeed;
	}
	ClientMessage("Speed is "$Pawn.GroundSpeed);
}

function SpeedDecreased()
{
	//log("We are in SpeedDecreased");
	if (Pawn != none)
	{
		if (Pawn.GroundSpeed > 0.1 * Pawn.Default.GroundSpeed)
			Pawn.GroundSpeed -= 0.1 * Pawn.Default.GroundSpeed;
	}
	ClientMessage("Speed is "$Pawn.GroundSpeed);
}

simulated event PostBeginPlay()
{
	super.PostBeginPlay();
	my_timer = 0;
}


    /*
function Tick(float deltatime)
{
 super.Tick(deltatime);
	if ((bExperimentOn) && (Pawn != none) && (PlayerPosList.Length < 10000))
		PlayerPosList[PlayerPosList.Length] = Pawn.Location;
}   */


// Player movement.
// Player Standing, walking, running, falling.
state PlayerWalking
{
ignores SeePlayer, HearNoise, Bump;

    function bool NotifyPhysicsVolumeChange( PhysicsVolume NewVolume )
    {
        if ( NewVolume.bWaterVolume )
            GotoState(Pawn.WaterMovementState);
        return false;
    }

    function ProcessMove(float DeltaTime, vector NewAccel, eDoubleClickDir DoubleClickMove, rotator DeltaRot)
    {
        local vector OldAccel;
        local bool OldCrouch;

		if ( Pawn == None )
			return;
        OldAccel = Pawn.Acceleration;
        if ( Pawn.Acceleration != NewAccel )
			Pawn.Acceleration = NewAccel;
		if ( bDoubleJump && (bUpdating || Pawn.CanDoubleJump()) )
			Pawn.DoDoubleJump(bUpdating);
        else if ( bPressedJump )
			Pawn.DoJump(bUpdating);

        Pawn.SetViewPitch(Rotation.Pitch);

        if ( Pawn.Physics != PHYS_Falling )
        {
            OldCrouch = Pawn.bWantsToCrouch;
            if (bDuck == 0)
                Pawn.ShouldCrouch(false);
            else if ( Pawn.bCanCrouch )
                Pawn.ShouldCrouch(true);
        }
    }

    function PlayerMove( float DeltaTime )
    {
        local vector X,Y,Z, NewAccel;
        local eDoubleClickDir DoubleClickMove;
        local rotator OldRotation, ViewRotation;
        local bool  bSaveJump;

        if( Pawn == None )
        {
            GotoState('Dead'); // this was causing instant respawns in mp games
            return;
        }

        GetAxes(Pawn.Rotation,X,Y,Z);

        // Update acceleration.
        NewAccel = aForward*X + aStrafe*Y;
        NewAccel.Z = 0;
        if ( VSize(NewAccel) < 1.0 )
            NewAccel = vect(0,0,0);
        //DoubleClickMove = PlayerInput.CheckForDoubleClickMove(1.1*DeltaTime/Level.TimeDilation);

        GroundPitch = 0;
        ViewRotation = Rotation;
        if ( Pawn.Physics == PHYS_Walking )
        {
            // tell pawn about any direction changes to give it a chance to play appropriate animation
            //if walking, look up/down stairs - unless player is rotating view
             if ( (bLook == 0)
                && (((Pawn.Acceleration != Vect(0,0,0)) && bSnapToLevel) || !bKeyboardLook) )
            {
                if ( bLookUpStairs || bSnapToLevel )
                {
                    GroundPitch = FindStairRotation(deltaTime);
                    ViewRotation.Pitch = GroundPitch;
                }
                else if ( bCenterView )
                {
                    ViewRotation.Pitch = ViewRotation.Pitch & 65535;
                    if (ViewRotation.Pitch > 32768)
                        ViewRotation.Pitch -= 65536;
                    ViewRotation.Pitch = ViewRotation.Pitch * (1 - 12 * FMin(0.0833, deltaTime));
                    if ( (Abs(ViewRotation.Pitch) < 250) && (ViewRotation.Pitch < 100) )
                        ViewRotation.Pitch = -249;
                }
            }
        }
        else
        {
            if ( !bKeyboardLook && (bLook == 0) && bCenterView )
            {
                ViewRotation.Pitch = ViewRotation.Pitch & 65535;
                if (ViewRotation.Pitch > 32768)
                    ViewRotation.Pitch -= 65536;
                ViewRotation.Pitch = ViewRotation.Pitch * (1 - 12 * FMin(0.0833, deltaTime));
                if ( (Abs(ViewRotation.Pitch) < 250) && (ViewRotation.Pitch < 100) )
                    ViewRotation.Pitch = -249;
            }
        }
        Pawn.CheckBob(DeltaTime, Y);

        // Update rotation.
        SetRotation(ViewRotation);
        OldRotation = Rotation;
        UpdateRotation(DeltaTime, 1);
		bDoubleJump = false;

        if ( bPressedJump && Pawn.CannotJumpNow() )
        {
            bSaveJump = true;
            bPressedJump = false;
        }
        else
            bSaveJump = false;

        if ( Role < ROLE_Authority ) // then save this move and replicate it
            ReplicateMove(DeltaTime, NewAccel, DoubleClickMove, OldRotation - Rotation);
        else
            ProcessMove(DeltaTime, NewAccel, DoubleClickMove, OldRotation - Rotation);
        bPressedJump = bSaveJump;
    }

    function BeginState()
    {
       	DoubleClickDir = DCLICK_None;
       	bPressedJump = false;
       	GroundPitch = 0;
		if ( Pawn != None )
		{
            if ( Pawn.Mesh == None )
                Pawn.SetMesh();
            Pawn.ShouldCrouch(false);
            if (Pawn.Physics != PHYS_Falling && Pawn.Physics != PHYS_Karma) // FIXME HACK!!!
                Pawn.SetPhysics(PHYS_Walking);
		}
     }

    function EndState()
    {
        GroundPitch = 0;
        if ( Pawn != None && bDuck==0 )
            Pawn.ShouldCrouch(false);
    }

Begin:
Waiting:
	sleep(0.1);
	goto 'Waiting';
Running:
	if ((Pawn != none) && (PlayerPosList.Length < 10000))
		PlayerPosList[PlayerPosList.Length] = Pawn.Location;
	sleep(0.1);
	goto 'Running';
}

state ExperimentOn extends PlayerWalking
{
    function BeginState()
    {

     }

    function EndState()
    {

    }
Begin:
Waiting:
	sleep(0.5);
	goto 'Waiting';
Running:
	if ((Pawn != none) && (PlayerPosList.Length < 10000))
		PlayerPosList[PlayerPosList.Length] = Pawn.Location;
	sleep(0.1);
	goto 'Running';

}

defaultproperties
{
	Role = ROLE_AutonomousProxys
	PawnClass=AVCR.AVCRxPawn
 //InputClass=AVCR.AVCR_PlayerInput
}








