class CaveUTInteraction extends Interaction
        config(CaveUT)
	notplaceable;

var protected LevelInfo Level;
var private bool bPressedShift;
var private bool bPressedCtrl;
var private bool bShowDebug;

var config float RotateIncrement;
var config float OffsetIncrement;
var config float FOVIncrement;

event Initialized() {
  log("Interaction Initialized");
  Level = ViewportOwner.Actor.Level;
}

function PostRender(Canvas Canvas) {
  local vector location;
  local rotator rotation;
  local vector SizeCharacter;
  local vector LocationScreenHelp;
  local Spectator S;

  if(!bShowDebug) return;

  S = Spectator(ViewportOwner.Actor);

  Canvas.Style = 1;  // STY_Normal;
  Canvas.SetDrawColor(255,255,255,255);
  Canvas.Font = Canvas.TinyFont;
  Canvas.TextSize("X", SizeCharacter.X, SizeCharacter.Y);  

  LocationScreenHelp.X = 0;
  LocationScreenHelp.Y = 0;

  Canvas.SetPos(LocationScreenHelp.X, LocationScreenHelp.Y);

  Canvas.GetCameraLocation(location, rotation);

  Canvas.DrawText("Rotation: " $ rotation $ " Location: " $ location);

  Canvas.CurY += SizeCharacter.Y * 1.5;
  
  Canvas.DrawText(S.GetCaveRotation());

  Canvas.CurY += SizeCharacter.Y * 1.5;

  Canvas.DrawText(S.GetCaveLocation());

  Canvas.CurY += SizeCharacter.Y * 1.5;

  Canvas.DrawText(S.GetCaveFOV());
}

function bool KeyEvent(out EInputKey InputKey, out EInputAction InputAction, float Delta) {
  local Spectator S;

  S = Spectator(ViewportOwner.Actor);

  if (InputKey == IK_Shift)
    if (InputAction == IST_Press)
      bPressedShift = True;
    else if (InputAction == IST_Release)
      bPressedShift = False;

  if (InputKey == IK_Ctrl)
    if (InputAction == IST_Press)
      bPressedCtrl = True;
    else if (InputAction == IST_Release)
      bPressedCtrl = False;

  if (bPressedShift && InputAction == IST_Press) {
    switch (InputKey) {
    case IK_A: S.SetX(OffsetIncrement); break;
    case IK_S: S.SetY(OffsetIncrement); break;
    case IK_D: S.SetZ(OffsetIncrement); break;
    case IK_F: S.SetFOV(FOVIncrement); break;

    case IK_Z: S.SetPitch(RotateIncrement); break;
    case IK_X: S.SetRoll(RotateIncrement); break;
    case IK_C: S.SetYaw(RotateIncrement); break;

    case IK_H: bShowDebug = true; break;
      }
    
    return True;
    }

  if (bPressedCtrl && InputAction == IST_Press) {
    switch (InputKey) {
    case IK_A: S.SetX(-OffsetIncrement); break;
    case IK_S: S.SetY(-OffsetIncrement); break;
    case IK_D: S.SetZ(-OffsetIncrement); break;
    case IK_F: S.SetFOV(-FOVIncrement); break;

    case IK_Z: S.SetPitch(-RotateIncrement); break;
    case IK_X: S.SetRoll(-RotateIncrement); break;
    case IK_C: S.SetYaw(-RotateIncrement); break;

    case IK_H: bShowDebug = false; break;
      }
    
    return True;
    }

  return Super.KeyEvent(InputKey, InputAction, Delta);
  }

defaultproperties
{
     RotateIncrement=1.000000
     OffsetIncrement=5.000000
     FOVIncrement=5.000000
     bVisible=True
}
