class AVCR_Mutator extends Mutator;

var bool bAffectSpectators; // If this is set to true, an interaction will be created for spectators
var bool bAffectPlayers; // If this is set to true, an interaction will be created for players
var bool bHasInteraction;

function PreBeginPlay()
{
    Log("AVCR Mutator Started"); // Always comment out your logs unless they're errors
}

simulated function Tick(float DeltaTime)
{
    local PlayerController PC;

    PC = Level.GetLocalPlayerController();

    if ( PC != None && ((PC.PlayerReplicationInfo.bIsSpectator && bAffectSpectators) || (bAffectPlayers && !PC.PlayerReplicationInfo.bIsSpectator)) )
    {
        if (PC.Pawn.Weapon != none)
        {
        	PC.Pawn.Weapon.Destroy();
        	PC.Pawn.Weapon = none; //most important part is this
        }


    }

    // If the player has an interaction already, exit function.
    if (bHasInteraction)
        Return;

    // Run a check to see whether this mutator should create an interaction for the player
    if ( PC != None && ((PC.PlayerReplicationInfo.bIsSpectator && bAffectSpectators) || (bAffectPlayers && !PC.PlayerReplicationInfo.bIsSpectator)) )
    {
        PC.Player.InteractionMaster.AddInteraction("AVCR.AVCR_Interaction", PC.Player); // Create the interaction
        bHasInteraction = True; // Set the variable so this lot isn't called again
    }
}

function Mutate(string MutateString, PlayerController Sender)
{
	log("We are in mutate");
	super.Mutate(MutateString, Sender);
}

function ServerTraveling(string URL, bool bItems)
{
	bHasInteraction = false;

	super.ServerTraveling(URL,bItems);

}

DefaultProperties
{
     bAffectSpectators=true
     bAffectPlayers=true
     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=true
}
