// This is the class, where we add additional functionality to Player HUD.
// Currently we draw NavPoints names above them nad player location
class AVCR_HUD extends HudBase;

var bool bDisplayHelp;
var bool bDisplayHud;
var float shift;


function PostRender(Canvas C)
{
	local float ScreenLocX, ScreenLocY;
	local string temp;

	if (!bDisplayHud)
		return;

	ScreenLocX = 25;
	ScreenLocY = 40;
    SetFont(C);
    C.SetPos(ScreenLocX, ScreenLocY);

	if (AVCRxPlayer(PlayerOwner).ClientbSecondStage)
		temp = "AVCR Experiment SECOND STAGE.";
	else
		temp = "AVCR Experiment FIRST STAGE.";

	//if (AVCR_Experiment(PlayerOwner.Level.Game).bSecondVariation)
	if (AVCRxPlayer(PlayerOwner).ClientbSecondVariation)
		temp = temp$" Goal at 130 from mark.";
	else
		temp = temp$" Goal at 15 from mark.";

	C.DrawText(temp,true);

   	ScreenLocY += shift;
	C.SetPos(ScreenLocX, ScreenLocY);
	C.DrawText("Beeping is "$AVCRxPlayer(PlayerOwner).ClientBeeping,true);

   	ScreenLocY += shift;
	C.SetPos(ScreenLocX, ScreenLocY);
	C.DrawText("MarkHeight is "$AVCRxPlayer(PlayerOwner).ClientMarkHeight,true);

	if (PlayerOwner.Pawn != none)
	{
	   	ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("PlayerSpeed is "$PlayerOwner.Pawn.GroundSpeed,true);
	}


	ScreenLocY += shift;
	C.SetPos(ScreenLocX, ScreenLocY);

	temp = "ExperimentState: Experiment not started (press HOME to start)";
	if ( AVCRxPlayer(PlayerOwner).ClientExperimentState == 1)
		temp = "ExperimentState: EXPERIMENT "$AVCRxPlayer(PlayerOwner).ClientExperimentCount$" INITIATING!";

	if ( AVCRxPlayer(PlayerOwner).ClientExperimentState == 2 )
		temp = "ExperimentState: EXPERIMENT "$AVCRxPlayer(PlayerOwner).ClientExperimentCount$" RUNNING!";

	if ( AVCRxPlayer(PlayerOwner).ClientExperimentState == 3 )
		temp = "ExperimentState: EXPERIMENT "$AVCRxPlayer(PlayerOwner).ClientExperimentCount$" END!";

	C.DrawText(temp,true);

   	ScreenLocY += shift;
	C.SetPos(ScreenLocX, ScreenLocY);
	C.DrawText("Key G enables/disables all text here",true);

	ScreenLocY += shift;
	C.SetPos(ScreenLocX, ScreenLocY);
	C.DrawText("Key H enables/disables help ",true);

	if (bDisplayHelp)
	{
		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For experiment start, for confirming you have reached the red dot and for marking you have reached the position of the goal press the HOME key.",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For switching between experiment stages press END key.",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For switching between experiment variations (goal at 130 or 15 degrees from mark) press DELETE key",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For turning on/off beeping press INSERT key",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For speed up/speed down movement press PageUp/PageDown keys",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For increasing/decresing the height of the marks press =/- keys",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For toggling on and off displaying the green text here press G key",true);

		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		C.DrawText("For toggling on and off this help press H key",true);

	}

}

function SetFont(Canvas C)
{
	C.DrawColor = class'Canvas'.Static.MakeColor(0,155,55);


    if (C.SizeX <= 800)
	{
		shift = 15;
		C.Font = C.SmallFont;
		C.FontScaleX=1;
		C.FontScaleY=1;
	}
	else
	{
		shift = 25;
		C.Font = C.MedFont;
		C.FontScaleX=1;
		C.FontScaleY=1;
	}

}


