//=============================================================================
// AVCR experiment
//
// @author Michal Bida
// @date 02/03/2008
//=============================================================================
class AVCR_Experiment extends DeathMatch
	config(AVCR);

#exec OBJ LOAD FILE=TeamSymbols_UT2003.utx
#exec OBJ LOAD FILE=TeamSymbols.utx				// needed right now for Link symbols, etc.
#exec OBJ LOAD File=AnnouncerMain.uax
#exec OBJ LOAD File=PsuAVCR.usx

replication
{

	reliable if ( Role==ROLE_Authority )
		bSecondStage, ExperimentCount;
}

var string GameClass;
var string ExperimentStartTime;

//This is used for logging used ports for bot and control server
var FileLog Logger;
var Actor FocusActor;

var Actor Goal;
var Actor Start;
var Actor Mark0;
var Actor Mark1;
var Actor Mark2;
var Actor Mark3;
var Actor Mark4;
var Actor Mark5;

var config vector CircleLocList[8];

var config vector MarkLocList[8];
var config rotator MarkRotList[8];
var array<Actor> MarkList;

var config int MarkPositions[8];
var config int StartDotPositions[8];

var float experiment_delay;
var config float MarkHeight;

var bool bSecondStage;
var bool bSecondVariation;
var bool bExperimentKeyPressed;

var int ExperimentCount;
var config int ExperimentMaxCount;
var config int ChoosedMark;

var config bool bRandomize;

var config bool bBeeping;

var config float approachThreshold;

//helper vectors for some distance counting
var vector vect1, vect2;

var AVCRxPlayer Experimenter;


//This function is automaticaly called after beginning of the game
simulated function PostBeginPlay()
{

	Super.PostBeginPlay();
	FocusActor = spawn(class'AVCR.AVCR_FocusActor', self);
	FocusActor.SetDrawScale(0.2);
	FocusActor.bHidden = false;

	Goal = Spawn(class'AVCR.AVCR_Circle', self);
	Goal.SetRotation(rot(0, 32768, 0));

	Start = Spawn(class'AVCR.AVCR_Point', self);
	//Start = Spawn(class'BotAPI.FocusActorClass', self);
	//FocusActor.SetDrawScale(0.2);

	MarkList[0] = Spawn(class'AVCR.AVCR_MarkGreen1',self);
	MarkList[1] = Spawn(class'AVCR.AVCR_MarkGreen2',self);
	MarkList[2] = Spawn(class'AVCR.AVCR_MarkGreen3',self);
	MarkList[3] = Spawn(class'AVCR.AVCR_MarkRed1',self);
	MarkList[4] = Spawn(class'AVCR.AVCR_MarkRed2',self);
	MarkList[5] = Spawn(class'AVCR.AVCR_MarkRed3',self);

	InitVariables();

    //Test();
}

function InitVariables()
{
	local int i;

	experiment_delay = 5; //(5 seconds)
	ExperimentCount = 1;

	if (bRandomize)
	{
		//randomize Mark and star pos. here
		MarkPositions[0] = Rand(7);
 		for (i=1;i<8;i++)
		{
			MarkPositions[i] = Rand(7);
			while (MarkPositions[i]==MarkPositions[i-1])
			{
				StartDotPositions[i]=Rand(7);
			}
		}

		for (i=0;i<8;i++)
		{
			StartDotPositions[i] = Rand(7);
			while (StartDotPositions[i]==MarkPositions[i])
			{
				StartDotPositions[i]=Rand(7);
			}
		}
	}

	Log("AVCR Experiment Scenario Ready.");

	//New ones, for 03, 04
	/*
	MarkLocList[0]=vect(-364.999756,350.999939,-143);
	MarkRotList[0]=rot(0, 8192, 0);

	MarkLocList[1]=vect(-399.999756,248.000122,-143);
	MarkRotList[1]=rot(0, 16384, 0);

	MarkLocList[2]=vect(-360.000122, 143.999863,-143);
	MarkRotList[2]=rot(0, 24576,0);

	MarkLocList[3]=vect(-265.999908,108.999954,-143);
	MarkRotList[3]=rot(0, 32768, 0);

	MarkLocList[4]=vect(-171,146.999985,-143);
	MarkRotList[4]=rot(0, 40960, 0);

	MarkLocList[5]=vect(-127.000061,248.999939,-143);
	MarkRotList[5]=rot(0, 49152,0);

	MarkLocList[6]=vect(-161.999878,343.999695,-143);
	MarkRotList[6]=rot(0, 57344, 0);

	MarkLocList[7]=vect(-264, 390, -143);
	MarkRotList[7]=rot(0,0,0);
	*/


}

simulated function UpdateHeight(float newHeight)
{
	local int i;
	local vector v;

	MarkHeight = newHeight;

	for(i = 0; i < 8;i = i + 1)
	{
		MarkLocList[i].z=MarkHeight;
	}

	v.x = MarkList[ChoosedMark].Location.x;
	v.y = MarkList[ChoosedMark].Location.y;
	v.z = MarkHeight;
	MarkList[ChoosedMark].SetLocation(v);
}

simulated function Test()
{
	local StaticMeshActor A;

	foreach AllActors(class'Engine.StaticMeshActor', A,)
	{
		log("Actor is "$A);
		A.bHidden = true;
		A.bAlwaysRelevant = false;
		log("Acotr bHidden is "$A.bHidden);
	}
}

event PlayerController Login
(
    string Portal,
    string Options,
    out string Error
)
{
    local PlayerController NewPlayer;

    NewPlayer = Super.Login(Portal,Options,Error);
    if (Experimenter == none)
       Experimenter = AVCRxPlayer(NewPlayer);

    return NewPlayer;
}

//Here we store information about our game server into special file
function LogExperiment()
{
	local int i;
	local string FileName;

	Logger = Spawn(class'Engine.FileLog',self);

	FileName = Level.Year$"-"$Level.Month$"-"$Level.Day$"_"$Level.Hour$"-"$Level.Minute$"-"$Level.Second$"-Experiment_"$ExperimentCount;
	if (bSecondStage)
		FileName = FileName $ "_SecondStage";
	else
		FileName = FileName $ "_FirstStage";

	if (bSecondVariation)
		FileName = FileName $ "_130Degrees";
	else
		FileName = FileName $ "_15Degrees";

	if (bBeeping)
		FileName = FileName $ "_beep";

	Logger.OpenLog(FileName);

	Logger.Logf("ExperimentStart: "$ExperimentStartTime);
	Logger.Logf("ExperimentEnd: "$Level.Year$"/"$Level.Month$"/"$Level.Day$" "$Level.Hour$":"$Level.Minute$":"$Level.Second$":"$Level.MilliSecond);
	Logger.Logf("ExperimentSecondStage: "$bSecondStage);
	Logger.Logf("Experiment130Degrees: "$bSecondVariation);
	Logger.Logf("ExperimentBeeping: "$bBeeping);

	Logger.Logf("PlayerEndPosition: "$Experimenter.Pawn.Location);
	Logger.Logf("GoalPosition: "$Goal.Location);
	Logger.Logf("StartPosition: "$Start.Location);

	Logger.Logf("//------------------------//");
	Logger.Logf("//------------------------//");
	Logger.Logf("PlayerPath: ");
	for (i = 0;i < Experimenter.PlayerPosList.Length; i=i+1 )
	{
		Logger.Logf(string(Experimenter.PlayerPosList[i]));
	}

	Logger.CloseLog();
	Logger.Destroy();

	Broadcast(self,"Log written to UT2004/UserLogs/"$FileName$".log");

	ConsoleCommand("flush", True);

}

simulated function Tick(float DeltaTime)
{
	local Controller C;

	super.Tick(DeltaTime);
	//log("DeltaTime is "$DeltaTime);
	for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer'))
		{
			if (C.Pawn != none)
			{
			    FocusActor.SetLocation(C.Pawn.Location);
			}
		}
	}
}

state ExperimentStart
{
Begin:
FirstStage:
	//log("ExperimentStart");
	Broadcast(self,"Prepare for new experiment round, FIRST STAGE");
	sleep(1);
	Broadcast(self,"Experiment INITIATING");
	InitExperiment();
	Start.bHidden = false;
	bExperimentKeyPressed = false;
	sleep(1);
	Broadcast(self,"Confirm you have reached red dot by pressing the HOME key");
WaitingForReachingStart1:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForReachingStart1';
	Start.bHidden = true;
	Goal.bHidden = false;
	MarkList[ChoosedMark].bHidden = false;
	Broadcast(self,"Red dot reached, for experiment start press HOME key");
	bExperimentKeyPressed = false;
WaitingForStart1:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForStart1';
	ExperimentStarted();
	gotoState('ExperimentRunning','Begin');
SecondStage:
	Broadcast(self,"Prepare for new experiment round, SECOND STAGE");
	sleep(1);
	Broadcast(self,"Experiment INITIATING");
	InitExperiment();
	Start.bHidden = false;
	bExperimentKeyPressed = false;
	sleep(1);
	Broadcast(self,"Confirm you have reached red dot by pressing the HOME key");
WaitingForReachingStart2:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForReachingStart2';
	Start.bHidden = true;
	MarkList[ChoosedMark].bHidden = false;
	Broadcast(self,"Red dot reached, for experiment start press HOME key");
	bExperimentKeyPressed = false;
WaitingForStart2:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForStart2';
	ExperimentStarted();
	gotoState('ExperimentRunning','Begin');
}

state ExperimentRunning
{

Begin:
	//log("ExperimentRunning");
	Broadcast(self,"Experiment RUNNING");
	sleep(1.0);
	if (bBeeping)
	{
		Broadcast(self,"When you reach target, you'll hear beep.");

		goto 'Beeping';
	}
	else
	{
		Broadcast(self,"When you think you've reached the goal, press HOME key");
		goto 'Running';
	}
Running:
	sleep(1.0);
	goto 'Running';
Beeping:
	sleep(0.05);
	vect1 = Goal.Location;
	vect2 = Experimenter.Pawn.Location;
	vect1.z = 0;
	vect2.z = 0;
	if (vSize( vect1 - vect2 ) < approachThreshold)
	{
		Experimenter.PlayOwnedSound(Sound'WeaponSounds.LockOn', SLOT_None, 5.0);
		gotoState('ExperimentEnd','Begin');
		//PlaySound(Sound'CicadaSnds.Decoy.DecoyLaunch', SLOT_None, 5.0);
		//Sound'WeaponSounds.LockOn'
	}

	goto 'Beeping';

}

state ExperimentEnd
{
Begin:
	//log("ExperimentEnd");
	Broadcast(self,"Experiment ENDED");
	ExperimentEnded();
	sleep(2);
End:
	Broadcast(self,"For switching from FIRST to SECOND stage or vice versa press END key");
	sleep(1);
	Broadcast(self,"Waiting for HOME key to be pressed for a new round");
Waiting:
	sleep(1.0);
	goto 'Waiting';

}

function InitExperiment()
{
	local int i,k,l,a;
	local rotator angle;
	local vector GoalPosition, temp, RealPosDirection, usedvec;

	if (ExperimentCount > ExperimentMaxCount)
		ExperimentCount = 1;

	i = MarkPositions[ExperimentCount % 8];
	l = StartDotPositions[ExperimentCount % 8];

    for( k = 0; k < MarkList.Length; k = k + 1 )
	{
		MarkList[k].bHidden = true;
	}

	Goal.bHidden = true;
	Start.bHidden = true;

   	MarkList[ChoosedMark].SetLocation(MarkLocList[i]);
	MarkList[ChoosedMark].SetRotation(MarkRotList[i]);

	Start.SetLocation(MarkLocList[l]);
	Start.SetRotation(MarkRotList[l]);

	//vec130 = vect(-1,1.19,0);
	//vec15 = vect(1,0.268,0);

	if (bSecondVariation)
	{
		//angle = rot(23673, 0, 0); //130 degrees

		Goal.SetLocation(CircleLocList[(i+2)%8]);
	}
	else
	{
		Goal.SetLocation(CircleLocList[(i)%8]);
	}

	//RealPosDirection += Normal(usedvec) * (RealPosDirection dot Normal(usedvec)) * -1;
    //RealPosDirection = Normal(Normal(RealPosDirection * (1 - (a / 90) ) ) + (Normal(RealPosDirection cross vect(0, 0, 1)) * (a / 90)));

 	log("Goal is "$Goal$" location: "$Goal.Location);
	log("Mark is "$MarkList[ChoosedMark]$" location: "$MarkList[ChoosedMark].Location);



}

function ExperimentStarted()
{
	local Controller C;

    ExperimentStartTime = Level.Year$"/"$Level.Month$"/"$Level.Day$" "$Level.Hour$":"$Level.Minute$":"$Level.Second$":"$Level.MilliSecond;
	Goal.bHidden = true;
	Experimenter.bExperimentOn = true;
	Experimenter.gotoState('PlayerWalking','Running');
	Experimenter.NotifyClient();
	/*
    for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer') && !C.PlayerReplicationInfo.bIsSpectator)
		{

			AVCRxPlayer(C).bExperimentOn = true;
			AVCRxPlayer(C).gotoState('PlayerWalking','Running');
			AVCRxPlayer(C).NotifyClient();
			BroadCast(self,"Controller "$C.PlayerReplicationInfo.PlayerName);
		}
	}*/
}

function ExperimentEnded()
{
	local Controller C;

	if (!bSecondStage)
		Goal.bHidden = false;
	LogExperiment();
	Experimenter.bExperimentOn = false;
	Experimenter.gotoState('PlayerWalking','Waiting');
	Experimenter.NotifyClient();
	Experimenter.PlayerPosList.Length = 0;
	/*
    for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer') && !C.PlayerReplicationInfo.bIsSpectator)
		{
			AVCRxPlayer(C).bExperimentOn = false;
			AVCRxPlayer(C).gotoState('PlayerWalking','Waiting');
			AVCRxPlayer(C).NotifyClient();
			AVCRxPlayer(C).PlayerPosList.Length = 0;
		}
	}*/
   	ExperimentCount += 1;
}

//Prevents epic bots from automatically joining the game
function bool NeedPlayers()
{
	return false;
}

//Prevents epic bots from automatically joining the game
function bool BecomeSpectator(PlayerController P)
{
	if ( !Super.BecomeSpectator(P) )
		return false;

	return true;
}

defaultproperties
{
	NetWait=2
	CountDown=0
	bPauseable=True
	TimeLimit=40
	PlayerControllerClassName="AVCR.AVCRxPlayer"
	DefaultPlayerClassName="AVCR.AVCRxPawn"
	GameName="AVCR Experiment"
	GameClass="BotDeathMatch"
	Acronym="AVCR"
	MapPrefix="DM"
	RemoteRole=ROLE_AutonomousProxy
	MarkPositions(0)=6
	MarkPositions(1)=0
	MarkPositions(2)=7
	MarkPositions(3)=3
	MarkPositions(4)=4
	MarkPositions(5)=1
	MarkPositions(6)=5
	MarkPositions(7)=2
	StartDotPositions(0)=2
	StartDotPositions(1)=3
	StartDotPositions(2)=5
	StartDotPositions(3)=7
	StartDotPositions(4)=1
	StartDotPositions(5)=6
	StartDotPositions(6)=0
	StartDotPositions(7)=4
	CircleLocList(0)=(X=-337.000000,Y=267.000000,Z=-241.000000)
	CircleLocList(1)=(X=-329.000000,Y=207.000000,Z=-241.000000)
	CircleLocList(2)=(X=-281.000000,Y=175.000000,Z=-241.000000)
	CircleLocList(3)=(X=-225.000000,Y=187.000000,Z=-241.000000)
	CircleLocList(4)=(X=-193.000000,Y=231.000000,Z=-241.000000)
	CircleLocList(5)=(X=-201.000000,Y=287.000000,Z=-241.000000)
	CircleLocList(6)=(X=-245.000000,Y=323.000000,Z=-241.000000)
	CircleLocList(7)=(X=-297.000000,Y=319.000000,Z=-241.000000)
	MarkLocList(0)=(X=-364.999756,Y=350.999939,Z=-143)
	MarkLocList(1)=(X=-399.999756,Y=248.000122,Z=-143)
	MarkLocList(2)=(X=-360.000122,Y=143.999863,Z=-143)
	MarkLocList(3)=(X=-265.999908,Y=108.999954,Z=-143)
	MarkLocList(4)=(X=-171,Y=146.999985,Z=-143)
	MarkLocList(5)=(X=-127.000061,Y=248.999939,Z=-143)
	MarkLocList(6)=(X=-161.999878,Y=343.999695,Z=-143)
	MarkLocList(7)=(X=-264,Y=390,Z=-143)
	MarkRotList(0)=(Pitch=0,Yaw=8192,Roll=0)
	MarkRotList(1)=(Pitch=0,Yaw=16384,Roll=0)
	MarkRotList(2)=(Pitch=0,Yaw=24576,Roll=0)
	MarkRotList(3)=(Pitch=0,Yaw=32768,Roll=0)
	MarkRotList(4)=(Pitch=0,Yaw=40960,Roll=0)
	MarkRotList(5)=(Pitch=0,Yaw=49152,Roll=0)
	MarkRotList(6)=(Pitch=0,Yaw=57344,Roll=0)
	MarkRotList(7)=(Pitch=0,Yaw=0,Roll=0)
	MarkHeight=-143
	ExperimentMaxCount=8
	ChoosedMark = 5
	approachThreshold = 20

}
