package pogamutjavabot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.FloydWarshallMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.FlagInfo;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.TeamChat;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 */
public class Main extends Agent {
    
    
    //
    // 1. definice tridy listener
    //
    private class DieListener implements RcvMsgListener {

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            body.sendGlobalMessage("Umrel jsem!");           
            
        }
        
    }   
    
    
    private class ChatListener implements RcvMsgListener {

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            body.sendGlobalMessage(memory.getAgentName() + " - " + ((TeamChat)e.getMessage()).string);            
        }
        
    }   
    
    //
    // 2. instanciace listener 
    //
    private DieListener dieListener = new DieListener();
    
    private ChatListener chatListener = new ChatListener();
    
    FloydWarshallMap map = null;
 
    /** Creates a new instance of agent. */
    public Main() {
    }
    
    @PogProp public boolean kecej = false;
    @PogProp public boolean ctf = false;
    
    public int target = Player.TEAM_BLUE;
    
    private String[] msgs = new String[] { "ahoj", "nazdar", "cau" };
    
    NavPoint redBase = null;
    NavPoint blueBase = null;
    
    NavPoint enemyBase = null;
    NavPoint myBase = null;

    protected void doLogic() {
        FlagInfo flag = memory.getEnemyFlag();
        if (flag == null) {
            body.sendGlobalMessage("flag is null");
            body.sendGlobalMessage("nevim, bezim do nepratelske baze");
            gameMap.safeRunToLocation(enemyBase.location);        
            return;
        }
        
        if (flag.team == Player.TEAM_BLUE) {
            body.sendGlobalMessage("tym: blue");
        } else {
            if (flag.team == Player.TEAM_RED) {
                body.sendGlobalMessage("tym: red");
            } else {
                body.sendGlobalMessage("tym: neznamy???");
            }
        }
        
        if (memory.getMyFlag() != null) {
            body.sendGlobalMessage("my flag state: " + memory.getMyFlag().state);
        }
         
        body.sendGlobalMessage("Flag at: " + flag.location);
        
        if (flag.holderID == memory.getAgentID()) {
            body.sendGlobalMessage("drzim vlajku!");
            gameMap.safeRunToLocation(myBase.location);
            return;
        }
        
        if (flag.isVisible() && flag.location != null) {
            body.sendGlobalMessage("vidim vlajku");
            if (!gameMap.safeRunToLocation(flag.location)) {
                body.runToLocation(flag.location);
            }
            return;
        }
        
        body.sendGlobalMessage("nevidim vlajku, bezim do nepratelske baze");
        if (!gameMap.safeRunToLocation(enemyBase.location)) {
            body.turnHorizontal(30);
        }
    }
    
    private boolean atLocation(Triple location) {
        double distance = Triple.distanceInPlane(memory.getAgentLocation(), location);
        body.sendGlobalMessage("distance = " + distance);
        return distance < 80;
    }

    protected void prePrepareAgent() throws PogamutException {
        //
        // 3. registrovat listener pri startu agenta
        //
        body.addTypedRcvMsgListener(dieListener, MessageType.BOT_KILLED);
    }
    
  
    
    protected void postPrepareAgent() throws PogamutException {
        
                
        for (NavPoint nav : memory.getKnownNavPoints()) {
            if (redBase == null && nav.UnrealID.contains("RedFlagBase")) {
                redBase = nav;
                log.info("Red base: " + nav);
            } else 
            if (nav.UnrealID.contains("BlueFlagBase")) {
                blueBase = nav;
                log.info("Blue base: " + nav);
            }
            if (redBase != null && blueBase != null) break;
        }   
        
         // if the game is CTF, balance team numbers
        int myTeam = Player.TEAM_BLUE;
        if (memory.getGameInfo().gameType.contains("CTF")) {
        	int red = memory.getPlayerCount(Player.TEAM_RED);
        	int blue = memory.getPlayerCount(Player.TEAM_BLUE); 
        	if (red > blue) {
        		body.initializer.setTeam(Player.TEAM_BLUE);
                        target=Player.TEAM_RED;
                        myTeam = Player.TEAM_BLUE;                        
        	} else 
        	if (red < blue) {
        		body.initializer.setTeam(Player.TEAM_RED);
                        target=Player.TEAM_BLUE;
                        myTeam = Player.TEAM_RED;
        	} else {
        		if (random.nextInt(2) == 0) {
        			body.initializer.setTeam(Player.TEAM_RED);
                                target=Player.TEAM_BLUE; 
                                myTeam = Player.TEAM_RED;
        		} else {
        			body.initializer.setTeam(Player.TEAM_BLUE);
                                target=Player.TEAM_RED;
                                myTeam = Player.TEAM_BLUE;
        		}
        	}
        }
        if (myTeam == Player.TEAM_BLUE) {
            enemyBase = redBase;
            myBase = blueBase;            
        } else {
            enemyBase = blueBase;
            myBase = redBase;       
        }
        
        
        
        body.addTypedRcvMsgListener(chatListener, MessageType.TEAM_CHAT);
        
        map = new FloydWarshallMap(memory.getKnownNavPoints(), log);        
    }

    protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent

    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}
