/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.Line2D;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;

public class Line2DExtended
extends Line2D {
    public final int hashCode;

    public Line2DExtended(Tuple2D iDirection, Tuple2D iPoint) {
        super(iDirection, iPoint);
        this.direction = M.normalizedNormal(new Tuple2D(iDirection));
        this.point = new Tuple2D(iPoint);
        this.point = this.getCommonPoint();
        this.hashCode = this.countHashCode();
    }

    protected int countHashCode() {
        HashCodes hc = HashCodes.getNewCounter();
        for (int i = 0; i < 2; ++i) {
            hc.add(HashCodes.hash(M.doubleToLong(this.direction.xy[i])));
            hc.add(HashCodes.hash(M.doubleToLong(this.point.xy[i])));
        }
        return hc.getHashCode();
    }

    public static Line2DExtended line2D(Tuple2D pointA, Tuple2D pointB) {
        return new Line2DExtended(new Tuple2D(pointA, pointB), pointA);
    }

    public String toString() {
        return "Line3DExtended(" + this.point + ", <-> " + this.direction + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Line2DExtended)) {
            return false;
        }
        Line2DExtended line = (Line2DExtended)o;
        return M.equals(this.direction, line.direction) && M.equals(this.point, line.point);
    }
}

