/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;

public class Tuple4D
implements Cloneable {
    public double[] xyzd = new double[]{0.0, 0.0, 0.0, 0.0};

    public Tuple4D() {
    }

    public Tuple4D(double x, double y, double z, double d) {
        this.xyzd[0] = x;
        this.xyzd[1] = y;
        this.xyzd[2] = z;
        this.xyzd[3] = d;
    }

    public Tuple4D(Tuple4D tuple) {
        this.xyzd[0] = tuple.xyzd[0];
        this.xyzd[1] = tuple.xyzd[1];
        this.xyzd[2] = tuple.xyzd[2];
        this.xyzd[3] = tuple.xyzd[3];
    }

    public Tuple4D(Tuple4D tuple1, Tuple4D tuple2) {
        this.xyzd[0] = tuple1.xyzd[0] - tuple2.xyzd[0];
        this.xyzd[1] = tuple1.xyzd[1] - tuple2.xyzd[1];
        this.xyzd[2] = tuple1.xyzd[2] - tuple2.xyzd[2];
        this.xyzd[3] = tuple1.xyzd[3] - tuple2.xyzd[3];
    }

    public Object clone() {
        return new Tuple4D(this);
    }

    public boolean equals(double x, double y, double z, double d) {
        return Math.abs(this.xyzd[0] - x) < M.EPSILON && Math.abs(this.xyzd[1] - d) < M.EPSILON && Math.abs(this.xyzd[2] - z) < M.EPSILON && Math.abs(this.xyzd[3] - d) < M.EPSILON;
    }

    public boolean equals(Tuple4D t) {
        return Math.abs(this.xyzd[0] - t.xyzd[0]) < M.EPSILON && Math.abs(this.xyzd[1] - t.xyzd[1]) < M.EPSILON && Math.abs(this.xyzd[2] - t.xyzd[2]) < M.EPSILON && Math.abs(this.xyzd[3] - t.xyzd[3]) < M.EPSILON;
    }

    public Tuple4D assign(double x, double y, double z, double d) {
        this.xyzd[0] = x;
        this.xyzd[1] = y;
        this.xyzd[2] = z;
        this.xyzd[3] = d;
        return this;
    }

    public Tuple4D assign(Tuple4D a) {
        this.xyzd[0] = a.xyzd[0];
        this.xyzd[1] = a.xyzd[1];
        this.xyzd[2] = a.xyzd[2];
        this.xyzd[3] = a.xyzd[3];
        return this;
    }

    public Tuple4D plus(double[] xyzd_) {
        this.xyzd[0] = this.xyzd[0] + xyzd_[0];
        this.xyzd[1] = this.xyzd[1] + xyzd_[1];
        this.xyzd[2] = this.xyzd[2] + xyzd_[2];
        this.xyzd[3] = this.xyzd[3] + xyzd_[3];
        return this;
    }

    public Tuple4D plus(Tuple4D a) {
        this.xyzd[0] = this.xyzd[0] + a.xyzd[0];
        this.xyzd[1] = this.xyzd[1] + a.xyzd[1];
        this.xyzd[2] = this.xyzd[2] + a.xyzd[2];
        this.xyzd[3] = this.xyzd[3] + a.xyzd[3];
        return this;
    }

    public Tuple4D abs() {
        this.xyzd[0] = Math.abs(this.xyzd[0]);
        this.xyzd[1] = Math.abs(this.xyzd[1]);
        this.xyzd[2] = Math.abs(this.xyzd[2]);
        this.xyzd[3] = Math.abs(this.xyzd[3]);
        return this;
    }

    public Tuple4D inverse() {
        this.xyzd[0] = -this.xyzd[0];
        this.xyzd[1] = -this.xyzd[1];
        this.xyzd[2] = -this.xyzd[2];
        this.xyzd[3] = -this.xyzd[3];
        return this;
    }

    public double sqrLength() {
        return this.xyzd[0] * this.xyzd[0] + this.xyzd[1] * this.xyzd[1] + this.xyzd[2] * this.xyzd[2] + this.xyzd[3] * this.xyzd[3];
    }

    public double length() {
        return Math.sqrt(this.xyzd[0] * this.xyzd[0] + this.xyzd[1] * this.xyzd[1] + this.xyzd[2] * this.xyzd[2] + this.xyzd[3] * this.xyzd[3]);
    }

    public Tuple4D normalize() {
        double len = this.length();
        if (Math.abs(len) < M.EPSILON) {
            this.xyzd[0] = 0.0;
            this.xyzd[1] = 0.0;
            this.xyzd[2] = 0.0;
            this.xyzd[3] = 0.0;
        } else {
            this.xyzd[0] = this.xyzd[0] / len;
            this.xyzd[1] = this.xyzd[1] / len;
            this.xyzd[2] = this.xyzd[2] / len;
            this.xyzd[3] = this.xyzd[3] / len;
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.xyzd[0]);
        sb.append(" / ");
        sb.append(this.xyzd[1]);
        sb.append(" / ");
        sb.append(this.xyzd[2]);
        sb.append(" / ");
        sb.append(this.xyzd[3]);
        sb.append("]");
        return sb.toString();
    }
}

