/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.errorlog.ErrorLog;
import cz.cuni.utils.math.HalfLine2D;
import cz.cuni.utils.math.Line2D;
import cz.cuni.utils.math.Line3D;
import cz.cuni.utils.math.Plane3D;
import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.Tuple4D;
import cz.cuni.utils.math.extended.Segment2D;
import cz.cuni.utils.math.extended.Segment3D;
import cz.cuni.utils.math.extended.Triangle2D;
import cz.cuni.utils.math.extended.Triangle3D;
import cz.cuni.utils.math.extended.Vertex2D;
import cz.cuni.utils.math.extended.Vertex3D;
import cz.cuni.utils.math.tuple3Dcomparators.Tuple3DNormalizedComparator;
import cz.cuni.utils.math.tuple3Dcomparators.Tuple3DNormalizedComparatorXYZ;
import cz.cuni.utils.math.tuple3Dcomparators.Tuple3DNormalizedComparatorYZ;
import cz.cuni.utils.math.tuple3Dcomparators.Tuple3DNormalizedComparatorZ;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;

public class M {
    public static final int EPSILON_DIGITS = 8;
    public static final double EPSILON = Math.pow(10.0, -8.0);
    public static final long DOUBLE_TO_LONG = Math.round(Math.pow(10.0, 8.0));
    public static final int NEAR_ZERO_DIGITS = 12;
    public static final double NEAR_ZERO = Math.pow(0.1, 12.0);
    public static final double PROJECTION_EPSILON = 5.0E-5;
    private static final double LINE_INTERSECTION_EPSILON = 1.0E-5;
    private static final double LINE_INTERSECTION_MIN_TO_COMPUTE_WITH = 0.001;
    public static final Tuple3DNormalizedComparatorXYZ tuple3DNormalizedComparatorXYZ = new Tuple3DNormalizedComparatorXYZ();
    public static final Tuple3DNormalizedComparatorYZ tuple3DNormalizedComparatorYZ = new Tuple3DNormalizedComparatorYZ();
    public static final Tuple3DNormalizedComparatorZ tuple3DNormalizedComparatorZ = new Tuple3DNormalizedComparatorZ();
    public static final Tuple3DNormalizedComparator tuple3DNormalizedComparator = tuple3DNormalizedComparatorXYZ;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double UT_ANGLE_TO_RAD = 9.587379924285257E-5;

    public static double rad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static double deg(double rad) {
        return rad * 57.29577951308232;
    }

    public static double utAngleToRad(double utAngleDegree) {
        return utAngleDegree * 9.587379924285257E-5;
    }

    public static boolean sameSign(double x, double y) {
        if (x > 0.0) {
            return y > 0.0;
        }
        return !(y > 0.0);
    }

    public static Object[] copyVertices2D(AbstractCollection vertices) {
        Object[] objs = new Object[vertices.size()];
        Iterator iter = vertices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            objs[i] = ((Tuple2D)iter.next()).clone();
            ++i;
        }
        return objs;
    }

    public static Object[] copyVertices3D(AbstractCollection vertices) {
        Object[] objs = new Object[vertices.size()];
        Iterator iter = vertices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            objs[i] = ((Tuple3D)iter.next()).clone();
            ++i;
        }
        return objs;
    }

    public static Object[] copyVertices4D(AbstractCollection vertices) {
        Object[] objs = new Object[vertices.size()];
        Iterator iter = vertices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            objs[i] = ((Tuple4D)iter.next()).clone();
            ++i;
        }
        return objs;
    }

    public static boolean equals(double x, double y) {
        return Math.abs(x - y) < EPSILON;
    }

    public static boolean equals(double x, double y, double precision) {
        return Math.abs(x - y) < precision;
    }

    public static double round(double x, int precision) {
        return Math.round(x * (double)DOUBLE_TO_LONG) / DOUBLE_TO_LONG;
    }

    public static long doubleToLong(double x) {
        return Math.round(x * (double)DOUBLE_TO_LONG);
    }

    public static double linearEq(double a, double b) {
        return -b / a;
    }

    public static double linearEq(double a, double b, double c) {
        return (c - b) / a;
    }

    public static double[] quadraticEq(double a, double b, double c) {
        if (M.equals(a, 0.0)) {
            return new double[]{M.linearEq(b, c)};
        }
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return null;
        }
        if (M.equals(d, 0.0)) {
            return new double[]{-b / (2.0 * a)};
        }
        d = Math.sqrt(d);
        return new double[]{(-b + d) / (2.0 * a), (-b - d) / (2.0 * a)};
    }

    public static double[] linearEq2(double a1, double b1, double c1, double a2, double b2, double c2) {
        double det = a1 * b2 - b1 * a2;
        if (M.equals(det, 0.0)) {
            return null;
        }
        return new double[]{(c1 * b2 - b1 * c2) / det, (a1 * c2 - c1 * a2) / det};
    }

    public static int clockwiseOrder2D(double x1, double y1, double x2, double y2, double x3, double y3) {
        double angle3;
        if (x1 > x2 || x3 > x2) {
            return 0;
        }
        if (M.equals(y1, y2)) {
            if (M.equals(y3, y2)) {
                if (M.equals(x1, x3)) {
                    return 1;
                }
                if (x1 < x3) {
                    return 1;
                }
                return -1;
            }
            if (y3 > y2) {
                return -1;
            }
            return 1;
        }
        if (y1 > y2) {
            double angle32;
            if (M.equals(y3, y2) || y3 < y2) {
                return 1;
            }
            if (M.equals(x1, x3) && M.equals(y1, y3)) {
                return 1;
            }
            if (M.equals(x1, x2) && M.equals(x2, x3)) {
                return 0;
            }
            Tuple2D v1 = new Tuple2D(new Tuple2D(x1, y1), new Tuple2D(x2, y2));
            Tuple2D v2 = new Tuple2D(new Tuple2D(x2 - 10.0, y2), new Tuple2D(x2, y2));
            Tuple2D v3 = new Tuple2D(new Tuple2D(x3, y3), new Tuple2D(x2, y2));
            double angle1 = M.angle(v2, v1);
            if (angle1 > (angle32 = M.angle(v2, v3))) {
                return 1;
            }
            return -1;
        }
        if (M.equals(y3, y2) || y3 > y2) {
            return -1;
        }
        if (M.equals(x1, x3) && M.equals(y1, y3)) {
            return 1;
        }
        if (M.equals(x1, x2) && M.equals(x2, x3)) {
            return 0;
        }
        Tuple2D v1 = new Tuple2D(new Tuple2D(x1, y1), new Tuple2D(x2, y2));
        Tuple2D v2 = new Tuple2D(new Tuple2D(x2 - 10.0, y2), new Tuple2D(x2, y2));
        Tuple2D v3 = new Tuple2D(new Tuple2D(x3, y3), new Tuple2D(x2, y2));
        double angle1 = M.angle(v2, v1);
        if (angle1 > (angle3 = M.angle(v2, v3))) {
            return -1;
        }
        return 1;
    }

    public static void normalizedAdaptiveSort(Object[] array) {
        if (array.length < 2) {
            return;
        }
        boolean[] allNear = new boolean[]{true, true, true};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                for (int k = j + 1; k < array.length; ++k) {
                    if (M.equals(((Tuple3D)array[j]).xyz[i], ((Tuple3D)array[k]).xyz[i], 1.0E-5)) continue;
                    allNear[i] = false;
                    break;
                }
                if (!allNear[i]) break;
            }
            if (!allNear[i]) break;
        }
        Tuple3DNormalizedComparator comparator = allNear[0] ? (allNear[1] ? (allNear[2] ? tuple3DNormalizedComparatorXYZ : tuple3DNormalizedComparatorZ) : tuple3DNormalizedComparatorYZ) : tuple3DNormalizedComparatorXYZ;
        Arrays.sort(array, comparator);
    }

    public static boolean equals(Tuple2D a, Tuple2D b) {
        return Math.abs(a.xy[0] - b.xy[0]) < EPSILON && Math.abs(a.xy[1] - b.xy[1]) < EPSILON;
    }

    public static boolean equals(Tuple2D a, Tuple2D b, double precision) {
        return Math.abs(a.xy[0] - b.xy[0]) < precision && Math.abs(a.xy[1] - b.xy[1]) < precision;
    }

    public static boolean vectorEquals(Tuple2D a, Tuple2D b) {
        return M.equals(a, b) || M.equals(a, M.multi(b, -1.0));
    }

    public static boolean vectorEquals(Tuple2D a, Tuple2D b, double precision) {
        return M.equals(a, b, precision) || M.equals(a, M.multi(b, -1.0), precision);
    }

    public static Tuple2D vector(Tuple2D a, Tuple2D b) {
        return new Tuple2D(a, b);
    }

    public static double distance(Tuple2D a, Tuple2D b) {
        return new Tuple2D(a, b).length();
    }

    public static double distance(Tuple2D a, Line2D l) {
        return Math.abs(a.xy[0] * l.equation.xyz[0] + a.xy[1] * l.equation.xyz[1] + l.equation.xyz[2]) / l.normal.length();
    }

    public static double distanceSigned(Tuple2D a, Line2D l) {
        return (a.xy[0] * l.equation.xyz[0] + a.xy[1] * l.equation.xyz[1] + l.equation.xyz[2]) / l.normal.length();
    }

    public static Tuple2D inverse(double x, double y) {
        return new Tuple2D(-x, -y);
    }

    public static Tuple2D inverse(Tuple2D a) {
        return new Tuple2D(-a.xy[0], -a.xy[1]);
    }

    public static Tuple2D plus(double x, double y, double amount) {
        return new Tuple2D(x + amount, y + amount);
    }

    public static Tuple2D plus(Tuple2D a, double amount) {
        return new Tuple2D(a.xy[0] + amount, a.xy[1] + amount);
    }

    public static Tuple2D plus(Tuple2D a, Tuple2D b) {
        return new Tuple2D(a.xy[0] + b.xy[0], a.xy[1] + b.xy[1]);
    }

    public static double multiScalar(Tuple2D a, Tuple2D b) {
        return a.xy[0] * b.xy[0] + a.xy[1] * b.xy[1];
    }

    public static Tuple2D multi(double x, double y, double ratio) {
        return new Tuple2D(x * ratio, y * ratio);
    }

    public static Tuple2D multi(Tuple2D a, double ratio) {
        return new Tuple2D(a.xy[0] * ratio, a.xy[1] * ratio);
    }

    public static Tuple2D perpendicular(Tuple2D a) {
        return new Tuple2D(-a.xy[1], a.xy[0]);
    }

    public static boolean sameWay(Tuple2D vector1, Tuple2D vector2) {
        for (int i = 0; i < 2; ++i) {
            if (M.equals(vector1.xy[i], 0.0)) continue;
            return M.sameSign(vector1.xy[i], vector2.xy[i]);
        }
        return true;
    }

    public static double angle(Tuple2D a, Tuple2D b) {
        Tuple2D normalizedB;
        Tuple2D normalizedA = new Tuple2D(a).normalize();
        if (M.equals(normalizedA, normalizedB = new Tuple2D(b).normalize())) {
            return 0.0;
        }
        if (M.equals(normalizedA, normalizedB.getInverse())) {
            return Math.PI;
        }
        return Math.acos(M.multiScalar(normalizedA, normalizedB) / (normalizedA.length() * normalizedB.length()));
    }

    public static double smallerAngle(double angle) {
        if (angle < -Math.PI) {
            return angle + Math.PI;
        }
        if (angle > Math.PI) {
            return angle - Math.PI;
        }
        return angle;
    }

    public static Tuple2D intersection(Line2D line1, Line2D line2) {
        double[] ab = M.linearEq2(line1.direction.xy[0], -line2.direction.xy[0], line2.point.xy[0] - line1.point.xy[0], line1.direction.xy[1], -line2.direction.xy[1], line2.point.xy[1] - line1.point.xy[1]);
        if (ab == null) {
            return null;
        }
        return new Tuple2D(line1.point.xy[0] + ab[0] * line1.direction.xy[0], line1.point.xy[1] + ab[0] * line1.direction.xy[1]);
    }

    public static double coeficient(Line2D line, Tuple2D pointInLine, Tuple2D anotherPointInLine) {
        Tuple2D vector = new Tuple2D(anotherPointInLine, pointInLine);
        for (int i = 0; i < 2; ++i) {
            if (M.equals(line.direction.xy[i], 0.0)) continue;
            return vector.xy[i] / line.direction.xy[i];
        }
        return 0.0;
    }

    public static double smallerAngle(Tuple2D a, Tuple2D b) {
        return M.smallerAngle(M.angle(a, b));
    }

    public static Tuple2D[] normalizedOrder(Tuple2D a, Tuple2D b) {
        for (int i = 0; i < 2; ++i) {
            if (M.equals(a.xy[i], b.xy[i])) continue;
            if (a.xy[i] > b.xy[i]) {
                return new Tuple2D[]{a, b};
            }
            return new Tuple2D[]{b, a};
        }
        return null;
    }

    public static Vertex2D[] normalizedOrder(Vertex2D a, Vertex2D b) {
        for (int i = 0; i < 2; ++i) {
            if (M.equals(a.xy[i], b.xy[i])) continue;
            if (a.xy[i] > b.xy[i]) {
                return new Vertex2D[]{a, b};
            }
            return new Vertex2D[]{b, a};
        }
        return null;
    }

    public static Tuple2D normalizedNormal(Tuple2D normal) {
        return M.normalizedNormal(normal, EPSILON);
    }

    public static Tuple2D normalizedNormal(Tuple2D normal, double precision) {
        for (int i = 0; i < 2; ++i) {
            if (M.equals(normal.xy[i], 0.0, precision)) continue;
            if (normal.xy[i] > 0.0) {
                return new Tuple2D(normal).normalize();
            }
            return new Tuple2D(normal).inverse().normalize();
        }
        return new Tuple2D(0.0, 0.0);
    }

    public static boolean intersectSegment(Line2D line, Segment2D segment) {
        Tuple2D intersection = M.intersection(line, segment.line);
        if (intersection == null) {
            return false;
        }
        return M.inSegment(segment, intersection);
    }

    public static boolean intersectSegment(HalfLine2D line, Segment2D segment) {
        Tuple2D intersection = M.intersection(new Line2D(line.direction, line.pointBegin), segment.line);
        if (intersection == null) {
            return false;
        }
        if (!line.inHalfLine(intersection)) {
            return false;
        }
        return M.inSegment(segment, intersection);
    }

    public static boolean isTriangle(Tuple2D a, Tuple2D b, Tuple2D c) {
        return !M.isCollinear(a, b, c);
    }

    public static boolean equals(Tuple3D a, Tuple3D b) {
        return Math.abs(a.xyz[0] - b.xyz[0]) < EPSILON && Math.abs(a.xyz[1] - b.xyz[1]) < EPSILON && Math.abs(a.xyz[2] - b.xyz[2]) < EPSILON;
    }

    public static boolean equalsSafe(Tuple3D a, Tuple3D b) {
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a.xyz[0] - b.xyz[0]) < EPSILON && Math.abs(a.xyz[1] - b.xyz[1]) < EPSILON && Math.abs(a.xyz[2] - b.xyz[2]) < EPSILON;
    }

    public static boolean equals(Tuple3D a, Tuple3D b, double precision) {
        return Math.abs(a.xyz[0] - b.xyz[0]) < precision && Math.abs(a.xyz[1] - b.xyz[1]) < precision && Math.abs(a.xyz[2] - b.xyz[2]) < precision;
    }

    public static boolean equalsSafe(Tuple3D a, Tuple3D b, double precision) {
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a.xyz[0] - b.xyz[0]) < precision && Math.abs(a.xyz[1] - b.xyz[1]) < precision && Math.abs(a.xyz[2] - b.xyz[2]) < precision;
    }

    public static boolean sameWay(Tuple3D vector1, Tuple3D vector2) {
        for (int i = 0; i < 3; ++i) {
            if (M.equals(vector1.xyz[i], 0.0) || M.equals(vector2.xyz[i], 0.0)) continue;
            return M.sameSign(vector1.xyz[i], vector2.xyz[i]);
        }
        return true;
    }

    public static Tuple3D normalizedNormal(Tuple3D normal) {
        return M.normalizedNormal(normal, EPSILON);
    }

    public static Tuple3D normalizedNormal(Tuple3D normal, double precision) {
        for (int i = 0; i < 3; ++i) {
            if (M.equals(normal.xyz[i], 0.0, precision)) continue;
            if (normal.xyz[i] > 0.0) {
                return new Tuple3D(normal).normalize();
            }
            return new Tuple3D(normal).inverse().normalize();
        }
        return new Tuple3D(0.0, 0.0, 0.0);
    }

    public static Tuple3D normalizedNormalTestZero(Tuple3D normal) {
        return M.normalizedNormalTestZero(normal, EPSILON);
    }

    public static Tuple3D normalizedNormalTestZero(Tuple3D normal, double precision) {
        int i;
        Tuple3D n = null;
        for (i = 0; i < 3; ++i) {
            if (M.equals(normal.xyz[i], 0.0, precision)) continue;
            if (normal.xyz[i] > 0.0) {
                n = new Tuple3D(normal).normalize();
                break;
            }
            n = new Tuple3D(normal).inverse().normalize();
            break;
        }
        if (n == null) {
            return new Tuple3D(0.0, 0.0, 0.0);
        }
        for (i = 0; i < 3; ++i) {
            if (!M.equals(n.xyz[i], 0.0, NEAR_ZERO)) continue;
            n.xyz[i] = 0.0;
        }
        n.normalize();
        return n;
    }

    public static boolean equals(Plane3D a, Plane3D b) {
        return M.equals(a, b, EPSILON);
    }

    public static boolean equals(Plane3D a, Plane3D b, double precision) {
        Tuple3D normalB;
        Tuple3D normalA = M.normalizedNormal(a.normal, precision);
        if (!M.equals(normalA, normalB = M.normalizedNormal(b.normal, precision), precision)) {
            return false;
        }
        return M.equals(a.getCommonPoint(), b.getCommonPoint(), precision);
    }

    public static boolean vectorEquals(Tuple3D a, Tuple3D b) {
        return M.equals(a, b) || M.equals(a, M.multi(b, -1.0));
    }

    public static boolean vectorEquals(Tuple3D a, Tuple3D b, double precision) {
        return M.equals(a, b, precision) || M.equals(a, M.multi(b, -1.0), precision);
    }

    public static Tuple3D vector(Tuple3D a, Tuple3D b) {
        return new Tuple3D(a, b);
    }

    public static double distance(Tuple3D a, Tuple3D b) {
        return new Tuple3D(a, b).length();
    }

    public static double distance(Tuple3D a, Plane3D p) {
        return Math.abs((p.t4d.xyzd[0] * a.xyz[0] + p.t4d.xyzd[1] * a.xyz[1] + p.t4d.xyzd[2] * a.xyz[2] + p.t4d.xyzd[3]) / p.normal.length());
    }

    public static double distanceSigned(Tuple3D a, Plane3D p) {
        return (p.t4d.xyzd[0] * a.xyz[0] + p.t4d.xyzd[1] * a.xyz[1] + p.t4d.xyzd[2] * a.xyz[2] + p.t4d.xyzd[3]) / p.normal.length();
    }

    public static Tuple3D inverse(double x, double y, double z) {
        return new Tuple3D(-x, -y, -z);
    }

    public static Tuple3D inverse(Tuple3D a) {
        return new Tuple3D(-a.xyz[0], -a.xyz[1], -a.xyz[2]);
    }

    public static Tuple3D plus(double x, double y, double z, double amount) {
        return new Tuple3D(x + amount, y + amount, z + amount);
    }

    public static Tuple3D plus(Tuple3D a, double amount) {
        return new Tuple3D(a.xyz[0] + amount, a.xyz[1] + amount, a.xyz[2] + amount);
    }

    public static Tuple3D plus(Tuple3D a, Tuple3D b) {
        return new Tuple3D(a.xyz[0] + b.xyz[0], a.xyz[1] + b.xyz[1], a.xyz[2] + b.xyz[2]);
    }

    public static double multiScalar(Tuple3D a, Tuple3D b) {
        return a.xyz[0] * b.xyz[0] + a.xyz[1] * b.xyz[1] + a.xyz[2] * b.xyz[2];
    }

    public static Tuple3D multi(double x, double y, double z, double ratio) {
        return new Tuple3D(x * ratio, y * ratio, z * ratio);
    }

    public static Tuple3D multi(Tuple3D a, double ratio) {
        return new Tuple3D(a.xyz[0] * ratio, a.xyz[1] * ratio, a.xyz[2] * ratio);
    }

    public static Tuple3D multi(Tuple3D a, double x, double y, double z) {
        return new Tuple3D(a.xyz[1] * z - a.xyz[2] * y, a.xyz[2] * x - a.xyz[0] * z, a.xyz[0] * y - a.xyz[1] * x);
    }

    public static Tuple3D multi(Tuple3D a, Tuple3D b) {
        return new Tuple3D(a.xyz[1] * b.xyz[2] - a.xyz[2] * b.xyz[1], a.xyz[2] * b.xyz[0] - a.xyz[0] * b.xyz[2], a.xyz[0] * b.xyz[1] - a.xyz[1] * b.xyz[0]);
    }

    public static double angle(Tuple3D a, Tuple3D b) {
        Tuple3D normalizedB;
        Tuple3D normalizedA = new Tuple3D(a).normalize();
        if (M.equals(normalizedA, normalizedB = new Tuple3D(b).normalize())) {
            return 0.0;
        }
        if (M.equals(normalizedA, normalizedB.getInverse())) {
            return Math.PI;
        }
        return Math.acos(M.multiScalar(a, b) / (a.length() * b.length()));
    }

    public static Tuple3D perpendicular2DYZ(Tuple3D v) {
        return new Tuple3D(v.xyz[0], -v.xyz[2], v.xyz[1]);
    }

    public static Tuple3D rotateX(double x, double y, double z, double rad) {
        return new Tuple3D(x, Math.cos(rad) * y - Math.sin(rad) * z, Math.sin(rad) * y + Math.cos(rad) * z);
    }

    public static Tuple3D rotateX(Tuple3D a, double rad) {
        return new Tuple3D(a.xyz[0], Math.cos(rad) * a.xyz[1] - Math.sin(rad) * a.xyz[2], Math.sin(rad) * a.xyz[1] + Math.cos(rad) * a.xyz[2]);
    }

    public static Tuple3D rotateY(double x, double y, double z, double rad) {
        return new Tuple3D(Math.cos(rad) * x + Math.sin(rad) * z, y, -Math.sin(rad) * x + Math.cos(rad) * z);
    }

    public static Tuple3D rotateY(Tuple3D a, double rad) {
        return new Tuple3D(Math.cos(rad) * a.xyz[0] + Math.sin(rad) * a.xyz[2], a.xyz[1], -Math.sin(rad) * a.xyz[0] + Math.cos(rad) * a.xyz[2]);
    }

    public static Tuple3D rotateZ(double x, double y, double z, double rad) {
        return new Tuple3D(Math.cos(rad) * x - Math.sin(rad) * y, Math.sin(rad) * x + (double)((float)Math.cos(rad)) * y, z);
    }

    public static Tuple3D rotateZ(Tuple3D a, double rad) {
        return new Tuple3D(Math.cos(rad) * a.xyz[0] - Math.sin(rad) * a.xyz[1], Math.sin(rad) * a.xyz[0] + Math.cos(rad) * a.xyz[1], a.xyz[2]);
    }

    public static Tuple3D rotateYawPitchRoll(double x, double y, double z, double yawRad, double pitchRad, double rollRad) {
        return new Tuple3D(Math.cos(pitchRad) * Math.cos(yawRad) * x + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) - Math.cos(rollRad) * Math.sin(yawRad)) * y + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) + Math.sin(rollRad) * Math.sin(yawRad)) * z, Math.cos(pitchRad) * Math.sin(yawRad) * x + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) + Math.cos(rollRad) * Math.cos(yawRad)) * y + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) - Math.sin(rollRad) * Math.cos(yawRad)) * z, -Math.sin(pitchRad) * x + Math.cos(pitchRad) * Math.sin(rollRad) * y + Math.cos(pitchRad) * Math.cos(rollRad) * z);
    }

    public static Tuple3D rotateYawPitchRoll(Tuple3D a, double yawRad, double pitchRad, double rollRad) {
        return new Tuple3D(Math.cos(pitchRad) * Math.cos(yawRad) * a.xyz[0] + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) - Math.cos(rollRad) * Math.sin(yawRad)) * a.xyz[1] + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) + Math.sin(rollRad) * Math.sin(yawRad)) * a.xyz[2], Math.cos(pitchRad) * Math.sin(yawRad) * a.xyz[0] + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) + Math.cos(rollRad) * Math.cos(yawRad)) * a.xyz[1] + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) - Math.sin(rollRad) * Math.cos(yawRad)) * a.xyz[2], -Math.sin(pitchRad) * a.xyz[0] + Math.cos(pitchRad) * Math.sin(rollRad) * a.xyz[1] + Math.cos(pitchRad) * Math.cos(rollRad) * a.xyz[2]);
    }

    public static Tuple3D rotateYawPitchRoll(Tuple3D a, Tuple3D yawPitchRollRad) {
        double yawRad = yawPitchRollRad.xyz[0];
        double pitchRad = yawPitchRollRad.xyz[1];
        double rollRad = yawPitchRollRad.xyz[2];
        return new Tuple3D(Math.cos(pitchRad) * Math.cos(yawRad) * a.xyz[0] + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) - Math.cos(rollRad) * Math.sin(yawRad)) * a.xyz[1] + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.cos(yawRad) + Math.sin(rollRad) * Math.sin(yawRad)) * a.xyz[2], Math.cos(pitchRad) * Math.sin(yawRad) * a.xyz[0] + (Math.sin(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) + Math.cos(rollRad) * Math.cos(yawRad)) * a.xyz[1] + (Math.cos(rollRad) * Math.sin(pitchRad) * Math.sin(yawRad) - Math.sin(rollRad) * Math.cos(yawRad)) * a.xyz[2], -Math.sin(pitchRad) * a.xyz[0] + Math.cos(pitchRad) * Math.sin(rollRad) * a.xyz[1] + Math.cos(pitchRad) * Math.cos(rollRad) * a.xyz[2]);
    }

    public static boolean isCollinear(Tuple2D a, Tuple2D b, Tuple2D c) {
        return M.isCollinear(a, b, c, EPSILON);
    }

    public static boolean isCollinear(Tuple2D a, Tuple2D b, Tuple2D c, double precision) {
        return a.equals(b, precision) || a.equals(c, precision) || b.equals(c, precision) || Line2D.line2D(a, b).inLine(c, precision);
    }

    public static boolean isCollinear(Tuple3D a, Tuple3D b, Tuple3D c) {
        return M.isCollinear(a, b, c, EPSILON);
    }

    public static boolean isCollinear(Tuple3D a, Tuple3D b, Tuple3D c, double precision) {
        return a.equals(b, precision) || a.equals(c, precision) || b.equals(c, precision) || Line3D.line3D(a, b).inLine(c, precision);
    }

    public static boolean inSegment(Segment2D s, Tuple2D point) {
        return M.inSegment(s.ab[0], s.ab[1], s.line, point, EPSILON);
    }

    public static boolean inSegment(Segment2D s, Tuple2D point, double precision) {
        return M.inSegment(s.ab[0], s.ab[1], s.line, point, precision);
    }

    public static boolean inSegment(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Tuple2D point) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, Line2D.line2D(firstEndOfSegment, secondEndOfSegment), point);
    }

    public static boolean inSegment(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Tuple2D point, double precision) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, Line2D.line2D(firstEndOfSegment, secondEndOfSegment), point, precision);
    }

    public static boolean inSegment(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Line2D segmentLine, Tuple2D point) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, segmentLine, point, EPSILON);
    }

    public static boolean inSegment(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Line2D segmentLine, Tuple2D point, double precision) {
        if (!segmentLine.inLine(point)) {
            return false;
        }
        if (M.equals(firstEndOfSegment, point)) {
            return true;
        }
        if (M.equals(secondEndOfSegment, point)) {
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            if (M.equals(firstEndOfSegment.xy[i], secondEndOfSegment.xy[i], precision)) continue;
            if (firstEndOfSegment.xy[i] > secondEndOfSegment.xy[i]) {
                return secondEndOfSegment.xy[i] <= point.xy[i] && point.xy[i] <= firstEndOfSegment.xy[i];
            }
            return secondEndOfSegment.xy[i] >= point.xy[i] && point.xy[i] >= firstEndOfSegment.xy[i];
        }
        return false;
    }

    public static boolean inSegmentNotEnd(Segment2D s, Tuple2D point) {
        return M.inSegmentNotEnd(s.ab[0], s.ab[1], s.line, point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Segment2D s, Tuple2D point, double precision) {
        return M.inSegmentNotEnd(s.ab[0], s.ab[1], s.line, point, precision);
    }

    public static boolean inSegmentNotEnd(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Tuple2D point) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, Line2D.line2D(firstEndOfSegment, secondEndOfSegment), point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Tuple2D point, double precision) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, Line2D.line2D(firstEndOfSegment, secondEndOfSegment), point, precision);
    }

    public static boolean inSegmentNotEnd(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Line2D segmentLine, Tuple2D point) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, segmentLine, point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Tuple2D firstEndOfSegment, Tuple2D secondEndOfSegment, Line2D segmentLine, Tuple2D point, double precision) {
        if (M.equals(firstEndOfSegment, point, precision)) {
            return false;
        }
        if (M.equals(secondEndOfSegment, point, precision)) {
            return false;
        }
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, segmentLine, point, precision);
    }

    public static boolean inTriangle(Tuple2D point, Triangle2D triangle) {
        Tuple2D u = new Tuple2D(triangle.vertices[1], triangle.vertices[0]);
        Tuple2D v = new Tuple2D(triangle.vertices[2], triangle.vertices[0]);
        double[] roots = M.linearEq2(u.xy[0], v.xy[0], point.xy[0] - triangle.vertices[0].xy[0], u.xy[1], v.xy[1], point.xy[1] - triangle.vertices[0].xy[1]);
        return roots[0] >= 0.0 && roots[1] >= 0.0 && roots[0] + roots[1] <= 1.0;
    }

    public static boolean inSegment(Segment3D s, Tuple3D point) {
        return M.inSegment(s.ab[0], s.ab[1], s.line, point, EPSILON);
    }

    public static boolean inSegment(Segment3D s, Tuple3D point, double precision) {
        return M.inSegment(s.ab[0], s.ab[1], s.line, point, precision);
    }

    public static boolean inSegment(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Tuple3D point) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, Line3D.line3D(firstEndOfSegment, secondEndOfSegment), point);
    }

    public static boolean inSegment(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Tuple3D point, double precision) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, Line3D.line3D(firstEndOfSegment, secondEndOfSegment), point, precision);
    }

    public static boolean inSegment(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Line3D segmentLine, Tuple3D point) {
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, segmentLine, point, EPSILON);
    }

    public static boolean inSegment(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Line3D segmentLine, Tuple3D point, double precision) {
        if (M.equals(firstEndOfSegment, point, precision)) {
            return true;
        }
        if (M.equals(secondEndOfSegment, point, precision)) {
            return true;
        }
        Tuple3D pointInLine = M.project(point, segmentLine);
        if (pointInLine == null) {
            return false;
        }
        if (!M.equals(point, pointInLine, precision)) {
            double distance = M.distance(point, pointInLine);
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (M.equals(firstEndOfSegment.xyz[i], secondEndOfSegment.xyz[i], precision)) continue;
            if (firstEndOfSegment.xyz[i] > secondEndOfSegment.xyz[i]) {
                return secondEndOfSegment.xyz[i] <= pointInLine.xyz[i] && pointInLine.xyz[i] <= firstEndOfSegment.xyz[i];
            }
            return secondEndOfSegment.xyz[i] >= pointInLine.xyz[i] && pointInLine.xyz[i] >= firstEndOfSegment.xyz[i];
        }
        return false;
    }

    public static boolean inSegmentNotEnd(Segment3D s, Tuple3D point) {
        return M.inSegmentNotEnd(s.ab[0], s.ab[1], s.line, point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Segment3D s, Tuple3D point, double precision) {
        return M.inSegmentNotEnd(s.ab[0], s.ab[1], s.line, point, precision);
    }

    public static boolean inSegmentNotEnd(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Tuple3D point) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, Line3D.line3D(firstEndOfSegment, secondEndOfSegment), point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Tuple3D point, double precision) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, Line3D.line3D(firstEndOfSegment, secondEndOfSegment), point, precision);
    }

    public static boolean inSegmentNotEnd(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Line3D segmentLine, Tuple3D point) {
        return M.inSegmentNotEnd(firstEndOfSegment, secondEndOfSegment, segmentLine, point, EPSILON);
    }

    public static boolean inSegmentNotEnd(Tuple3D firstEndOfSegment, Tuple3D secondEndOfSegment, Line3D segmentLine, Tuple3D point, double precision) {
        if (M.equals(firstEndOfSegment, point, precision)) {
            return false;
        }
        if (M.equals(secondEndOfSegment, point, precision)) {
            return false;
        }
        return M.inSegment(firstEndOfSegment, secondEndOfSegment, segmentLine, point, precision);
    }

    public static Tuple3D outsideVector(Triangle3D t, Segment3D s) {
        Tuple3D projectionToSegmentsLine;
        boolean[] endpointNotFound = new boolean[]{true, true};
        Vertex3D pointOutsideSegment = null;
        for (int i = 0; i < 3; ++i) {
            if (endpointNotFound[0] && t.vertices[i].equals(s.ab[0])) {
                endpointNotFound[0] = false;
                continue;
            }
            if (endpointNotFound[1] && t.vertices[i].equals(s.ab[1])) {
                endpointNotFound[1] = false;
                continue;
            }
            pointOutsideSegment = t.vertices[i];
            break;
        }
        if ((projectionToSegmentsLine = M.project(pointOutsideSegment, s.line, t.plane)) == null) {
            return null;
        }
        return new Tuple3D(projectionToSegmentsLine, pointOutsideSegment).normalize();
    }

    public static Tuple3D intersection(Line3D line1, Line3D line2) {
        int j;
        int i;
        Tuple3D[] directions = new Tuple3D[]{new Tuple3D(line1.direction).normalize(), new Tuple3D(line2.direction).normalize()};
        Line3D[] lines = new Line3D[]{line1, line2};
        int[] other = new int[]{1, 0};
        boolean[][] nonZero = new boolean[][]{{true, true, true}, {true, true, true}};
        Double[] tr = new Double[]{null, null};
        double[] used = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                if (!M.equals(directions[j].xyz[i], 0.0)) continue;
                nonZero[j][i] = false;
            }
            if (!nonZero[0][i] && !nonZero[1][i]) {
                double distance = Math.abs(lines[0].point.xyz[i] - lines[1].point.xyz[i]);
                if (M.equals(lines[0].point.xyz[i], lines[1].point.xyz[i]) || M.equals(lines[0].point.xyz[i], lines[1].point.xyz[i], 1.0E-5)) continue;
                return null;
            }
            if (!nonZero[0][i]) {
                if (Math.abs(directions[1].xyz[i]) < 0.001 || !(Math.abs(directions[1].xyz[i]) > Math.abs(used[1]))) continue;
                tr[1] = (lines[0].point.xyz[i] - lines[1].point.xyz[i]) / directions[1].xyz[i];
                used[1] = directions[1].xyz[i];
                continue;
            }
            if (nonZero[1][i] || Math.abs(directions[0].xyz[i]) < 0.001 || !(Math.abs(directions[0].xyz[i]) > Math.abs(used[0]))) continue;
            tr[0] = (lines[1].point.xyz[i] - lines[0].point.xyz[i]) / directions[0].xyz[i];
            used[0] = directions[0].xyz[i];
        }
        if (tr[0] == null || tr[1] == null) {
            if (tr[0] == null && tr[1] == null) {
                int[] indexes = new int[]{-1, -1};
                double[] max = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
                int[][] others = new int[][]{{1, 2}, {0, 2}, {0, 1}};
                for (i = 0; i < 3; ++i) {
                    if (nonZero[0][i] || nonZero[1][i]) continue;
                    indexes = others[i];
                    break;
                }
                if (indexes[0] == -1) {
                    indexes[0] = 0;
                    max[0] = directions[0].xyz[0];
                    for (i = 1; i < 3; ++i) {
                        if (!(Math.abs(directions[0].xyz[i]) > Math.abs(max[0]))) continue;
                        indexes[0] = i;
                        max[0] = directions[0].xyz[i];
                    }
                    i = Math.abs(directions[0].xyz[indexes[0]]) < Math.abs(directions[1].xyz[indexes[0]]) ? 0 : 1;
                    for (j = 0; j < 3; ++j) {
                        if (j == indexes[0] || !(Math.abs(directions[i].xyz[j]) > Math.abs(max[1]))) continue;
                        indexes[1] = j;
                        max[1] = directions[i].xyz[j];
                    }
                }
                if (indexes[0] == -1 || indexes[1] == -1) {
                    ErrorLog.add("M.intersection(Line3D, Line3D): fatal error - indexes not found.", 3);
                    return null;
                }
                double[] ab = M.linearEq2(directions[0].xyz[indexes[0]], -directions[1].xyz[indexes[0]], line2.point.xyz[indexes[0]] - line1.point.xyz[indexes[0]], directions[0].xyz[indexes[1]], -directions[1].xyz[indexes[1]], line2.point.xyz[indexes[1]] - line1.point.xyz[indexes[1]]);
                if (ab == null) {
                    if (M.vectorEquals(directions[0], directions[1])) {
                        return null;
                    }
                    return null;
                }
                tr[0] = ab[0];
                tr[1] = ab[1];
            } else {
                int index = 0;
                for (i = 0; i < 2; ++i) {
                    if (tr[i] != null) continue;
                    double max = directions[i].xyz[0];
                    for (j = 1; j < 3; ++j) {
                        if (!(Math.abs(directions[i].xyz[j]) > Math.abs(max))) continue;
                        index = j;
                        max = directions[i].xyz[j];
                    }
                    tr[i] = (lines[other[i]].point.xyz[index] + directions[other[i]].xyz[index] * tr[other[i]] - lines[i].point.xyz[index]) / directions[i].xyz[index];
                    used[i] = directions[i].xyz[index];
                }
            }
        }
        double distance = Double.POSITIVE_INFINITY;
        Tuple3D[] points = new Tuple3D[]{null, null};
        if (tr[0] != null && tr[1] != null) {
            for (i = 0; i < 2; ++i) {
                points[i] = new Tuple3D(lines[i].point.xyz[0] + directions[i].xyz[0] * tr[i], lines[i].point.xyz[1] + directions[i].xyz[1] * tr[i], lines[i].point.xyz[2] + directions[i].xyz[2] * tr[i]);
            }
            distance = M.distance(points[0], points[1]);
            if (distance < 1.0E-5) {
                Tuple3D result = M.multi(M.plus(points[0], points[1]), 0.5);
                return result;
            }
        }
        return null;
    }

    public static boolean isTriangle(Tuple3D a, Tuple3D b, Tuple3D c) {
        return !M.isCollinear(a, b, c);
    }

    public static boolean planeIntersect(Plane3D a, Plane3D b) {
        Tuple3D n1 = a.normal;
        Tuple3D n2 = b.normal;
        return Math.abs(n1.xyz[0] * n2.xyz[1] - n1.xyz[1] * n2.xyz[0]) >= EPSILON;
    }

    public static Line3D intersection(Plane3D a, Plane3D b) {
        double az;
        Tuple3D lineNormal = M.multi(a.normal, b.normal);
        double ax = lineNormal.xyz[0] >= 0.0 ? lineNormal.xyz[0] : -lineNormal.xyz[0];
        double ay = lineNormal.xyz[1] >= 0.0 ? lineNormal.xyz[1] : -lineNormal.xyz[1];
        double d = az = lineNormal.xyz[2] >= 0.0 ? lineNormal.xyz[2] : -lineNormal.xyz[2];
        if (ax + ay + az < EPSILON) {
            return null;
        }
        int maxCoordinate = ax > ay ? (ax > az ? 1 : 3) : (ay > az ? 2 : 3);
        Tuple3D linePoint = new Tuple3D();
        double d1 = -M.multiScalar(a.normal, a.getCommonPoint());
        double d2 = -M.multiScalar(b.normal, b.getCommonPoint());
        switch (maxCoordinate) {
            case 1: {
                linePoint.xyz[0] = 0.0;
                linePoint.xyz[1] = (d2 * a.normal.xyz[2] - d1 * b.normal.xyz[2]) / lineNormal.xyz[0];
                linePoint.xyz[2] = (d1 * b.normal.xyz[1] - d2 * a.normal.xyz[1]) / lineNormal.xyz[0];
                break;
            }
            case 2: {
                linePoint.xyz[0] = (d1 * b.normal.xyz[2] - d2 * a.normal.xyz[2]) / lineNormal.xyz[1];
                linePoint.xyz[1] = 0.0;
                linePoint.xyz[2] = (d2 * a.normal.xyz[0] - d1 * b.normal.xyz[0]) / lineNormal.xyz[1];
                break;
            }
            case 3: {
                linePoint.xyz[0] = (d2 * a.normal.xyz[1] - d1 * b.normal.xyz[1]) / lineNormal.xyz[2];
                linePoint.xyz[1] = (d1 * b.normal.xyz[0] - d2 * a.normal.xyz[0]) / lineNormal.xyz[2];
                linePoint.xyz[2] = 0.0;
            }
        }
        return new Line3D(lineNormal, linePoint);
    }

    public static Tuple3D project(Tuple3D point, Line3D line) {
        double t = (line.direction.xyz[0] * point.xyz[0] + line.direction.xyz[1] * point.xyz[1] + line.direction.xyz[2] * point.xyz[2] - line.direction.xyz[0] * line.point.xyz[0] - line.direction.xyz[1] * line.point.xyz[1] - line.direction.xyz[2] * line.point.xyz[2]) / line.direction.sqrLength();
        return M.plus(line.point, M.multi(line.direction, t));
    }

    public static Tuple3D project(Tuple3D point, Plane3D plane) {
        double t = (-plane.t4d.xyzd[3] - plane.normal.xyz[0] * point.xyz[0] - plane.normal.xyz[1] * point.xyz[1] - plane.normal.xyz[2] * point.xyz[2]) / plane.normal.sqrLength();
        return new Tuple3D(point.xyz[0] + plane.normal.xyz[0] * t, point.xyz[1] + plane.normal.xyz[1] * t, point.xyz[2] + plane.normal.xyz[2] * t);
    }

    public static Tuple3D project(Tuple3D pointInPlane, Line3D lineInPlane, Plane3D plane) {
        return M.intersection(lineInPlane, new Line3D(M.multi(plane.normal, lineInPlane.direction), pointInPlane));
    }

    public static Tuple3D[] normalizedOrder(Tuple3D a, Tuple3D b) {
        for (int i = 0; i < 3; ++i) {
            if (M.equals(a.xyz[i], b.xyz[i])) continue;
            if (a.xyz[i] > b.xyz[i]) {
                return new Tuple3D[]{a, b};
            }
            return new Tuple3D[]{b, a};
        }
        return null;
    }

    public static Vertex3D[] normalizedOrder(Vertex3D a, Vertex3D b) {
        for (int i = 0; i < 3; ++i) {
            if (M.equals(a.xyz[i], b.xyz[i])) continue;
            if (a.xyz[i] > b.xyz[i]) {
                return new Vertex3D[]{a, b};
            }
            return new Vertex3D[]{b, a};
        }
        return null;
    }

    public static boolean sameSide(Tuple3D vertex1, Tuple3D vertex2, Plane3D plane) {
        double d1 = M.distanceSigned(vertex1, plane);
        double d2 = M.distanceSigned(vertex2, plane);
        double v1 = plane.normal.xyz[0] * vertex1.xyz[0] + plane.normal.xyz[1] * vertex1.xyz[1] + plane.normal.xyz[2] * vertex1.xyz[2];
        double v2 = plane.normal.xyz[0] * vertex2.xyz[0] + plane.normal.xyz[1] * vertex2.xyz[1] + plane.normal.xyz[2] * vertex2.xyz[2];
        if (M.equals(v1, 0.0)) {
            System.out.println("Problem...");
        }
        if (M.equals(v2, 0.0)) {
            System.out.println("Problem...");
        }
        return v1 > 0.0 && v2 > 0.0 || v1 < 0.0 && v2 < 0.0;
    }

    public static double distance(Line3D line, Tuple3D point) {
        Plane3D plane = new Plane3D(line.direction, point);
        Tuple3D project = M.intersection(plane, line);
        return M.distance(point, project);
    }

    public static Tuple3D intersection(Plane3D plane, Line3D line) {
        Tuple3D direction = line.direction;
        if (M.equals(direction.length(), 0.0)) {
            direction = M.normalizedNormal(line.direction);
        }
        if (M.equals(direction.length(), 0.0)) {
            return null;
        }
        if (M.equals(M.multiScalar(direction, plane.normal), 0.0)) {
            return null;
        }
        double t = (-plane.t4d.xyzd[0] * line.point.xyz[0] - plane.t4d.xyzd[1] * line.point.xyz[1] - plane.t4d.xyzd[2] * line.point.xyz[2] - plane.t4d.xyzd[3]) / (plane.t4d.xyzd[0] * direction.xyz[0] + plane.t4d.xyzd[1] * direction.xyz[1] + plane.t4d.xyzd[2] * direction.xyz[2]);
        Tuple3D result = new Tuple3D(line.point.xyz[0] + t * direction.xyz[0], line.point.xyz[1] + t * direction.xyz[1], line.point.xyz[2] + t * direction.xyz[2]);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("pi/4   = 0.7853981633974483 rad = " + M.deg(0.7853981633974483) + " deg");
        System.out.println("45 deg = " + M.rad(45.0) + " rad");
        Tuple2D t2d1 = new Tuple2D(0.0, 0.0);
        Line2D l2d1 = Line2D.line2D(new Tuple2D(1.0, 0.0), new Tuple2D(1.0, 1.0));
        System.out.println("Distance(" + t2d1 + ", " + l2d1 + ") = " + M.distance(t2d1, l2d1));
        Tuple2D t2d2 = new Tuple2D(2.0, 2.0);
        System.out.println("Distance(" + t2d1 + ", " + t2d2 + ") = " + M.distance(t2d1, t2d2));
        Tuple3D t3d1 = new Tuple3D(0.0, 0.0, 0.0);
        Plane3D p3d1 = new Plane3D(new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(1.0, 1.0, 1.0));
        System.out.println("SignedDistance(" + t3d1 + ", " + p3d1 + ") = " + M.distanceSigned(t3d1, p3d1));
        Tuple3D t3d2 = new Tuple3D(1.0, 1.0, 1.0);
        Tuple3D t3d3 = new Tuple3D(0.5, 0.5, 0.5);
        Tuple3D t3d4 = new Tuple3D(1.0, 0.0, 1.0);
        System.out.println("Project(" + t3d3 + " into [" + t3d1 + ", " + t3d2 + "] = " + M.project(t3d3, Line3D.line3D(t3d1, t3d2)));
        System.out.println("Project(" + t3d1 + ", " + p3d1 + ") = " + M.project(t3d1, p3d1));
        System.out.println("Are collinear? " + t3d1 + ", " + t3d2 + ", " + t3d3 + " = " + M.isCollinear(t3d1, t3d2, t3d3));
        System.out.println("Are collinear? " + t3d1 + ", " + t3d2 + ", " + t3d4 + " = " + M.isCollinear(t3d1, t3d2, t3d4));
        System.out.println("InSegment? " + t3d3 + " in [" + t3d1 + ", " + t3d2 + "] = " + M.inSegment(t3d1, t3d2, t3d3));
        System.out.println("InSegment? " + t3d4 + " in [" + t3d1 + ", " + t3d2 + "] = " + M.inSegment(t3d1, t3d2, t3d4));
        Plane3D p3d2 = new Plane3D(new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(1.0, 1.0, 1.0));
        Plane3D p3d3 = new Plane3D(new Tuple3D(-2.0, 0.0, 0.0), new Tuple3D(1.0, 3.0, 3.0));
        Plane3D p3d4 = new Plane3D(new Tuple3D(1.0, 1.0, 1.0), new Tuple3D(0.0, 1.0, 0.0));
        System.out.println("Equals(" + p3d2 + ", " + p3d3 + ") = " + M.equals(p3d2, p3d3));
        System.out.println("Equals(" + p3d2 + ", " + p3d4 + ") = " + M.equals(p3d2, p3d4));
        System.out.println("Equals(" + p3d3 + ", " + p3d4 + ") = " + M.equals(p3d3, p3d4));
        Tuple2D p2d1 = new Tuple2D(1.0, 1.0);
        Tuple2D p2d2 = new Tuple2D(2.0, 2.0);
        Tuple2D p2d3 = new Tuple2D(3.0, 3.0);
        Tuple2D p2d4 = new Tuple2D(-1.0, -1.0);
        Line2D l2d2 = new Line2D(new Tuple2D(p2d2, p2d1), p2d1);
        System.out.println("Coeficient(" + l2d2 + ", " + p2d1 + ", " + p2d3 + ") = " + M.coeficient(l2d2, p2d1, p2d3));
        System.out.println("Coeficient(" + l2d2 + ", " + p2d1 + ", " + p2d4 + ") = " + M.coeficient(l2d2, p2d1, p2d4));
        System.out.println("Intersection(" + l2d1 + ", " + l2d2 + ") = " + M.intersection(l2d1, l2d2));
        Triangle3D tri3d1 = new Triangle3D(new Vertex3D(0.0, 0.0, 0.0), new Vertex3D(2.0, 3.0, 0.0), new Vertex3D(1.0, 3.0, 0.0));
        Segment3D seg3d1 = new Segment3D(new Vertex3D(1.0, 3.0, 0.0), new Vertex3D(2.0, 3.0, 0.0));
        Tuple3D pointInTri3d1 = new Tuple3D(0.0, 0.0, 0.0);
        System.out.println("Project(" + pointInTri3d1 + ", " + seg3d1 + ", " + tri3d1 + ") = " + M.project(pointInTri3d1, seg3d1.line, tri3d1.plane));
        Plane3D p3d5 = new Plane3D(new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(0.0, 0.0, 0.0));
        Plane3D p3d6 = new Plane3D(new Tuple3D(0.0, 1.0, 0.0), new Tuple3D(0.0, 0.0, 0.0));
        Plane3D p3d7 = new Plane3D(new Tuple3D(0.0, 0.0, 1.0), new Tuple3D(0.0, 0.0, 0.0));
        System.out.println("Intersection(" + p3d5 + ", " + p3d6 + ") = " + M.intersection(p3d5, p3d6));
        System.out.println("Intersection(" + p3d5 + ", " + p3d7 + ") = " + M.intersection(p3d5, p3d7));
        System.out.println("Intersection(" + p3d6 + ", " + p3d7 + ") = " + M.intersection(p3d6, p3d7));
        Line3D l3d1 = Line3D.line3D(new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(0.0, 1.0, 0.0));
        Tuple3D t3d6 = new Tuple3D(0.0, 0.0, 1.0);
        System.out.println("Project(" + t3d6 + ", " + l3d1 + "): " + M.project(t3d6, l3d1));
    }
}

