/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;

public class HalfLine2D {
    public Tuple2D pointBegin;
    public Tuple2D pointDirection;
    public Tuple2D direction;

    public HalfLine2D(Tuple2D iPointBegin, Tuple2D iPointDirection) {
        this.pointBegin = iPointBegin;
        this.pointDirection = iPointDirection;
        this.direction = new Tuple2D(iPointDirection, iPointBegin).normalize();
    }

    public String toString() {
        return "HalfLine2D(" + this.pointBegin + ", " + this.pointDirection + ")";
    }

    public boolean inHalfLine(Tuple2D testedPoint) {
        return this.inHalfLine(testedPoint, M.EPSILON);
    }

    public boolean inHalfLine(Tuple2D testedPoint, double precision) {
        if (!M.equals(this.direction.xy[0], 0.0)) {
            double t = M.linearEq(this.direction.xy[0], this.pointBegin.xy[0], testedPoint.xy[0]);
            if (t < 0.0) {
                return false;
            }
            double y = this.direction.xy[1] * t + this.pointBegin.xy[1];
            return M.equals(testedPoint.xy[1], y, precision);
        }
        if (!M.equals(this.direction.xy[1], 0.0)) {
            double t = M.linearEq(this.direction.xy[1], this.pointBegin.xy[1], testedPoint.xy[1]);
            if (t < 0.0) {
                return false;
            }
            double x = this.direction.xy[0] * t + this.pointBegin.xy[0];
            return M.equals(testedPoint.xy[0], x, precision);
        }
        return false;
    }
}

