/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.FloydWarshallMap;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.utils.LoggerManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;

public class TestBot
extends Agent {
    FloydWarshallMap map;
    private List<NavPoint> path = null;
    private NavPoint currentNavPoint = null;
    private int velocityZero = 0;

    public TestBot() {
        LoggerManager.instance.setLevelToAll(Level.ALL);
        this.log.setLevel(Level.ALL);
        this.platformLog.setLevel(Level.ALL);
    }

    protected void prePrepareAgent() {
    }

    protected void postPrepareAgent() {
        this.map = new FloydWarshallMap(this.memory.getKnownNavPoints(), this.log);
    }

    private boolean stuckCheck(Triple target) {
        this.velocityZero = this.memory.getAgentVelocity().vectorSize() < 1.0E-4 ? ++this.velocityZero : 0;
        return this.velocityZero > 3;
    }

    private void initPath() {
        this.path = null;
        NavPoint at = this.gameMap.nearestNavPoint(this.memory.getAgentLocation());
        while (this.path == null || this.path.size() < 1) {
            NavPoint np = this.memory.getKnownNavPoints().get(this.random.nextInt(this.memory.getKnownNavPoints().size()));
            this.path = this.map.getPath(at, np);
        }
        System.out.println("Running " + at.UnrealID + " -> " + this.path.get((int)(this.path.size() - 1)).UnrealID);
        this.nextNavPoint();
    }

    private boolean nextNavPoint() {
        if (this.path.size() == 0) {
            return false;
        }
        this.currentNavPoint = this.path.get(0);
        System.out.println("Running to " + this.currentNavPoint);
        this.path.remove(0);
        return true;
    }

    private boolean atLocation(Triple loc) {
        return Triple.distanceInSpace(this.memory.getAgentLocation(), loc) < 80.0;
    }

    private void followPath() {
        if (this.path == null) {
            this.initPath();
        }
        if (this.stuckCheck(this.currentNavPoint.getLocation())) {
            System.out.println("Stucked!!!");
            this.initPath();
        }
        if (this.atLocation(this.currentNavPoint.getLocation()) && !this.nextNavPoint()) {
            this.initPath();
        }
        this.body.runToNavPoint(this.currentNavPoint);
    }

    protected void doLogic() {
        this.followPath();
        System.out.println("Location: " + this.memory.getAgentLocation());
    }

    public static void main(String[] Args) throws URISyntaxException, InterruptedException {
        int NUM_BOTS = 1;
        for (int i = 0; i < NUM_BOTS; ++i) {
            TestBot bot = new TestBot();
            AgentLauncher agent = new AgentLauncher(bot, new URI("ut://localhost:3000"), true);
            agent.launch();
        }
    }
}

