/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.ConfigChange;
import cz.cuni.pogamut.MessageObjects.DummyMessage;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.GamePaused;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemCathegories;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerJoinsGame;
import cz.cuni.pogamut.MessageObjects.PlayerLeft;
import cz.cuni.pogamut.MessageObjects.UTMap;
import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.Parser.Parser;
import cz.cuni.pogamut.Parser.UnrealIDMap;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.communication.Mediator;
import cz.cuni.pogamut.communication.MediatorClientInterface;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantReadException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.UTServerConnectionReinitialization;
import cz.cuni.pogamut.exceptions.UTServerConnectionTerminationRequested;
import cz.cuni.pogamut.server.UTServerConnectionInterface;
import cz.cuni.pogamut.server.UTServerInfoSnapshot;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.pogamut.server.requests.UTServerRequest;
import cz.cuni.pogamut.server.requests.UTServerRequestConfigChange;
import cz.cuni.pogamut.server.requests.UTServerRequestInner;
import cz.cuni.pogamut.server.requests.UTServerRequestInventory;
import cz.cuni.pogamut.server.requests.UTServerRequestItems;
import cz.cuni.pogamut.server.requests.UTServerRequestMapChange;
import cz.cuni.pogamut.server.requests.UTServerRequestMaps;
import cz.cuni.pogamut.server.requests.UTServerRequestNavPoints;
import cz.cuni.pogamut.server.requests.UTServerRequestReconnect;
import cz.cuni.pogamut.server.requests.UTServerRequestTermination;
import cz.cuni.pogamut.server.requests.UTServerRequestType;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTServerConnection
implements Runnable,
MediatorClientInterface,
FlagListener {
    private static final UTServerRequest requestPingPong = new UTServerRequestInner("Test connection with ping-pong.");
    private static final UTServerRequest requestAutoReconnect = new UTServerRequestInner("Testing auto-reconnect.");
    private static final UTServerRequest messagePoll = new UTServerRequestInner("Processing message from GB.");
    private static final UTServerRequest waitingInfinite = new UTServerRequestInner("Waiting for request / message / time INFINITE.");
    private static final UTServerRequest waitingBounded = new UTServerRequestInner("Waiting for request / message / time BOUNDED.");
    private static final UTServerRequest nothing = new UTServerRequestInner("Nothing.");
    private static final long INFINITE_WAIT = -1L;
    private static final long NO_WAIT = 0L;
    private static final int COMMUNICATION_FLAG_LISTENER = 1;
    private static final int MAX_MAP_RECONNECT_ATTEMPTS = 5;
    private static final int AFTER_SAME_MAP_WAIT_MILLIS = 1500;
    private UTServerConnectionInterface owner = null;
    private static int threadCounter = 0;
    private Flag<Boolean> threadAlive = new Flag<Boolean>(false);
    private Thread thread = null;
    private Logger gbRawDataLog = Logger.getAnonymousLogger();
    private Logger log = null;
    private boolean shouldRun = true;
    private boolean mapChanging = false;
    private int mapChangeReconnectAttempt = 0;
    private String previousMap = "";
    private Flag<UTServerRequest> currentRequestFlag = new Flag<UTServerRequestInner>(new UTServerRequestInner("Initializing."));
    private Object requestOrMessageLatchAccess = new Object();
    private CountDownLatch requestOrMessageLatch = new CountDownLatch(1);
    private URI currentUri = null;
    protected Set<RcvMsgListener> messageListeners = new HashSet<RcvMsgListener>();
    private BlockingQueue<UTServerRequest> requests = new LinkedBlockingQueue<UTServerRequest>();
    private BlockingQueue<String> commandsToGB = new LinkedBlockingQueue<String>();
    protected BlockingQueue<MessageObject> messagesFromGB = new LinkedBlockingQueue<MessageObject>();
    private GameBotConnection gameBotConnection = null;
    private Parser parser = null;
    private Mediator mediator = null;
    private boolean communicationShouldBeRunning = false;
    private boolean pingSent = false;
    private long lastPingSentMillis = -1L;
    private boolean pongReceived = false;
    private long lastReconnectTriedMillis = -1L;

    public UTServerConnection(UTServerConnectionInterface owner) {
        this.owner = owner;
        this.log = owner.getLog();
        this.log.setLevel(Level.FINE);
        this.request(new UTServerRequestReconnect());
        this.runThread();
    }

    public void addRcvMsgListener(RcvMsgListener listener) {
        this.messageListeners.add(listener);
    }

    public void removeRcvMsgListener(RcvMsgListener listener) {
        this.messageListeners.remove(listener);
    }

    private void setCurrentRequest(UTServerRequest request) {
        this.log.finer("Current request: " + request.toString());
        this.currentRequestFlag.setFlag(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean request(UTServerRequest request) {
        boolean result = false;
        BlockingQueue<UTServerRequest> blockingQueue = this.requests;
        synchronized (blockingQueue) {
            result = this.requests.add(request);
            this.log.info("Request added ... " + request.toString());
            this.requestOrMessageLatch.countDown();
        }
        return result;
    }

    public UTServerRequest getCurrentRequest() {
        return this.currentRequestFlag.getFlag();
    }

    public Flag<Boolean> getThreadAliveFlag() {
        return this.threadAlive;
    }

    public boolean isThreadAlive() {
        return this.threadAlive.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Thread runThread() {
        Flag<Boolean> flag = this.threadAlive;
        synchronized (flag) {
            if (this.threadAlive.getFlag().booleanValue()) {
                return null;
            }
            this.shouldRun = true;
            this.thread = new Thread((Runnable)this, "UTServerConnection " + threadCounter++);
        }
        this.thread.start();
        return this.thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.threadAlive;
        synchronized (object) {
            if (this.thread == null) {
                System.out.println("run() wasn't called from runThread(), this.thread == null, returning");
                return;
            }
            this.threadAlive.setFlag(true);
        }
        this.log.finest("Thread started.");
        this.request(new UTServerRequestReconnect());
        this.log.finest("Entering first while-cycle.");
        while (this.shouldRun) {
            try {
                this.log.finest("Entering second while-cycle.");
                while (this.shouldRun) {
                    this.threadIteration();
                }
            }
            catch (UTServerConnectionReinitialization e) {
                this.log.severe("Reinitialization requested, problem occured -> " + e.getMessage());
                this.reinitialize(true);
            }
            catch (Exception e) {
                this.logException(e);
                if (this.mapChanging) {
                    this.reinitialize(true);
                    continue;
                }
                this.reinitialize(false);
            }
        }
        this.setServerState(UTServerState.TERMINATED);
        this.stopCommunication();
        try {
            if (this.gameBotConnection != null) {
                this.gameBotConnection.close();
            }
        }
        catch (CantCloseConnectionException cantCloseConnectionException) {
            // empty catch block
        }
        this.gameBotConnection = null;
        this.threadAlive.setFlag(false);
        this.log.finest("Thread terminated.");
        object = this.thread;
        synchronized (object) {
            this.thread = null;
        }
    }

    private void logException(Exception e) {
        String requestOrigin;
        UTServerRequest request = this.getCurrentRequest();
        String requestString = request != null ? request.toString() : "null";
        String string = requestOrigin = request != null ? request.getOrigin() : "null";
        if (e != null) {
            this.log.severe(ExceptionToString.process("While processing request '" + requestString + "' from '" + requestOrigin + "' the exception occured. ", e));
        } else {
            this.log.severe("While processing request '" + requestString + "' from '" + requestOrigin + "' the exception occured. Exception: null.");
        }
    }

    private void setServerState(UTServerState serverState) {
        if (this.mapChanging) {
            switch (serverState) {
                case UNAVAILABLE: 
                case INITIALIZING: 
                case HANDSHAKE: {
                    return;
                }
            }
        }
        if (!this.owner.getServerState().equals((Object)serverState)) {
            this.log.info("Switching server state to " + serverState.toString() + ".");
        }
        this.owner.getServerStateFlag().setFlag(serverState);
    }

    private void communicationDied() {
        this.communicationShouldBeRunning = false;
        this.setServerState(UTServerState.UNAVAILABLE);
        this.clearServerInfo();
        this.reinitInnerVariables();
    }

    private void reinitInnerVariables() {
        this.pingSent = false;
        this.pongReceived = false;
        this.lastPingSentMillis = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearServerInfo() {
        UTServerInfoSnapshot uTServerInfoSnapshot = this.owner.getInfo();
        synchronized (uTServerInfoSnapshot) {
            this.owner.getInfo().gameInfo = null;
            this.owner.getInfo().navPoints = null;
            this.owner.getInfo().items = null;
            this.owner.getInfo().maps = null;
        }
    }

    public URI getCurrentURI() {
        return this.currentUri;
    }

    private void stopCommunication() {
        if (this.isCommunicationAlive()) {
            this.communicationShouldBeRunning = false;
            this.mediator.getCommunicationAliveFlag().removeListener(this, 1);
            this.mediator.stopMediator();
        }
        this.communicationDied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialize(boolean reconnect) {
        this.log.severe("Reinitializing the UTServerConnection, closing connections, cleaning queues.");
        if (this.isCommunicationAlive()) {
            this.stopCommunication();
            try {
                this.gameBotConnection.close();
            }
            catch (CantCloseConnectionException cantCloseConnectionException) {}
        } else {
            this.communicationDied();
        }
        this.mediator = null;
        this.parser = null;
        this.gameBotConnection = null;
        BlockingQueue<Object> blockingQueue = this.requests;
        synchronized (blockingQueue) {
            this.requests.clear();
            if (reconnect && this.owner.getGamebotsControlConnectionURI() != null) {
                this.requests.add(new UTServerRequestReconnect());
            }
            this.requestOrMessageLatch.countDown();
        }
        blockingQueue = this.commandsToGB;
        synchronized (blockingQueue) {
            this.commandsToGB.clear();
        }
        blockingQueue = this.messagesFromGB;
        synchronized (blockingQueue) {
            this.messagesFromGB.clear();
        }
        this.pingSent = false;
        this.lastPingSentMillis = -1L;
        this.pongReceived = false;
    }

    @Override
    public String receiveMessageFromClient() throws CantReadException {
        try {
            String msg = null;
            msg = this.commandsToGB.take();
            this.log.finest("NB --> GB: " + msg);
            return msg;
        }
        catch (InterruptedException e) {
            this.log.warning("InterruptedException in UTServerConnection.receiveMessageFromClient().");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessageToClient(MessageObject msg) throws CantWriteException {
        this.log.finest("NB <-- GB (adding request): " + msg.type.toString());
        this.preprocessGBMessage(msg);
        BlockingQueue<MessageObject> blockingQueue = this.messagesFromGB;
        synchronized (blockingQueue) {
            this.messagesFromGB.add(msg);
            this.requestOrMessageLatch.countDown();
        }
    }

    @Override
    public void closeClient() throws CantCloseConnectionException {
    }

    private boolean isCommunicationAlive() {
        return this.mediator != null && this.mediator.isCommunicationAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandToGB(String message) {
        BlockingQueue<String> blockingQueue = this.commandsToGB;
        synchronized (blockingQueue) {
            if (this.isCommunicationAlive()) {
                this.commandsToGB.add(message);
            }
        }
    }

    private MessageObject getBlockingMessageFromGB() throws CantReadException {
        MessageObject msg;
        try {
            msg = this.messagesFromGB.take();
        }
        catch (InterruptedException e) {
            throw new CantReadException("Interrupted in UTServerConnection.getBlockingMessageFromGB().");
        }
        if (msg.type == MessageType.DUMMY_MESSAGE) {
            if (((DummyMessage)msg).fatal) {
                throw new CantReadException("Got DUMMY MESSAGE, communication dead.");
            }
            return null;
        }
        return msg;
    }

    private MessageObject waitForResponse(MessageType type) throws CantReadException {
        MessageObject msg = null;
        UTServerRequest currentRequest = this.getCurrentRequest();
        this.setCurrentRequest(new UTServerRequestInner("Waiting for message of type " + type.toString()));
        while (true) {
            if ((msg = this.getBlockingMessageFromGB()) == null) {
                continue;
            }
            if (msg.type == type) break;
            this.log.warning("Unexpected type of message - " + msg.getType().toString() + ", expectin " + type.toString());
        }
        this.setCurrentRequest(currentRequest);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void threadIteration() throws Exception {
        this.log.finest("Next UTServerConnection thread iteration begins.");
        if (this.communicationShouldBeRunning) {
            if (!this.isCommunicationAlive()) throw new UTServerConnectionReinitialization("Communication died out.");
            this.doPingPong();
        } else {
            this.doAutomaticReconnect();
        }
        long maxWait = this.computeMaxWaiting();
        while (true) {
            boolean hasSomething = false;
            BlockingQueue<UTServerRequest> blockingQueue = this.requests;
            synchronized (blockingQueue) {
                BlockingQueue<MessageObject> blockingQueue2 = this.messagesFromGB;
                synchronized (blockingQueue2) {
                    boolean bl = hasSomething = this.requests.size() > 0 || this.messagesFromGB.size() > 0;
                    if (!hasSomething && this.requestOrMessageLatch.getCount() == 0L) {
                        this.requestOrMessageLatch = new CountDownLatch(1);
                    }
                }
            }
            if (hasSomething) {
                this.processRequestOrMessage();
                if (maxWait == 0L) {
                    return;
                }
            } else if (maxWait == -1L) {
                this.setCurrentRequest(waitingInfinite);
                this.requestOrMessageLatch.await();
            } else {
                if (maxWait <= 0L) return;
                this.setCurrentRequest(waitingBounded);
                this.requestOrMessageLatch.await(maxWait, TimeUnit.MILLISECONDS);
            }
            if (!this.isCommunicationAlive()) {
                throw new UTServerConnectionReinitialization("Communication died out.");
            }
            maxWait = this.computeMaxWaiting();
            this.setCurrentRequest(nothing);
        }
    }

    private void processRequestOrMessage() throws UnknownHostException, ConnectException, CantReadException, UTServerConnectionTerminationRequested, UTServerConnectionReinitialization {
        if (this.messagesFromGB.size() > 0) {
            this.processGBMessage();
        }
        if (this.requests.size() > 0) {
            this.processRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocessGBMessage(MessageObject msg) {
        GameInfo gameInfo = null;
        switch (msg.type) {
            case PONG: {
                this.pongReceived = true;
                break;
            }
            case MAP_FINISHED: {
                if (!this.mapChanging && this.communicationShouldBeRunning) {
                    this.mapChangeReconnectAttempt = 0;
                }
                this.mapChanging = true;
                this.setServerState(UTServerState.MAP_CHANGING);
                break;
            }
            case CONFIG_CHANGE: {
                Set<Player> set;
                ConfigChange conf = (ConfigChange)msg;
                UTServerInfoSnapshot uTServerInfoSnapshot = this.owner.getInfo();
                synchronized (uTServerInfoSnapshot) {
                    if (this.owner.getInfo().players == null) {
                        break;
                    }
                    set = this.owner.getInfo().players;
                    synchronized (set) {
                        for (Player player : this.owner.getInfo().players) {
                            if (!player.UnrealID.equals(conf.UnrealID)) continue;
                            player.updateConfigChange(conf);
                            break;
                        }
                    }
                }
            }
            case PLAYER_JOIN: {
                Set<Player> set;
                UTServerInfoSnapshot uTServerInfoSnapshot = this.owner.getInfo();
                synchronized (uTServerInfoSnapshot) {
                    if (this.owner.getInfo().players == null) {
                        break;
                    }
                    set = this.owner.getInfo().players;
                    synchronized (set) {
                        boolean add = true;
                        for (Player player : this.owner.getInfo().players) {
                            if (!player.UnrealID.equals(msg.UnrealID)) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            this.owner.getInfo().players.add(new Player((PlayerJoinsGame)msg));
                        }
                    }
                }
            }
            case PLAYER_LEFT: {
                Set<Player> set;
                UTServerInfoSnapshot uTServerInfoSnapshot = this.owner.getInfo();
                synchronized (uTServerInfoSnapshot) {
                    if (this.owner.getInfo().players == null) {
                        break;
                    }
                    set = this.owner.getInfo().players;
                    synchronized (set) {
                        PlayerLeft left = (PlayerLeft)msg;
                        ArrayList<Player> toBeRemoved = new ArrayList<Player>();
                        for (Player player : this.owner.getInfo().players) {
                            if (!player.UnrealID.equals(msg.UnrealID)) continue;
                            toBeRemoved.add(player);
                        }
                        this.owner.getInfo().players.removeAll(toBeRemoved);
                        this.log.severe("PlayerLeft came (" + msg.UnrealID + ") but bot not found in players.");
                    }
                }
            }
            case GAME_PAUSED: {
                GamePaused paused = (GamePaused)msg;
                Set<Player> set = this.owner.getInfo();
                synchronized (set) {
                    gameInfo = this.owner.getGameInfo();
                    gameInfo.gamePaused = true;
                }
                this.setServerState(UTServerState.PAUSED);
                break;
            }
            case GAME_RESUMED: {
                Set<Player> set = this.owner.getInfo();
                synchronized (set) {
                    gameInfo = this.owner.getInfo().gameInfo;
                    gameInfo.gamePaused = false;
                    gameInfo.botsPaused = false;
                }
                this.setServerState(UTServerState.RUNNING);
            }
        }
        RcvMsgEvent event = new RcvMsgEvent(this, msg, CommunicationState.BOT_RUNNING);
        for (RcvMsgListener listener : this.messageListeners) {
            listener.receiveMessage(event);
        }
    }

    private long computeMaxWaiting() {
        if (this.isCommunicationAlive()) {
            if (this.owner.isPingPong()) {
                long time = (long)this.owner.getPongTimeoutMillis() - (System.currentTimeMillis() - this.lastPingSentMillis);
                if (time < 0L) {
                    return 0L;
                }
                return time;
            }
            return -1L;
        }
        if (this.owner.isAutomaticallyReconnect()) {
            long time = (long)this.owner.getAutoReconnectMillis() - (System.currentTimeMillis() - this.lastReconnectTriedMillis);
            if (time < 0L) {
                return 0L;
            }
            return time;
        }
        return -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doPingPong() throws Exception {
        if (this.owner.isPingPong()) {
            this.setCurrentRequest(requestPingPong);
            if (this.pingSent) {
                long diff = System.currentTimeMillis() - this.lastPingSentMillis;
                if (diff <= (long)this.owner.getPongTimeoutMillis()) return;
                if (!this.pongReceived) throw new UTServerConnectionReinitialization("PONG not received after " + diff + " millis, reconnecting.");
                this.pongReceived = false;
                this.pingSent = false;
                return;
            } else {
                this.gameBotConnection.send("PING");
                this.pingSent = true;
                this.lastPingSentMillis = System.currentTimeMillis();
            }
            return;
        } else {
            this.pingSent = false;
            this.lastPingSentMillis = -1L;
            this.pongReceived = false;
        }
    }

    private void doAutomaticReconnect() throws UnknownHostException, ConnectException, CantReadException, UTServerConnectionReinitialization {
        if (this.isCommunicationAlive()) {
            return;
        }
        if (this.owner.isAutomaticallyReconnect()) {
            this.setCurrentRequest(requestAutoReconnect);
            long diff = System.currentTimeMillis() - this.lastReconnectTriedMillis;
            if (diff > (long)this.owner.getAutoReconnectMillis()) {
                this.lastReconnectTriedMillis = System.currentTimeMillis();
                this.connectToGB();
            }
        } else {
            this.lastReconnectTriedMillis = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToGB() throws UnknownHostException, ConnectException, CantReadException, UTServerConnectionReinitialization {
        GameInfo gameInfo;
        if (this.isCommunicationAlive()) {
            this.log.warning("Communication is alive but connectToGB() called.");
            return;
        }
        this.clearServerInfo();
        URI serverUri = this.owner.getGamebotsControlConnectionURI();
        if (serverUri == null) {
            if (this.mapChanging) {
                this.mapChanging = false;
                this.mapChangeReconnectAttempt = 0;
                this.previousMap = "";
            }
            throw new UnknownHostException("serverUri is null");
        }
        this.setServerState(UTServerState.INITIALIZING);
        this.gameBotConnection = new GameBotConnection(serverUri.getHost(), serverUri.getPort() == -1 ? 3001 : serverUri.getPort(), Logger.getAnonymousLogger(), this.owner.getRawGBLog());
        this.gameBotConnection.connect();
        UnrealIDMap idMap = new UnrealIDMap();
        this.log.fine("Creating parser for UTServerConnection.");
        this.parser = new Parser(this.gameBotConnection, idMap, this.log);
        this.parser.dontDiff = true;
        this.log.fine("Creating communication mediator for UTServerConnection.");
        this.mediator = new Mediator(this, this.parser, this.parser, this.log);
        this.setServerState(UTServerState.HANDSHAKE);
        this.mediator.getCommunicationAliveFlag().addListener(this, 1);
        this.mediator.startMediator();
        this.communicationShouldBeRunning = true;
        this.log.fine("Waiting for mediator to set up.");
        this.mediator.waitForCommunication();
        this.log.fine("Checking communication status.");
        if (!this.mediator.isCommunicationAlive()) {
            this.log.severe("Communication is DEAD.");
            this.setServerState(UTServerState.UNAVAILABLE);
            throw new ConnectException("Connection died out.");
        }
        this.log.fine("Communication OK.");
        this.log.info("ServerConnection handshake...");
        MessageObject msg = null;
        while (true) {
            if ((msg = this.getBlockingMessageFromGB()) == null) {
                this.log.warning("Unexpected NULL message in handshake.");
                continue;
            }
            if (msg.type == MessageType.MAP_FINISHED) {
                this.mapFinishedMessageCame();
            }
            if (msg.type == this.owner.getExpectedWelcomeMessage()) break;
            this.log.warning("Unexpected message in handshake - " + msg.toString());
        }
        this.log.fine("Sending READY to GB.");
        this.sendCommandToGB("READY");
        if (this.owner.waitForNFOMessageInHandshake()) {
            this.log.info("Waiting for GAME INFO message.");
            while (true) {
                msg = this.getBlockingMessageFromGB();
                if (msg.type == MessageType.GAME_INFO) break;
                msg = this.getBlockingMessageFromGB();
                if (msg == null) {
                    this.log.warning("Unexpected NULL message - should be GAME INFO.");
                    continue;
                }
                if (msg.type == MessageType.MAP_FINISHED) {
                    this.mapFinishedMessageCame();
                }
                if (msg.type == MessageType.GAME_INFO) break;
                this.log.warning("Unexpected message - " + msg.toString() + " - should be GAME INFO.");
            }
            gameInfo = (GameInfo)msg;
            this.owner.setGameInfo(gameInfo);
        } else {
            gameInfo = new GameInfo();
            gameInfo.level = String.valueOf(Math.random());
            gameInfo.gamePaused = false;
            gameInfo.botsPaused = false;
            this.owner.setGameInfo(gameInfo);
        }
        if (this.mapChanging) {
            String currentMap = this.owner.getInfo().gameInfo.level;
            if (this.mapChangeReconnectAttempt < 5) {
                if (this.previousMap.compareToIgnoreCase(currentMap) == 0) {
                    this.log.warning("Map is still '" + currentMap + "', waiting for " + 1500 + " ms and reconnect.");
                    ++this.mapChangeReconnectAttempt;
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        this.log.severe("Interrupted from sleep...");
                    }
                    throw new UTServerConnectionReinitialization("Reconnecting, map's still changing.");
                }
            } else {
                this.log.warning("Map is still '" + currentMap + "', but we've given GB enough time to reinitialize, assuming the GB did not change the map.");
                this.mapChanging = false;
                this.mapChangeReconnectAttempt = 0;
                this.previousMap = "";
            }
        }
        this.loadAvailableMaps(true);
        this.loadPlayers();
        this.loadNavPoints(true);
        this.loadItems(true);
        this.loadInventory(true);
        this.currentUri = serverUri;
        if (this.owner.getGameInfo().gamePaused || this.owner.getGameInfo().botsPaused) {
            this.setServerState(UTServerState.PAUSED);
        } else {
            this.setServerState(UTServerState.RUNNING);
        }
        this.previousMap = "";
        this.mapChanging = false;
        BlockingQueue<UTServerRequest> blockingQueue = this.requests;
        synchronized (blockingQueue) {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                UTServerRequest request = (UTServerRequest)iterator.next();
                if (request.getType() != UTServerRequestType.RECONNECT_IF_DOWN && request.getType() != UTServerRequestType.RECONNECT_FORCED) continue;
                iterator.remove();
            }
        }
    }

    private void processGBMessage() {
        this.setCurrentRequest(messagePoll);
        if (this.messagesFromGB.size() > 0) {
            this.messagesFromGB.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() throws UTServerConnectionTerminationRequested, UnknownHostException, ConnectException, CantReadException, UTServerConnectionReinitialization {
        UTServerRequest request = null;
        BlockingQueue<UTServerRequest> blockingQueue = this.requests;
        synchronized (blockingQueue) {
            if (this.requests.size() > 0) {
                try {
                    request = this.requests.poll(0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (request != null) {
            this.setCurrentRequest(request);
            block3 : switch (request.getType()) {
                case RECONNECT_FORCED: {
                    this.reinitialize(true);
                    break;
                }
                case RECONNECT_IF_DOWN: {
                    if (this.isCommunicationAlive()) break;
                    this.connectToGB();
                    break;
                }
                case CONFIGURATION_CHANGE: {
                    UTServerRequestConfigChange change = (UTServerRequestConfigChange)request;
                    switch (change.getParameter()) {
                        case URI: {
                            URI newUri = (URI)change.getValue();
                            if (newUri != null) {
                                if (newUri.equals(this.currentUri)) break;
                                if (this.mapChanging) {
                                    this.mapChanging = false;
                                    this.mapChangeReconnectAttempt = 0;
                                    this.previousMap = "";
                                }
                                this.reinitialize(true);
                                break;
                            }
                            if (this.currentUri == null) break;
                            this.reinitialize(true);
                        }
                    }
                    break;
                }
                case TERMINATION_REQUEST: {
                    this.terminate();
                    throw new UTServerConnectionTerminationRequested("UTServerConnection termination requested.");
                }
                case REQUEST_PLAYERS: {
                    this.loadPlayers();
                    break;
                }
                case REQUEST_ITEMS: {
                    this.loadItems(((UTServerRequestItems)request).getForced());
                    break;
                }
                case REQUEST_MAPS: {
                    this.loadAvailableMaps(((UTServerRequestMaps)request).getForced());
                    break;
                }
                case REQUEST_NAVPOINTS: {
                    this.loadNavPoints(((UTServerRequestNavPoints)request).getForced());
                    break;
                }
                case REQUEST_INVENTORY: {
                    this.loadInventory(((UTServerRequestInventory)request).getForced());
                    break;
                }
                case MAP_CHANGE: {
                    String mapName = ((UTServerRequestMapChange)request).getMapName();
                    if (this.owner.getInfo().gameInfo != null && this.owner.getInfo().gameInfo.level.compareToIgnoreCase(mapName) == 0) break;
                    this.previousMap = this.owner.getInfo().gameInfo != null ? this.owner.getInfo().gameInfo.level : "";
                    this.sendCommandToGB("CHANGEMAP {MapName " + mapName + "}");
                    break;
                }
                case CONNECT: {
                    UTServerState state = this.owner.getServerState();
                    switch (state) {
                        case UNAVAILABLE: {
                            this.request(new UTServerRequestReconnect());
                            break block3;
                        }
                    }
                    break;
                }
                default: {
                    this.log.severe("Unhandled request: " + request.toString());
                }
            }
        }
    }

    protected void terminate() {
        this.shouldRun = false;
    }

    public synchronized void connect() {
        if (this.thread == null) {
            this.runThread();
        }
    }

    public void disconnect() {
        this.request(new UTServerRequestTermination());
    }

    private void loadInfoInner(String command, MessageType begin, MessageType info, MessageType end, Collection result) throws CantReadException {
        this.sendCommandToGB(command);
        this.waitForResponse(begin);
        MessageObject msg = null;
        while (true) {
            if ((msg = this.getBlockingMessageFromGB()) == null) {
                continue;
            }
            if (msg.type == end) break;
            if (msg.type != info) continue;
            result.add(msg);
        }
    }

    private Set<Player> loadPlayersInner() throws CantReadException {
        HashSet<Player> players = new HashSet<Player>();
        this.loadInfoInner("GETPLRS", MessageType.PLR_LIST_START, MessageType.PLAYER, MessageType.PLR_LIST_END, players);
        return players;
    }

    private List<NavPoint> loadNavPointsInner() throws CantReadException {
        ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
        this.loadInfoInner("GETNAVS", MessageType.NAV_LIST, MessageType.NAV_POINT, MessageType.NAV_LIST, navPoints);
        return navPoints;
    }

    private List<Item> loadItemsInner() throws CantReadException {
        ArrayList<Item> items = new ArrayList<Item>();
        this.loadInfoInner("GETINVS", MessageType.ITEM_LIST, MessageType.ITEM, MessageType.ITEM_LIST, items);
        return items;
    }

    private List<UTMap> loadAvailableMapsInner() throws CantReadException {
        ArrayList<UTMap> maps = new ArrayList<UTMap>();
        this.loadInfoInner("GETMAPS", MessageType.MAP_LIST_START, MessageType.MAP_LIST_ITEM, MessageType.MAP_LIST_END, maps);
        Collections.sort(maps, new Comparator<UTMap>(){

            @Override
            public int compare(UTMap arg0, UTMap arg1) {
                if (arg0 == null) {
                    if (arg1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                UTMap map1 = arg0;
                UTMap map2 = arg1;
                return map1.mapName.compareToIgnoreCase(map2.mapName);
            }
        });
        return maps;
    }

    private void loadPlayers() throws CantReadException {
        this.owner.getInfo().players = this.loadPlayersInner();
        if (this.owner.getInfo().players == null) {
            this.log.severe("Players NOT loaded.");
        } else {
            this.log.info("Players loaded.");
        }
        CountDownLatch latch = this.owner.getWaitRefreshInfoLatch();
        if (latch != null) {
            latch.countDown();
        }
    }

    private void loadNavPoints(boolean forced) throws CantReadException {
        if (!forced && this.owner.getInfo().navPoints != null) {
            CountDownLatch latch = this.owner.getWaitNavPointsLatch();
            if (latch != null) {
                latch.countDown();
            }
            return;
        }
        this.owner.getInfo().navPoints = this.loadNavPointsInner();
        if (this.owner.getInfo().navPoints == null) {
            this.log.severe("Navpoints NOT loaded.");
        } else {
            this.log.info("Navpoints loaded.");
        }
        CountDownLatch latch = this.owner.getWaitNavPointsLatch();
        if (latch != null) {
            latch.countDown();
        }
    }

    private void loadItems(boolean forced) throws CantReadException {
        if (!forced && this.owner.getInfo().items != null) {
            CountDownLatch latch = this.owner.getWaitItemsLatch();
            if (latch != null) {
                latch.countDown();
            }
            return;
        }
        this.owner.getInfo().items = this.loadItemsInner();
        if (this.owner.getInfo().items == null) {
            this.log.severe("Items NOT loaded.");
        } else {
            this.log.info("Items loaded.");
        }
        CountDownLatch latch = this.owner.getWaitItemsLatch();
        if (latch != null) {
            latch.countDown();
        }
    }

    private void loadAvailableMaps(boolean forced) throws CantReadException {
        if (!forced && this.owner.getInfo().maps != null) {
            CountDownLatch latch = this.owner.getWaitMapsLatch();
            if (latch != null) {
                latch.countDown();
            }
            return;
        }
        this.owner.getInfo().maps = this.loadAvailableMapsInner();
        if (this.owner.getInfo().maps == null) {
            this.log.severe("Available maps NOT loaded.");
        } else {
            this.log.info("Available maps loaded.");
        }
        CountDownLatch latch = this.owner.getWaitMapsLatch();
        if (latch != null) {
            latch.countDown();
        }
    }

    private void loadInventory(boolean forced) throws CantReadException {
        if (!forced && this.owner.getInfo().inventory != null) {
            CountDownLatch latch = this.owner.getWaitInventoryLatch();
            if (latch != null) {
                latch.countDown();
            }
            return;
        }
        if (this.owner.getInfo().items == null) {
            this.loadItems(true);
        }
        List<Item> items = this.owner.getInfo().items;
        HashMap<String, Item> inventory = new HashMap<String, Item>();
        for (Item item : items) {
            Item newItem = ItemCathegories.processItem(item);
            if (newItem != null) {
                inventory.put(newItem.humanName, newItem);
                continue;
            }
            this.log.severe("Unknown item class: " + item.cls);
        }
        this.owner.getInfo().inventory = inventory;
        this.log.info("Inventory loaded.");
        CountDownLatch latch = this.owner.getWaitInventoryLatch();
        if (latch != null) {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagChanged(Object changedValue, int listenerParam) {
        switch (listenerParam) {
            case 1: {
                Boolean communicationAlive = this.isCommunicationAlive();
                if (communicationAlive.booleanValue()) break;
                BlockingQueue<MessageObject> blockingQueue = this.messagesFromGB;
                synchronized (blockingQueue) {
                    this.messagesFromGB.add(new DummyMessage(true));
                    this.requestOrMessageLatch.countDown();
                }
                this.setServerState(UTServerState.UNAVAILABLE);
            }
        }
    }

    public void wakeUpWaiting() {
        this.messagesFromGB.add(new DummyMessage(false));
    }

    public boolean changeMap(String mapName) {
        if (this.owner.getInfo().gameInfo != null && this.owner.getInfo().gameInfo.level.compareToIgnoreCase(mapName) == 0) {
            return false;
        }
        this.request(new UTServerRequestMapChange(mapName));
        return true;
    }

    public boolean changeMapAndWait(String mapName) {
        if (!this.owner.getServerState().equals((Object)UTServerState.RUNNING) && !this.owner.getServerState().equals((Object)UTServerState.PAUSED)) {
            return false;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.owner.getServerStateFlag().addListener(new FlagListener<UTServerState>(){

            @Override
            public void flagChanged(UTServerState changedValue, int listenerParam) {
                switch (changedValue) {
                    case NONE: {
                        latch.countDown();
                        UTServerConnection.this.owner.getServerStateFlag().removeListener(this);
                        break;
                    }
                    case INITIALIZING: {
                        break;
                    }
                    case HANDSHAKE: {
                        break;
                    }
                    case RUNNING: {
                        latch.countDown();
                        UTServerConnection.this.owner.getServerStateFlag().removeListener(this);
                        break;
                    }
                    case PAUSED: {
                        latch.countDown();
                        UTServerConnection.this.owner.getServerStateFlag().removeListener(this);
                        break;
                    }
                    case UNAVAILABLE: {
                        latch.countDown();
                        UTServerConnection.this.owner.getServerStateFlag().removeListener(this);
                        break;
                    }
                    case MAP_CHANGING: {
                        break;
                    }
                    case TERMINATED: {
                        latch.countDown();
                        UTServerConnection.this.owner.getServerStateFlag().removeListener(this);
                    }
                }
            }
        });
        if (!this.mapChanging) {
            if (this.owner.getInfo().gameInfo != null && this.owner.getInfo().gameInfo.level.compareToIgnoreCase(mapName) == 0) {
                return false;
            }
            this.request(new UTServerRequestMapChange(mapName));
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.owner.getServerState().equals((Object)UTServerState.RUNNING) || this.owner.getServerState().equals((Object)UTServerState.PAUSED);
    }

    public void mapFinishedMessageCame() throws UTServerConnectionReinitialization {
        if (this.mapChanging) {
            ++this.mapChangeReconnectAttempt;
            throw new UTServerConnectionReinitialization("MAP_FINISHED message came, reinitializing.");
        }
        this.mapChanging = true;
        this.mapChangeReconnectAttempt = 0;
        this.previousMap = "";
        this.setServerState(UTServerState.MAP_CHANGING);
        throw new UTServerConnectionReinitialization("MAP_FINISHED message came, reinitializing.");
    }

    protected void interruptThread() {
        this.log.warning("Interrupting thread...");
        this.thread.interrupt();
    }
}

