/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.introspection.python;

import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.Property;
import cz.cuni.pogamut.introspection.ScriptProxy;
import cz.cuni.pogamut.introspection.python.PyObjectAdapter;
import cz.cuni.pogamut.introspection.python.PyObjectPlace;
import cz.cuni.pogamut.introspection.python.PyObjectWrapper;
import cz.cuni.pogamut.introspection.python.PyObjectWrappersManager;
import cz.cuni.pogamut.introspection.python.PyUnsupportedWrapper;
import cz.cuni.pogamut.introspection.python.PythonInstrospectableProxy;
import cz.cuni.pogamut.introspection.python.PythonProperty;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.python.core.Py;
import org.python.core.PyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonEngineScriptProxy
extends ScriptProxy {
    private ScriptEngine engine;

    public PythonEngineScriptProxy(ScriptEngine engine) {
        super(engine);
        this.engine = engine;
    }

    @Override
    public String getName() {
        return "PythonEngine";
    }

    private ArrayList<PyObjectAdapter> filterEngineVariables(ScriptEngine engine, boolean hasChildren) {
        ScriptContext context = engine.getContext();
        List<Integer> scopes = context.getScopes();
        int scope = scopes.get(0);
        final Bindings bindings = context.getBindings(scope);
        Set entries = bindings.entrySet();
        PyObjectWrapper wrapper = null;
        PyObjectAdapter adapter = null;
        ArrayList<PyObjectAdapter> list = new ArrayList<PyObjectAdapter>();
        for (Map.Entry entry : entries) {
            final String key = (String)entry.getKey();
            Object value = entry.getValue();
            wrapper = PyObjectWrappersManager.getWrapper(value.getClass());
            if (wrapper instanceof PyUnsupportedWrapper || (hasChildren ? !wrapper.hasChildren(value) : wrapper.hasChildren(value))) continue;
            adapter = new PyObjectAdapter(key, new PyObjectPlace(){
                private Bindings b;
                private String k;
                {
                    this.b = bindings;
                    this.k = key;
                }

                public Object get() {
                    try {
                        return this.b.get(this.k);
                    }
                    catch (Exception e) {
                        return Py.None;
                    }
                }

                public void set(PyObject newValue) {
                    bindings.put(key, (Object)newValue);
                }
            });
            list.add(adapter);
        }
        return list;
    }

    @Override
    protected IntrospectableProxy[] computeChildren(ScriptEngine object) {
        ArrayList<PyObjectAdapter> adapters = this.filterEngineVariables(object, true);
        IntrospectableProxy[] proxies = new IntrospectableProxy[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            proxies[i] = new PythonInstrospectableProxy(adapters.get(i));
        }
        return proxies;
    }

    @Override
    protected Property[] computeProperties(ScriptEngine object) {
        ArrayList<PyObjectAdapter> adapters = this.filterEngineVariables(object, false);
        Property[] proxies = new Property[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            proxies[i] = new PythonProperty(adapters.get(i));
        }
        return proxies;
    }

    public static void main(String[] args) {
        Property[] ps;
        IntrospectableProxy[] ips;
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("python");
        try {
            engine.eval(new InputStreamReader(new FileInputStream(System.getProperty("user.dir") + "\\src\\cz\\cuni\\pogamut\\introspection\\python\\PythonEngineScriptProxyTest.py")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ScriptException e) {
            e.printStackTrace();
            System.exit(1);
        }
        PythonEngineScriptProxy intro = new PythonEngineScriptProxy(engine);
        for (IntrospectableProxy ip : ips = intro.computeChildren(engine)) {
            System.out.println("Children - " + ip.getName());
        }
        for (Property p : ps = intro.computeProperties(engine)) {
            try {
                System.out.println(p.getName() + " = " + p.getValue().toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void closeIntrospection() {
    }
}

